/* SNMPQRY.C */

/*
 * Copyright (C) 1989 - 1992 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 *  Edit History
 * 15-Oct-92	arnoff	created
 * 11-Nov-92	rcq	minor mods to prepare for dev kit insertion
 * 28-Apr-92	rcq	changed <types.h> to <pctcp/types.h>
 * 
*/

#define MAXDESC 100		/* maximum number of descriptors allowed    */
#define TIME_OUT 10		/* ten second time out during talk call	    */
#define RETRY 2			/* two retrys of TIME_OUT len per talk call */
#define MIN_ARGS 3		/* minimum num of args for get		    */

#include <stdio.h>	/* MSC includes */
#include <time.h>
#include <fcntl.h>

#include <pctcp/types.h>	/* pctcp includes */
#include <pctcp/rwconf.h>
#include <pctcp/snmpsys.h>

#ifdef __TURBOC__
extern unsigned stklen = 8000;
#endif

main(argc, argv)
int     argc;
char    *argv[];
{
    snmpTalkType result;		/* snmp response from host	    */
    int err;				/* error code			    */
    char *host = 0;			/* host name			    */
    char *descr[MAXDESC];		/* snmp descriptor		    */
    char *community = "public";		/* community name, 'public' default */
    int command;			/* command type			    */
    register int i;			/* iterator			    */
    int brief = 0;			/* brief print out mode		    */
#define BUF_SIZ (128)			/* size of community name buffer    */
    char buffer[BUF_SIZ];		/* community name buffer	    */

    command = SNMPCMDGET;

    buffer[0] = '\0';			/* null terminate buffer	    */
    
    if (argc < (MIN_ARGS - 1)) {	/* are there enough args?	    */
	printf("\n \
useage: snmpqry {host} {mib_var1 mib_var2 ...}\n \
      host: hostname or IP address of SNMP Agent to query\n \
      mib_var: one or more SNMP MIB variables in either\n \
      ASN.1 encoded object as a symbolic string such\n \
      as _1.3.6.1.2.1.1.1.0 or ;sysdescr_0\n\n \
NOTE: In your PCTCP config file you will need:\n \
         [pctcp snmp]\n \
         trees = c:\\pctcp\\trees.sub\n \
         comm/auth = c:\\pctcp\\communit.aut\n\n \
 The symbol system tl_init() loads is from the mib.sub\n \
 file which is pointed to in contents of trees.sub,\n \
 so you can look in mib.sub for the symbols for each MIB\n \
 entry.  tl_comm_init() initializes the community name\n \
 and uses the comm/auth= setting.  The path for each file\n \
 can differ according to your PCTCP installation.\n\n");
	return 1;
    }
    
    host = argv[1];			/* host name			    */

    for (i = 2; i < argc; i++)		/* fill the list of descriptors	    */
	descr[i-2] = argv[i];
    descr[i-2] = (char *)0;		/* terminate list		    */

    {  /* Display the Mib Variables passed by user at runtime */
	char **d;
	printf ("\nsnmpqry v1.0 (c) 1992 FTP Software, Inc.\n\n");
	printf ("MIB Variables to be queried:\n");
	for (d = descr; *d != (char *)0; d++) printf("   %s\n",*d);
	printf ("\n");
    }

    (void)_find_vec();			/* see if the kernel is loaded	    */

    /* initialize snmp symbol system */
    if ((err = tl_init()) != SNMP_OK) {	
	fprintf(stderr, "tl_init(): %s", tl_error(err));
	return 1;
    }
    
    if (tl_comm_init() != SNMP_OK) {	/* comm/auth pairs defined	    */
	fprintf(stderr, "tl_comm_init(): %s", tl_error(err));
	return 1;
    }
    
    udpSetErrStream(stdout, 1);		/* set network error stream and len */
    
    (void)tl_comm(community, "trivial", (unsigned long)0);/* define communit*/

    if ((err = tl_talk(descr, host, community, &result, command,
	TIME_OUT, RETRY, SOPT_NONE)) > SNMP_OK) {	  /* send and recv  */
	    fprintf(stderr, "\ntl_talk(): %s\n", tl_error(err));
	    return 1;
    }

    /* display result */
    tl_pretty(&result,	/* ptr to return from tl_talk() */
	(int)0,		/* 0 == turn off short format */
	(char *)0,	/* no labels for short format (its not being used) */
	(int)2,		/* 2 == if octet str has 0xd or 0xa print as ASCII */ 
	(char**)0);	/* don't map integers to strings */

    printf("\n");
    if (tl_free(&result) != SNMP_OK) {	/* free struct			    */
	/*fprintf (stderr, "tl_free(): %s", tl_error(err));*/
    }
    
    udpClose();				/* close net connection		    */
    return 0;
} /* end main() */

