/*
 * $Header:   J:/22vcs/srclib/rpcgen/rpc_util.h_v   1.2   13 May 1992 18:03:42   paul  $
 */

/* @(#)rpc_util.h	1.2 87/11/24 3.9 RPCSRC */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
/* @(#)rpc_util.h 1.6 87/06/24 (C) 1987 SMI */

/*
 * rpc_util.h, Useful definitions for the RPC protocol compiler 
 * Copyright (C) 1987, Sun Microsystems, Inc. 
 */
/* Edit history
 *  2-Nov-90	paul	get malloc def from stdlib.h
 * 20-Mar-92	paul	removed proto for sprintf (everyone includes stdio)
 * 23-Mar-92	paul	removed defines f_print, s_print, STOREVAL, FINDVAL
 */

#ifndef MSDOS
extern char *malloc();
#else
#include <stdlib.h>
#endif

#define alloc(size)		malloc((unsigned)(size))
#define ALLOC(object)   (object *) malloc(sizeof(object))

struct list {
	char *val;
	struct list *next;
};
typedef struct list list;

/*
 * Global variables 
 */
#define MAXLINESIZE 1024
extern char curline[MAXLINESIZE];
extern char *where;
extern int linenum;

extern char *infilename;
extern FILE *fout;
extern FILE *fin;

extern list *defined;

/*
 * rpc_util routines
 */
extern char *fixtype(char *type);
extern char *stringfix(char *type);
extern void pvname(char *pname, char *vnum);
extern void ptype(char *prefix, char *type, int follow);
extern int isvectordef(char *type, relation rel);
extern int streq(char *a, char *b);
extern void error(char *msg);
extern void expected1(tok_kind exp1);
extern void expected2(tok_kind exp1, tok_kind exp2);
extern void expected3(tok_kind exp1, tok_kind exp2, tok_kind exp3);
extern void tabify(FILE *f, int tab);
extern void record_open(char *file);
extern void reinitialize(void);
extern char *findval(list *lst, char *val, int (*cmp)());
extern void storeval(list **lstp, char *val);
extern void crash(void);

/*
 * rpc_cout routines 
 */
extern void emit(definition *def);

/*
 * rpc_hout routines 
 */
extern void print_datadef(definition *def);

/*
 * rpc_svcout routines 
 */
extern void write_most(void);
extern void write_register(char *transp);
extern void write_rest(void);
extern void write_programs(char *storage);

/*
 * rpc_clntout routines
 */
extern void write_stubs(void);

/*
 * $Log:   J:/22vcs/srclib/rpcgen/rpc_util.h_v  $
 * 
 *    Rev 1.2   13 May 1992 18:03:42   paul
 *  
 * 
 *    Rev 1.1   30 Jan 1992 00:38:44   arnoff
 *  
 */
