/*
 * $Header:   J:/22vcs/srclib/rpcgen/rpc_hout.c_v   1.2   13 May 1992 18:03:02   paul  $
 */

/* @(#)rpc_hout.c	1.2 87/11/30 3.9 RPCSRC */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#ifndef lint
static char sccsid[] = "@(#)rpc_hout.c 1.6 87/07/28 (C) 1987 SMI";
#endif

/*
 * rpc_hout.c, Header file outputter for the RPC protocol compiler 
 * Copyright (C) 1987, Sun Microsystems, Inc. 
 */
/* Edit history
 *  8-Nov-90	paul	prototyped, added return types to all functions
 * 14-Nov-91	paul	changed to new-style function declarators
 * 20-Mar-92	paul	changed MSC conditionals to MSDOS
 * 23-Mar-92	paul	generate full prototypes and new-style declarators
 *			changed f_print to fprintf
 */

#include <stdio.h>
#ifndef MSDOS
#include "rpc_parse.h"
#else
#include "rpc_pars.h"
#endif
#include "rpc_scan.h"
#include "rpc_util.h"

/*
 * Prototypes
 */
static void pconstdef(definition *def);
static void pstructdef(definition *def);
static void puniondef(definition *def);
static void pdefine(char *name, char *num);
static void puldefine(char *name, char *num);
static int defineprintfed(proc_list *stop, version_list *start);
static void pprogramdef(definition *def);
static void pprocdef(proc_list *proc, version_list *vp);
static void penumdef(definition *def);
static void ptypedef(definition *def);
static void pdeclaration(char *name, declaration *dec, int tab);
static int undefined2(char *type, char *stop);

/*
 * Print the C-version of an xdr definition 
 */
void 
print_datadef(definition *def)
{
	if (def->def_kind != DEF_CONST) {
		fprintf(fout, "\n");
	}
	switch (def->def_kind) {
	case DEF_STRUCT:
		pstructdef(def);
		break;
	case DEF_UNION:
		puniondef(def);
		break;
	case DEF_ENUM:
		penumdef(def);
		break;
	case DEF_TYPEDEF:
		ptypedef(def);
		break;
	case DEF_PROGRAM:
		pprogramdef(def);
		break;
	case DEF_CONST:
		pconstdef(def);
		break;
	}
	if (def->def_kind != DEF_PROGRAM && def->def_kind != DEF_CONST) {
#ifdef OLD_STYLE
		fprintf(fout, "bool_t xdr_%s();\n", def->def_name);
#else
		fprintf(fout, "bool_t xdr_%s(XDR *xdrs, %s *objp);\n", 
			def->def_name, def->def_name);
#endif
	}
	if (def->def_kind != DEF_CONST) {
		fprintf(fout, "\n");
	}
}

static void 
pconstdef(definition *def)
{
	pdefine(def->def_name, def->def.co);
}

static void 
pstructdef(definition *def)
{
	decl_list *l;
	char *name = def->def_name;

	fprintf(fout, "struct %s {\n", name);
	for (l = def->def.st.decls; l != NULL; l = l->next) {
		pdeclaration(name, &l->decl, 1);
	}
	fprintf(fout, "};\n");
	fprintf(fout, "typedef struct %s %s;\n", name, name);
}

static void 
puniondef(definition *def)
{
	case_list *l;
	char *name = def->def_name;
	declaration *decl;

	fprintf(fout, "struct %s {\n", name);
	decl = &def->def.un.enum_decl;
	if (streq(decl->type, "bool")) {
		fprintf(fout, "\tbool_t %s;\n", decl->name);
	} else {
		fprintf(fout, "\t%s %s;\n", decl->type, decl->name);
	}
	fprintf(fout, "\tunion {\n");
	for (l = def->def.un.cases; l != NULL; l = l->next) {
		pdeclaration(name, &l->case_decl, 2);
	}
	decl = def->def.un.default_decl;
	if (decl && !streq(decl->type, "void")) {
		pdeclaration(name, decl, 2);
	}
	fprintf(fout, "\t} %s_u;\n", name);
	fprintf(fout, "};\n");
	fprintf(fout, "typedef struct %s %s;\n", name, name);
}



static void 
pdefine(char *name, char *num)
{
	fprintf(fout, "#define %s %s\n", name, num);
}

static void 
puldefine(char *name, char *num)
{
	fprintf(fout, "#define %s ((u_long)%s)\n", name, num);
}

static int 
defineprintfed(proc_list *stop, version_list *start)
{
	version_list *vers;
	proc_list *proc;

	for (vers = start; vers != NULL; vers = vers->next) {
		for (proc = vers->procs; proc != NULL; proc = proc->next) {
			if (proc == stop) {
				return (0);
			} else if (streq(proc->proc_name, stop->proc_name)) {
				return (1);
			}
		}
	}
	abort();
	/* NOTREACHED */
}


static void 
pprogramdef(definition *def)
{
	version_list *vers;
	proc_list *proc;

	puldefine(def->def_name, def->def.pr.prog_num);
	for (vers = def->def.pr.versions; vers != NULL; vers = vers->next) {
		puldefine(vers->vers_name, vers->vers_num);
		for (proc = vers->procs; proc != NULL; proc = proc->next) {
			if (!defineprintfed(proc, def->def.pr.versions)) {
				puldefine(proc->proc_name, proc->proc_num);
			}
			pprocdef(proc, vers);
		}
	}
}

static void 
pprocdef(proc_list *proc, version_list *vp)
{
	fprintf(fout, "extern ");
	if (proc->res_prefix) {
		if (streq(proc->res_prefix, "enum")) {
			fprintf(fout, "enum ");
		} else {
			fprintf(fout, "struct ");
		}
	}
	if (streq(proc->res_type, "bool")) {
		fprintf(fout, "bool_t *");
	} else if (streq(proc->res_type, "string")) {
		fprintf(fout, "char **");
	} else {
		fprintf(fout, "%s *", fixtype(proc->res_type));
	}
	pvname(proc->proc_name, vp->vers_num);
	fprintf(fout, "();\n");
}

static void 
penumdef(definition *def)
{
	char *name = def->def_name;
	enumval_list *l;
	char *last = NULL;
	int count = 0;

	fprintf(fout, "enum %s {\n", name);
	for (l = def->def.en.vals; l != NULL; l = l->next) {
		fprintf(fout, "\t%s", l->name);
		if (l->assignment) {
			fprintf(fout, " = %s", l->assignment);
			last = l->assignment;
			count = 1;
		} else {
			if (last == NULL) {
				fprintf(fout, " = %d", count++);
			} else {
				fprintf(fout, " = %s + %d", last, count++);
			}
		}
		fprintf(fout, ",\n");
	}
	fprintf(fout, "};\n");
	fprintf(fout, "typedef enum %s %s;\n", name, name);
}

static void 
ptypedef(definition *def)
{
	char *name = def->def_name;
	char *old = def->def.ty.old_type;
	char prefix[8];	/* enough to contain "struct ", including NUL */
	relation rel = def->def.ty.rel;


	if (!streq(name, old)) {
		if (streq(old, "string")) {
			old = "char";
			rel = REL_POINTER;
		} else if (streq(old, "opaque")) {
			old = "char";
		} else if (streq(old, "bool")) {
			old = "bool_t";
		}
		if (undefined2(old, name) && def->def.ty.old_prefix) {
			sprintf(prefix, "%s ", def->def.ty.old_prefix);
		} else {
			prefix[0] = 0;
		}
		fprintf(fout, "typedef ");
		switch (rel) {
		case REL_ARRAY:
			fprintf(fout, "struct {\n");
			fprintf(fout, "\tu_int %s_len;\n", name);
			fprintf(fout, "\t%s%s *%s_val;\n", prefix, old, name);
			fprintf(fout, "} %s", name);
			break;
		case REL_POINTER:
			fprintf(fout, "%s%s *%s", prefix, old, name);
			break;
		case REL_VECTOR:
			fprintf(fout, "%s%s %s[%s]", prefix, old, name,
				def->def.ty.array_max);
			break;
		case REL_ALIAS:
			fprintf(fout, "%s%s *%s", prefix, old, name);
			break;
		}
		fprintf(fout, ";\n");
	}
}


static void 
pdeclaration(char *name, declaration *dec, int tab)
{
	char buf[8];	/* enough to hold "struct ", include NUL */
	char *prefix;
	char *type;

	if (streq(dec->type, "void")) {
		return;
	}
	tabify(fout, tab);
	if (streq(dec->type, name) && !dec->prefix) {
		fprintf(fout, "struct ");
	}
	if (streq(dec->type, "string")) {
		fprintf(fout, "char *%s", dec->name);
	} else {
		prefix = "";
		if (streq(dec->type, "bool")) {
			type = "bool_t";
		} else if (streq(dec->type, "opaque")) {
			type = "char";
		} else {
			if (dec->prefix) {
				sprintf(buf, "%s ", dec->prefix);
				prefix = buf;
			}
			type = dec->type;
		}
		switch (dec->rel) {
		case REL_ALIAS:
			fprintf(fout, "%s%s %s", prefix, type, dec->name);
			break;
		case REL_VECTOR:
			fprintf(fout, "%s%s %s[%s]", prefix, type, dec->name,
				dec->array_max);
			break;
		case REL_POINTER:
			fprintf(fout, "%s%s *%s", prefix, type, dec->name);
			break;
		case REL_ARRAY:
			fprintf(fout, "struct {\n");
			tabify(fout, tab);
			fprintf(fout, "\tu_int %s_len;\n", dec->name);
			tabify(fout, tab);
			fprintf(fout, "\t%s%s *%s_val;\n", prefix, type, dec->name);
			tabify(fout, tab);
			fprintf(fout, "} %s", dec->name);
			break;
		}
	}
	fprintf(fout, ";\n");
}



static int 
undefined2(char *type, char *stop)
{
	list *l;
	definition *def;

	for (l = defined; l != NULL; l = l->next) {
		def = (definition *) l->val;
		if (def->def_kind != DEF_PROGRAM) {
			if (streq(def->def_name, stop)) {
				return (1);
			} else if (streq(def->def_name, type)) {
				return (0);
			}
		}
	}
	return (1);
}

/*
 * $Log:   J:/22vcs/srclib/rpcgen/rpc_hout.c_v  $
 * 
 *    Rev 1.2   13 May 1992 18:03:02   paul
 *  
 * 
 *    Rev 1.1   30 Jan 1992 00:38:10   arnoff
 *  
 */
