/*
 * $Header:   J:/22vcs/srclib/rpcgen/rpc_clnt.c_v   1.2   13 May 1992 18:02:50   paul  $
 */

/* @(#)rpc_clntout.c	1.2 87/11/24 3.9 RPCSRC */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#ifndef lint
static char sccsid[] = "@(#)rpc_clntout.c 1.2 87/06/24 (C) 1987 SMI";
#endif

/*
 * rpc_clntout.c, Client-stub outputter for the RPC protocol compiler
 * Copyright (C) 1987, Sun Microsytsems, Inc.
 */
/* Edit history
 *  8-Nov-90	paul	prototyped, added return types to all functions
 * 14-Nov-91	paul	changed to new-style function declarators
 * 20-Mar-92	paul	changed MSC conditionals to MSDOS
 * 23-Mar-92	paul	generate full prototypes and new-style declarators
 *			changed f_print to fprintf
 */

#include <stdio.h>
#ifndef MSDOS
#include "rpc_parse.h"
#else
#include "rpc_pars.h"
#endif
#include "rpc_scan.h"
#include "rpc_util.h"

/*
 * Prototypes
 */
static void write_program(definition *def);
static char *ampr(char *type);
static void printbody(proc_list *proc);

#define DEFAULT_TIMEOUT 25	/* in seconds */

void 
write_stubs(void)
{
	list *l;
	definition *def;

	fprintf(fout, "\nstatic struct timeval TIMEOUT = { %d, 0 };\n",
		DEFAULT_TIMEOUT);
	for (l = defined; l != NULL; l = l->next) {
		def = (definition *) l->val;
		if (def->def_kind == DEF_PROGRAM) {
			write_program(def);
		}
	}
}


static void 
write_program(definition *def)
{
	version_list *vp;
	proc_list *proc;

	for (vp = def->def.pr.versions; vp != NULL; vp = vp->next) {
		for (proc = vp->procs; proc != NULL; proc = proc->next) {
			fprintf(fout, "\n");
			ptype(proc->res_prefix, proc->res_type, 1);
			fprintf(fout, "*\n");
			pvname(proc->proc_name, vp->vers_num);
#ifdef OLD_STYLE
			fprintf(fout, "(argp, clnt)\n");
			fprintf(fout, "\t");
			ptype(proc->arg_prefix, proc->arg_type, 1);
			fprintf(fout, "*argp;\n");
			fprintf(fout, "\tCLIENT *clnt;\n");
#else
			fprintf(fout, "(");
			ptype(proc->arg_prefix, proc->arg_type, 1);
			fprintf(fout, "*argp, ");
			fprintf(fout, "CLIENT *clnt)\n");
#endif
			fprintf(fout, "{\n");
			printbody(proc);
			fprintf(fout, "}\n\n");
		}
	}
}

static char *
ampr(char *type)
{
	if (isvectordef(type, REL_ALIAS)) {
		return ("");
	} else {
		return ("&");
	}
}

static void 
printbody(proc_list *proc)
{
	fprintf(fout, "\tstatic ");
	if (streq(proc->res_type, "void")) {
		fprintf(fout, "char ");
	} else {
		ptype(proc->res_prefix, proc->res_type, 0);
	}
	fprintf(fout, "res;\n");
	fprintf(fout, "\n");
	fprintf(fout, "\tbzero(%sres, sizeof(res));\n", ampr(proc->res_type));
	fprintf(fout,
		"\tif (clnt_call(clnt, %s, xdr_%s, argp, xdr_%s, %sres, TIMEOUT) != RPC_SUCCESS) {\n",
		proc->proc_name, stringfix(proc->arg_type),
		stringfix(proc->res_type), ampr(proc->res_type));
	fprintf(fout, "\t\treturn (NULL);\n");
	fprintf(fout, "\t}\n");
	if (streq(proc->res_type, "void")) {
		fprintf(fout, "\treturn ((void *)%sres);\n",
			ampr(proc->res_type));
	} else {
		fprintf(fout, "\treturn (%sres);\n", ampr(proc->res_type));
	}
}

/*
 * $Log:   J:/22vcs/srclib/rpcgen/rpc_clnt.c_v  $
 * 
 *    Rev 1.2   13 May 1992 18:02:50   paul
 *  
 * 
 *    Rev 1.1   30 Jan 1992 00:38:02   arnoff
 *  
 */
