/*
 * $Header:   F:/21vcs/srclib/rpcetc/getrpcen.c_v   1.1   30 Jan 1992 00:36:34   arnoff  $
 */

/* @(#)getrpcent.c	1.4 87/11/13 3.9 RPCSRC */
#if !defined(lint) && defined(SCCSIDS)
static  char sccsid[] = "@(#)getrpcent.c 1.9 87/08/11  Copyr 1984 Sun Micro";
#endif

/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
/* Edit history
 * 29-Oct-90	paul	include stdlib.h to fix atol redef error
 * 31-Oct-90	paul	fixed interpret to deal with /etc/rpc lines with 
 *			both tabs and spaces
 * 31-Oct-90	paul	Try environment variable to locate /etc/rpc
 *  8-Nov-90	paul	prototyped, added return types to all functions
 * 14-Nov-91	paul	changed to new-style function declarators
 */

/*
 * Copyright (c) 1985 by Sun Microsystems, Inc.
 */

#include <stdio.h>
#include <stdlib.h>	/* for atol() */
#include <sys/types.h>
#include <rpc/rpc.h>
#include <netdb.h>
#include <sys/socket.h>
#ifdef MSDOS
#include <string.h>
#endif
#include <errno.h>

/*
 * Internet version.
 */
struct rpcdata {
	FILE	*rpcf;
	char	*current;
	int	currentlen;
	int	stayopen;
#define	MAXALIASES	35
	char	*rpc_aliases[MAXALIASES];
	struct	rpcent rpc;
	char	line[BUFSIZ+1];
	char	*domain;
} *rpcdata;

#ifndef	ETC_LOC
#define	ETC_LOC	"FTP_ETC"		/* env. var. pointing to /etc */
#endif

static char RPCDB[] = "/etc/rpc";
#ifdef ETC_LOC
static char *rpcfile = NULL;
static char rpc_tmp[80];
#endif

/*
 * Prototypes
 */
#ifndef MSC
struct rpcent *getrpcbynumber(int number);
#else
struct rpcent *getrpcbynumber(u_long number);
#endif
struct rpcent *getrpcbyname(char *name);
void setrpcent(int f);
void endrpcent(void);
struct rpcent *getrpcent(void);
static struct rpcdata *_rpcdata(void);
#ifdef ETC_LOC
static FILE *open_rpcdb(void);
#endif
static struct rpcent *interpret(char *val, int len);

#ifndef MSC
/* This function isn't even in this file. That's not very portable, is it? */
static	char *index();
#endif

static struct rpcdata *
_rpcdata(void)
{
	register struct rpcdata *d = rpcdata;

	if (d == 0) {
		d = (struct rpcdata *)calloc(1, sizeof (struct rpcdata));
		rpcdata = d;
	}
	return (d);
}

struct rpcent *
getrpcbynumber(
#ifndef MSC
	int number)
#else
	u_long number)
#endif
{
	register struct rpcdata *d = _rpcdata();
	register struct rpcent *p;
	int reason;
	char adrstr[10], *val = NULL;
	int vallen;

	if (d == 0)
		return (0);
	setrpcent(0);
	while (p = getrpcent()) {
		if (p->r_number == number)
			break;
	}
	endrpcent();
	return (p);
}

struct rpcent *
getrpcbyname(char *name)
{
	struct rpcent *rpc;
	char **rp;

	setrpcent(0);
	while(rpc = getrpcent()) {
		if (strcmp(rpc->r_name, name) == 0)
			return (rpc);
		for (rp = rpc->r_aliases; *rp != NULL; rp++) {
			if (strcmp(*rp, name) == 0)
				return (rpc);
		}
	}
	endrpcent();
	return (NULL);
}

#ifdef ETC_LOC
static FILE *
open_rpcdb(void)
{
	register int i;
	
	if (rpcfile = getenv(ETC_LOC)) {
		strcpy(rpc_tmp, rpcfile);
		i = strlen(rpc_tmp);
		i--;
		if ((rpc_tmp[i] == '\\') || (rpc_tmp[i] == '/'))
			rpc_tmp[i] = '\0';
		strcat(rpc_tmp, "\\rpc");
		rpcfile = rpc_tmp;
		}
	else {	
		rpcfile = RPCDB;
		}
	return fopen(rpcfile, "r");
}

void 
setrpcent(int f)
{
	register struct rpcdata *d = _rpcdata();

	if (d == 0)
		return;
	if (d->rpcf == NULL)
#ifndef ETC_LOC
		d->rpcf = fopen(RPCDB, "r");
#else
		d->rpcf = open_rpcdb();
#endif
	else
		rewind(d->rpcf);
	if (d->current)
		free(d->current);
	d->current = NULL;
	d->stayopen |= f;
}

void 
endrpcent(void)
{
	register struct rpcdata *d = _rpcdata();

	if (d == 0)
		return;
	if (d->current && !d->stayopen) {
		free(d->current);
		d->current = NULL;
	}
	if (d->rpcf && !d->stayopen) {
		fclose(d->rpcf);
		d->rpcf = NULL;
	}
}

struct rpcent *
getrpcent(void)
{
	struct rpcent *hp;
	int reason;
	char *key = NULL, *val = NULL;
	int keylen, vallen;
	register struct rpcdata *d = _rpcdata();

	if (d == 0)
		return;
#ifndef ETC_LOC
	if (d->rpcf == NULL && (d->rpcf = fopen(RPCDB, "r")) == NULL) {
#else
	if (d->rpcf == NULL && (d->rpcf = open_rpcdb()) == NULL) {
#endif
		errno = ENOENT;
		return (NULL);
		}
	if (fgets(d->line, BUFSIZ, d->rpcf) == NULL)
		return (NULL);
	return interpret(d->line, strlen(d->line));
}

static struct rpcent *
interpret(char *val, int len)
{
	register struct rpcdata *d = _rpcdata();
	char *p;
	register char *cp, **q;

	if (d == 0)
		return;
	strncpy(d->line, val, len);
	p = d->line;
	d->line[len] = '\n';
	if (*p == '#')
		return (getrpcent());
#ifndef MSC
	cp = index(p, '#');
#else
	cp = strchr(p, '#');
#endif
	if (cp == NULL) {
#ifndef MSC
		cp = index(p, '\n');
#else
		cp = strchr(p, '\n');
#endif
		if (cp == NULL)
			return (getrpcent());
	}
	*cp = '\0';

#ifndef MSC 
/* The Sun version is really broken.  Porting it blindly caused it to choke
   on lines with both spaces and tabs.  Caveat emptor. */
	cp = index(p, ' ');
	if (cp == NULL) {
		cp = index(p, '\t');
		if (cp == NULL)
			return (getrpcent());
	}
#else
	cp = strpbrk(p, " \t");
	if (cp == NULL)
		return (getrpcent());
#endif

	*cp++ = '\0';
	/* THIS STUFF IS INTERNET SPECIFIC */
	d->rpc.r_name = d->line;
	while (*cp == ' ' || *cp == '\t')
		cp++;
#ifndef MSC
	d->rpc.r_number = atoi(cp);
#else
	d->rpc.r_number = atol(cp);
#endif
	q = d->rpc.r_aliases = d->rpc_aliases;

#ifndef MSC
	cp = index(p, ' ');
	if (cp != NULL)
		*cp++ = '\0';
	else {
		cp = index(p, '\t');
		if (cp != NULL)
			*cp++ = '\0';
	}
#else
	cp = strpbrk(p, " \t");
	if (cp != NULL)
		*cp++ = '\0';
#endif

	while (cp && *cp) {
		if (*cp == ' ' || *cp == '\t') {
			cp++;
			continue;
		}
		if (q < &(d->rpc_aliases[MAXALIASES - 1]))
			*q++ = cp;
		
#ifndef MSC
		cp = index(p, ' ');
		if (cp != NULL)
			*cp++ = '\0';
		else {
			cp = index(p, '\t');
			if (cp != NULL)
				*cp++ = '\0';
		}
#else
		cp = strpbrk(p, " \t");
		if (cp != NULL)
			*cp++ = '\0';
#endif
	}
	*q = NULL;
	return (&d->rpc);
}

/*
 * $Log:   F:/21vcs/srclib/rpcetc/getrpcen.c_v  $
 * 
 *    Rev 1.1   30 Jan 1992 00:36:34   arnoff
 *  
 */
