/* @(#)dir_proc.c	1.3 87/11/16 3.9 RPCSRC */
/*
 * dir_proc.c: remote readdir implementation
 */
/* Edit history
 *  1-Nov-90	paul	hacked for dos
 * 23-Sep-92	rcq	changed MSC manifest to MSDOS
 */

#include <stdio.h>
#include <rpc/rpc.h>

#ifdef MSDOS
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <rpc/pmap_cln.h>

#else
extern int errno;
extern char *malloc();
extern char *strcpy();
#include <sys/dir.h>
#include <rpc/pmap_clnt.h>
#endif

#include "dir.h"

#ifdef __TURBOC__
/* this needs lots of stack space */
extern unsigned _stklen = 5000;
#endif


readdir_res *
readdir_1(dirname)
	nametype *dirname;
{
#ifndef MSDOS
	DIR *dirp;
	struct direct *d;
#else
	static struct find_t dir_entry;
#endif
	namelist nl;
	namelist *nlp;
	static readdir_res res; /* must be static! */

	/*
	 * Open directory
	 */
#ifndef MSDOS	
	dirp = opendir(*dirname);
	if (dirp == NULL) {
#else
	if (_dos_findfirst(*dirname, _A_NORMAL|_A_RDONLY|_A_SUBDIR, &dir_entry)) {
#endif
		res.errno = errno;
		return (&res);
	}

	/*
	 * Free previous result
	 */
	xdr_free(xdr_readdir_res, &res);

	/*
	 * Collect directory entries
	 */
	nlp = &res.readdir_res_u.list;
#ifndef MSDOS
	while (d = readdir(dirp)) {
		nl = *nlp = (namenode *) malloc(sizeof(namenode));
		nl->name = malloc(strlen(d->d_name)+1);
		strcpy(nl->name, d->d_name);
		nlp = &nl->next;
	}
#else
	do {
		nl = *nlp = (namenode *) malloc(sizeof(namenode));
		nl->name = malloc(strlen(dir_entry.name)+1);
		strcpy(nl->name, dir_entry.name);
		nlp = &nl->next;
	} while (!_dos_findnext(&dir_entry));
#endif
	
	*nlp = NULL;

	/*
	 * Return the result
	 */
	res.errno = 0;
#ifndef MSDOS
	closedir(dirp);
#endif
	return (&res);
}
