/*
 * $Header:   J:/22vcs/srclib/netlib/vec_srch.c_v   1.2   13 May 1992 13:43:28   paul  $
 */

/*
 * SRCLIB\NETLIB\VEC_SRCH.C
 *
 * Copyright (C) 1986-1992 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 * 
 * EDIT HISTORY:
 * 05-Feb-88	jog	basically lifted from 'old' versions of _find_vec
 * 			 routine
 * 		jbvb	Clean up leftover code.
 * 23-Feb-88	jbvb	Use new pctcp_cleanup() for onexit() shutdown.
 * 24-Feb-88	jbvb	Add logic to turn off DOS BREAK ON, and save old
 *			 state in _dos_break so pctcp_cleanup() can restore
 *			 it when we exit.
 * 27-Feb-88	jbvb	Don't modify syscall interrupt directly - call the
 *			 library to do it.
 * 02-Mar-88	jbvb	Use correct argument to DOS call
 * 14-Dec-89	jbvb	Add signal() calls to catch ^C and abort().
 * 17-Oct-91	paul	added return types, changed to new-style declarators
 * 17-Oct-91	paul	prototype static function
 * 06-Feb-92	paul	changed onexit to atexit for portability
 */

#include <stdlib.h>
#include <dos.h>
#include <signal.h>

#include <pctcp/types.h>
#include <pctcp/pctcp.h>

#define	FIRST_VEC	0x20
#define	LAST_VEC	0xE0

/*
 * Find the PC/TCP kernel vector - returns the vector number, or 0 on failure.
 *
 * If the kernel is active, disable DOS's BREAK (necessary because program
 * might be blocked in a kernel call when ^C is typed).  Use atexit() and
 * signal() to set up three cleanup routines.
 *
 * The routine used by normal exit (pctcp_cleanup(), in CLEANUP.C) just
 * restores break state,frees all kernel resources and returns.
 *
 * The routine used by abort() (pctcp_abort(), in ABORT.C) does an ungraceful
 * close on all network descriptors and calls _exit(3), per the MSC manual.
 *
 * The routine used by the ^C handler (pctcp_ctrlc(), in CTRLC.C) does the
 * same, and invokes _exit(1).
*/

int	_pctcp_int = 0;		/* global which is our syscall interrupt */
int	_dos_break = 0;		/* DL returned from DOS function 33h */

static char match[] = "TCPTSR";

extern void _net_set_vector(unsigned vec_num);
extern void pctcp_cleanup(void);	/* Normal termination cleanup */
extern void pctcp_abort(void);		/* Abnormal termination on ^C */
extern void pctcp_ctrlc(void);		/* Abnormal termination via abort() */

static int check_match(char far *t);

int
vec_search()
{
	char far * (far *vec);		/* Pointer into the interrupt table */
	register int i;
	char far *handler;		/* Pointer to an interrupt handler */
	union REGS reg;

	if (_pctcp_int != 0)			/* Have we already run? */
		return _pctcp_int;	/* YES: don't do it again */

	FP_SEG(vec) = 0;

	for (i = FIRST_VEC; i < LAST_VEC; i++) {
		/* Fixup the pointer into the table
		*/
		FP_OFF(vec) = i << 2;

		/* Get the handler and bump it (hopefully) over the jmp
		*/
		handler = *vec + 3;
		
		/* Check if it points at PC/TCP kernel's service routine.
		*/
		if (check_match(handler)) {
			_pctcp_int = i;		/* set the global variable */

			_net_set_vector(i);	/* Modify library call */

			reg.x.ax = 0x3300;	/* Get BREAK state */
			intdos(&reg, &reg);
			if (reg.h.dl) {			/* Is BREAK on? */
				_dos_break = reg.h.dl;	/* Save old state */
				reg.x.ax = 0x3301;	/* Set BREAK state */
				reg.h.dl = 0;		/*  OFF for PC/TCP */
				intdos(&reg, &reg);
			}			
			/* Hook shutdown functions as needed.
			*/
			atexit(pctcp_cleanup);
			signal(SIGABRT, pctcp_abort);
			signal(SIGINT, pctcp_ctrlc);
			return i;
		}
	}

        return (0);	/* Kernel interrupt not found */
}

static int
check_match(char far *t)
{
	register char *s;
	
	for(s = match; *s; s++)
		if(*t++ != *s)
			return 0;

	return 1;
}

/*
 * $Log:   J:/22vcs/srclib/netlib/vec_srch.c_v  $
 * 
 *    Rev 1.2   13 May 1992 13:43:28   paul
 * changed onexit to atexit for portability
 * updated copyright notice
 * 
 *    Rev 1.1   30 Jan 1992 00:32:10   arnoff
 *  
 */
