;
; $Header:   F:/21vcs/srclib/netlib/syscall7.asv   1.1   30 Jan 1992 00:32:06   arnoff  $
;

;
; SYSCALL7.ASM - Stub to allow C functions to service asynch upcalls
;
; Copyright (C) 1986-1991 by FTP Software, Inc., all rights reserved.
; 
; This software is furnished under a license and may be used and copied
; only in accordance with the terms of such license and with the
; inclusion of the above copyright notice. This software or any other
; copies thereof may not be provided or otherwise made available to any
; other person. No title to and ownership of the software is hereby
; transferred.
; 
; The information in this software is subject to change without notice
; and should not be construed as a commitment by FTP Software, Inc.
;
; Edit History
; 22-Sep-89	jbvb	Split off from SYSCALL3.ASM for 2.04
; 29-Aug-91	Ben	Renamed *.def to *.inc
; 22-Oct-91	paul	removed paths from includes
;

	INCLUDE dos.mac 
	INCLUDE mmodel.inc
	INCLUDE pctcp.inc

; stub routine which we use to get asynch notifications into MSC calls
; sets up a stack frame and then proceeds to do the call.
;
; on entry:
;	BX	network descriptor being notified about
;	CX	event that triggered notification
;	DS:DX	argument passed to handler from kernel
;	ES:DI	'arg' - assumed to be address of MSC routine to call
;

stack_size	=	1200	; enough for eight nestings of 1000 bytes

_DATA	SEGMENT
save_ss	DW	0		; a place to temporarily store our old stack
save_sp	DW	0		; 	pointers
handler	DD	0		; temp to store the called routine in

	PUBLIC	as_stack	; Make the stack visible to the world.
	DW	stack_size DUP(0)
as_stack	DW	0

_DATA	ENDS

_TEXT	SEGMENT

save_ds	DW	0	; place to save the old data segment

	PUBLIC	_asynch_stub
_asynch_stub	PROC	far
	; first we set up our stack frame
	; reentrancy is not necessary.
	mov	cs:[save_ds],ds

	mov	ax,SEG DGROUP
	mov	ds,ax
	mov	[save_ss],ss
	mov	[save_sp],sp

	cli
	mov	ss,ax
	mov	sp,OFFSET DGROUP:as_stack
	sti

	; now our stack is properly set up
	; push arguments on it
	push	cs:[save_ds]	; argument

	push	dx
	push	cx	; event
	push	bx	; nd

	mov	[word ptr handler],di

IFDEF	LCODE
	mov	[word ptr handler+2],es
	call	dword ptr [handler]
ELSE
	call	word ptr [handler]

	mov	ax,SEG DGROUP
	mov	ds,ax
ENDIF

	add	sp,8

	; disable interrupts to make sure we don't get
	; invoked again while we stack hack.

	cli
	; restore the stack
	mov	ss,[save_ss]
	mov	sp,[save_sp]
	sti

	mov	ds,cs:[save_ds]
	ret
_asynch_stub	ENDP

_TEXT	ENDS 
	END 

;
; $Log:   F:/21vcs/srclib/netlib/syscall7.asv  $
;  
;     Rev 1.1   30 Jan 1992 00:32:06   arnoff
;   
;
