;
; $Header:   F:/21vcs/srclib/netlib/syscall4.asv   1.1   30 Jan 1992 00:31:56   arnoff  $
;

;
; SYSCALL4.ASM - Stubs to do less-common name resolution functions.
;
; Copyright (C) 1986,1990,1991 by FTP Software, Inc., all rights reserved.
; 
; This software is furnished under a license and may be used and copied
; only in accordance with the terms of such license and with the
; inclusion of the above copyright notice. This software or any other
; copies thereof may not be provided or otherwise made available to any
; other person. No title to and ownership of the software is hereby
; transferred.
; 
; The information in this software is subject to change without notice
; and should not be construed as a commitment by FTP Software, Inc.
;
; Edit History
; 15-Jun-88	jbvb	Split off from SYSLIB.ASM
; 08-Jul-88	jbvb	Didn't need EXTRN of _neterrno
; 23-Feb-90	jbvb	Add SS_NE_DS conditional, for Windows DLLs.
; 29-Aug-91	Ben	Renamed *.def to *.inc
; 22-Oct-91	paul	removed paths from includes
;

	INCLUDE dos.mac 
	INCLUDE mmodel.inc
	INCLUDE pctcp.inc

; first declare find_vec().
IFDEF	LCODE
	EXTRN	__find_vec:FAR
ELSE
_TEXT	segment
	EXTRN	__find_vec:NEAR
_TEXT	ends
ENDIF


_TEXT	SEGMENT 

	EXTRN	__dosyscall:near
	EXTRN	finish_name:near
	EXTRN	finish_ax0:near

_DATA	SEGMENT 
	EXTRN	inited:word		; have we found the syscall vector?
_DATA	ENDS 

; macro used at start of every function to perform initialization if it
; hasn't happened already
chkinst	MACRO
	LOCAL	okay

	mov	ax,inited
	or	ax,ax
	jnz	okay

	call	__find_vec
	mov	inited,0FFFFh
okay:
	ENDM

; macro to zero out one register (s) if another (r) is already zero
zseg	MACRO	r,s
	LOCAL	done

	or	r,r
	jnz	done

	mov	s,r
done:
	ENDM


; nm_prs_addr(name) 
; 
;	name	DS:DX

	CPROC	_nm_prs_addr

	chkinst

	push	bp 
	mov	bp,sp 
	push	ds 
 
	mov	dx,[bp+SARG] 
IFDEF	LDATA
	mov	ds,[bp+SARG+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss
	mov	ds, ax
ENDIF
ENDIF
	mov	ah,NM_PRS_ADDR 

	call	__dosyscall 
 
	; return value is in dx:ax, where we want it.
                 
	pop	ds 
 
	jmp	finish_name		; Go to common return code.

 _nm_prs_addr	ENDP



; nm_htable(name, cname, len) 
; 
;	name	DS:DX
;	cname	ES:DI
;	len	CX

	CPROC	_nm_htable

	chkinst

	push	bp 
	mov	bp,sp 
	push	di
	push	ds 
 
	mov	dx,[bp+SARG] 
IFDEF	LDATA
	mov	ds,[bp+SARG+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss
	mov	ds, ax
ENDIF
ENDIF
	mov	di,[bp+SARG+SPTR]
IFDEF	LDATA
	mov	es,[bp+SARG+SPTR+2]
ELSE
IFDEF	SS_NE_DS
	mov	es, ax
ELSE
	mov	ax, ds
	mov	es, ax
ENDIF
	zseg	di,es
ENDIF

	mov	cx,[bp+SARG+2*SPTR]
	mov	ah,NM_HTABLE 

	call	__dosyscall 
 
	; Return value is in dx:ax, where we want it.
                 
	pop	ds 
	pop	di

	jmp	finish_name		; Go to common return code.

 _nm_htable	ENDP



; nm_domain(name, cname, len) 
; 
;	name	DS:DX
;	cname	ES:DI
;	len	CX

	CPROC	_nm_domain

	chkinst

	push	bp 
	mov	bp,sp 
	push	di
	push	ds 
 
	mov	dx,[bp+SARG] 
IFDEF	LDATA
	mov	ds,[bp+SARG+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss
	mov	ds, ax
ENDIF
ENDIF
	mov	di,[bp+SARG+SPTR]
IFDEF	LDATA
	mov	es,[bp+SARG+SPTR+2]
ELSE
IFDEF	SS_NE_DS
	mov	es, ax
ELSE
	mov	ax, ds
	mov	es, ax
ENDIF
	zseg	di,es
ENDIF

	mov	cx,[bp+SARG+2*SPTR]
	mov	ah,NM_DOMAIN 

	call	__dosyscall 
 
	; return value is in dx:ax, where we want it.
                 
	pop	ds 
	pop	di
 
	jmp	finish_name	; Go to common error check & return

_nm_domain	ENDP
 

; nm_ien116(name) 
; 
;	name	DS:DX

	CPROC	_nm_ien116

	chkinst

	push	bp 
	mov	bp,sp 
	push	ds 
 
	mov	dx,[bp+SARG] 
IFDEF	LDATA
 	mov	ds,[bp+SARG+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss
	mov	ds, ax
ENDIF
ENDIF
	mov	ah,NM_IEN116 
	call	__dosyscall 
 
	; Return value is in dx:ax, where we want it.
                 
	pop	ds 
 
	jmp	finish_name	; Go to common error check & return

_nm_ien116	ENDP


; ad_res_name(addr, name, len)
;
;	in_name   addr;		DX:BX
;	char far *name;		DS:SI
;	int	  len;		CX

	CPROC	_ad_res_name

	chkinst

	push	bp
	mov	bp,sp
	push	si
	push	ds

	mov	bx,[bp+SARG]	; get the address into dx:bx
	mov	dx,[bp+SARG+2]
	mov	si,[bp+SARG+SLONG]
IFDEF	LDATA
	mov	ds,[bp+SARG+SLONG+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss
	mov	ds, ax
ENDIF
ENDIF
	mov	cx,[bp+SARG+SLONG+SPTR]
	mov	ah,AD_RES_NAME 
 
	call	__dosyscall 
 
	pop	ds
	pop	si
 
	jmp	finish_ax0	; Common error check & return.

_ad_res_name	ENDP



; ad_htable(addr, name, len)
;	in_name   addr;		DX:BX
;	char far *name;		DS:SI
;	int	  len;		CX
;

	CPROC	_ad_htable

	chkinst

	push	bp
	mov	bp,sp
	push	si
	push	ds

	mov	bx,[bp+SARG]	; get the address into dx:bx
	mov	dx,[bp+SARG+2]
	mov	si,[bp+SARG+SLONG]
IFDEF	LDATA
	mov	ds,[bp+SARG+SLONG+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss
	mov	ds, ax
ENDIF
ENDIF
	mov	cx,[bp+SARG+SLONG+SPTR]
	mov	ah,AD_HTABLE

	call	__dosyscall 
 
	pop	ds
	pop	si
 
	jmp	finish_ax0	; Common error check & return

_ad_htable	ENDP


  
; ad_domain(addr, name, len)
;
;	in_name   addr;		DX:BX
;	char far *name;		DS:SI
;	int	  len;		CX

	CPROC	_ad_domain

	chkinst

	push	bp
	mov	bp,sp
	push	si
	push	ds

	mov	bx,[bp+SARG]	; get the address into dx:bx
	mov	dx,[bp+SARG+2]
	mov	si,[bp+SARG+SLONG]
IFDEF	LDATA
	mov	ds,[bp+SARG+SLONG+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss
	mov	ds, ax
ENDIF
ENDIF
	mov	cx,[bp+SARG+SLONG+SPTR]
	mov	ah,AD_DOMAIN
 
	call	__dosyscall 
 
	pop	ds
	pop	si
 
	jmp	finish_ax0

_ad_domain	ENDP



_TEXT	ENDS 
	END 

;
; $Log:   F:/21vcs/srclib/netlib/syscall4.asv  $
;  
;     Rev 1.1   30 Jan 1992 00:31:56   arnoff
;   
;
