;
; $Header:   J:/22vcs/srclib/netlib/syscall3.asv   1.2   17 Jun 1992 15:12:18   paul  $
;

;
; SYSCALL3.ASM - Stubs to do asynch-oriented system calls.
;
; Copyright (C) 1986-1991 by FTP Software, Inc., all rights reserved.
; 
; This software is furnished under a license and may be used and copied
; only in accordance with the terms of such license and with the
; inclusion of the above copyright notice. This software or any other
; copies thereof may not be provided or otherwise made available to any
; other person. No title to and ownership of the software is hereby
; transferred.
; 
; The information in this software is subject to change without notice
; and should not be construed as a commitment by FTP Software, Inc.
;
; Edit History
; 15-Jun-88	jbvb	Split off from SYSLIB.ASM for 2.03
; 22-Sep-89	jbvb	Put asynch_stub() in a module of its own.
; 20-May-91	gub	Add net_config()
; 14-Aug-91	gub	Add get_kernel_info()
; 18-Sep-91	gub	Fix get_kernel_info() call (save regs better)
; 26-Sep-91	gub	Repair net_asynch error return (merge from 2.05)
; 22-Oct-91	paul	removed paths from includes
; 05-Jan-91     irina   added is_kernel_busy code
; 11-Jun-92	paul	renamed *.def to *.inc

	INCLUDE dos.mac 
	INCLUDE mmodel.inc
	INCLUDE pctcp.inc

; first declare find_vec().
IFDEF	LCODE
	EXTRN	__find_vec:FAR
ELSE
_TEXT	segment
	EXTRN	__find_vec:NEAR
_TEXT	ends
ENDIF


_TEXT	SEGMENT 

	EXTRN	__dosyscall:near
	EXTRN	finish_neg1:near	; Common error handler & return
	EXTRN	finish_ax0:near		; Common error handler & return
	EXTRN	fix_pctcp_err:near	; Common error parsing code.

_DATA	SEGMENT 
	EXTRN 	_neterrno:word 	; where we store error codes
	EXTRN	inited:word	; have we found the syscall vector?
_DATA	ENDS 

; macro used at start of every function to perform initialization if it
; hasn't happened already
chkinst	MACRO
	LOCAL	okay

	mov	ax,inited
	or	ax,ax
	jnz	okay

	call	__find_vec
	mov	inited,0FFFFh
okay:
	ENDM

; macro to zero out one register (s) if another (r) is already zero
zseg	MACRO	r,s
	LOCAL	done

	or	r,r
	jnz	done

	mov	s,r
done:
	ENDM


; net_getglobdesc() 
; 
; returns 
;	nd	AX 

	CPROC	_net_getglobdesc

	chkinst

    	push	bp 

	mov	ah,NET_GETGLOBDESC 
         
	call	__dosyscall 

	jmp	finish_neg1 
_net_getglobdesc	ENDP


; net_config(tag, dev_ID, data, size)
;
;	tag	DH
;	dev_ID	DL
;	data	DS:SI
;	size	CX
;

	CPROC	_net_config

	chkinst

	push	bp
	mov	bp,sp
	push	si
	push	ds

	mov	ah,NET_CONFIG
	mov	dh,[bp+SARG]
	mov	dl,[bp+SARG+SINT]
	mov	si,[bp+SARG+2*SINT]
	mov	cx,[bp+SARG+4*SINT]
	mov	ds,[bp+SARG+3*SINT]
	
	call	__dosyscall
	pop	ds
	pop	si

	jmp	finish_neg1
_net_config	ENDP

; get_kernel_info(nd, tag, dev_ID, data, size)
;
;	nd	BX
;	tag	DH
;	dev_ID	DL
;	data	DS:SI
;	size	ES:DI
;

	CPROC	_get_kernel_info

	chkinst

	push	bp
	mov	bp,sp
	push	di
	push	si
	push	es
	push	ds

	mov	ah,GET_KERNEL_INFO
	mov	bx,[bp+SARG]
	mov	dh,[bp+SARG+SINT]
	mov	dl,[bp+SARG+2*SINT]
	mov	si,[bp+SARG+3*SINT]
	mov	ds,[bp+SARG+4*SINT]
	mov	di,[bp+SARG+5*SINT]
	mov	es,[bp+SARG+6*SINT]
	
	call	__dosyscall
	pop	ds
	pop	es
	pop	si
	pop	di

	jmp	finish_neg1
_get_kernel_info	ENDP

; net_asynch(fd, event, handler, hint)
;
;	fd	BX
;	event	CX
;	handler	DS:DX
;	hint	ES:DI
;

	CPROC	_net_asynch

	chkinst

	push	bp 
    	mov	bp,sp 
	push	di
       	push	ds 

    	mov	ah,NET_ASYNCH
    	mov	bx,[bp+SARG]
    	mov	cx,[bp+SARG+SINT]
    	mov	dx,[bp+SARG+2*SINT]
IFDEF	LCODE
	mov	ds,[bp+SARG+2*SINT+2]
ELSE
	push	cs
	pop	ds

	zseg	dx,ds		; in small code models, make ds 0 if dx is
ENDIF
	mov	di,[bp+SARG+2*SINT+SARG-2]
	mov	es,[bp+SARG+2*SINT+SARG]

    	call	__dosyscall 
	mov	di, dx
	mov	dx, ds
	pop	ds			; Restore caller's DS
	jc	net_as_err		; Did call fail?

	mov	ax, di			; NO: Arrange low word for success.
	jmp short net_as_exit

net_as_err:
	call	fix_pctcp_err		; YES: Load neterrno/netsuberrno
    	mov	ax, -1			; Indicate call failed.
	mov	dx, -1

net_as_exit:
	pop	di
    	pop	bp 
	ret 

_net_asynch 	ENDP

; disable_asynch()
; 

	CPROC	_disable_asynch

	chkinst

	mov	ah,DISABLE_ASYNCH 
	call	__dosyscall 
	ret 
 _disable_asynch	ENDP



; enable_asynch() 
; 

	CPROC	_enable_asynch
	chkinst

	mov	ah,ENABLE_ASYNCH 
	call	__dosyscall 
	ret 
 _enable_asynch	ENDP


; net_alarm(fd, time, handler, hint)
;
;	fd	BX
;	time	CX:DX
;	handler	DS:SI
;	hint	ES:DI
;

	CPROC	_net_alarm

	chkinst

	push	bp 
    	mov	bp,sp 
	push	di
	push	si
       	push	ds

    	mov	ah, NET_ALARM
    	mov	bx, [bp+SARG]
    	mov	dx, [bp+SARG+SINT]		; Always a Long.
	mov	cx, [bp+SARG+SINT+2]
    	mov	si, [bp+SARG+SINT+SLONG]	; Function pointer
IFDEF	LCODE
	mov	ds, [bp+SARG+SINT+SLONG+2]	; Size changes with LCODE
ELSE
	push	cs
	pop	ds

	zseg	si,ds		; in small code models, make ds 0 if si is
ENDIF
	mov	di,[bp+SARG+SINT+SLONG+SARG-2]	; Can't use SPTR...
	mov	es,[bp+SARG+SINT+SLONG+SARG]	; Always a Long.

    	call	__dosyscall 

    	pop	ds 
	pop	si
	pop	di

    	jmp	finish_ax0	; Go to common error check and return.
_net_alarm	ENDP

; is_kernel_busy() 
; 

	CPROC	_is_kernel_busy
	chkinst

	mov	ah,IS_KERNEL_BUSY 
	call	__dosyscall 
	ret 
 _is_kernel_busy	ENDP


_TEXT	ENDS 
	END 

;
; $Log:   J:/22vcs/srclib/netlib/syscall3.asv  $
;  
;     Rev 1.2   17 Jun 1992 15:12:18   paul
;  renamed *.def to *.inc
;  
;     Rev 1.1   30 Jan 1992 00:31:52   arnoff
;   
;
