;
; $Header:   J:/22vcs/srclib/netlib/syscall2.asv   1.3   20 Jun 1992 13:49:52   paul  $
;

;
; SYSCALL2.ASM - Stubs to do server-oriented system calls.
;
; Copyright (C) 1986,1990,1991 by FTP Software, Inc., all rights reserved.
; 
; This software is furnished under a license and may be used and copied
; only in accordance with the terms of such license and with the
; inclusion of the above copyright notice. This software or any other
; copies thereof may not be provided or otherwise made available to any
; other person. No title to and ownership of the software is hereby
; transferred.
; 
; The information in this software is subject to change without notice
; and should not be construed as a commitment by FTP Software, Inc.
;
; Edit History
; 15-Jun-88	jbvb	Split off from SYSLIB.ASM for 2.03
; 22-Sep-89	jbvb	Split things up into smaller pieces.
; 23-Feb-90	jbvb	Add SS_NE_DS conditional, for Windows DLLs.
; 29-Aug-91	Ben	Renamed *.def to *.inc
; 22-Oct-91	paul	removed paths from includes
; 17-Jun-92	paul	_get_addr: jmp finish_name to set neterrno
;

	INCLUDE dos.mac 
	INCLUDE mmodel.inc
	INCLUDE pctcp.inc

; first declare find_vec().
IFDEF	LCODE
	EXTRN	__find_vec:FAR
ELSE
_TEXT	segment
	EXTRN	__find_vec:NEAR
_TEXT	ends
ENDIF


_TEXT	SEGMENT 

	EXTRN	__dosyscall:near
	EXTRN	finish_neg1:near	; Common error handler & return
	EXTRN	finish_ax0:near		; Common error handler & return
	EXTRN	finish_name:near	; Common error handler & return

_DATA	SEGMENT 
	EXTRN 	_neterrno:word 	; where we store error codes
	EXTRN	inited:word	; have we found the syscall vector?
_DATA	ENDS 


; macro used at start of every function to perform initialization if it
; hasn't happened already
chkinst	MACRO
	LOCAL	okay

	mov	ax,inited
	or	ax,ax
	jnz	okay

	call	__find_vec
	mov	inited,0FFFFh
okay:
	ENDM

; macro to zero out one register (s) if another (r) is already zero
zseg	MACRO	r,s
	LOCAL	done

	or	r,r
	jnz	done

	mov	s,r
done:
	ENDM


; get_peer(fd, addr) 
; 
;	fd	BX 
;	addr	DS:DX 

	CPROC	_get_peer

	chkinst

	push	bp 
    	mov	bp,sp 
	push	ds		; Save caller's DS
                         
    	mov	dx,[bp+SARG+SINT] 
IFDEF	LDATA
	mov	ds,[bp+SARG+SINT+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss
	mov	ds, ax
ENDIF
ENDIF
    	mov	bx,[bp+SARG] 
    	mov	ah,GET_PEER 

    	call	__dosyscall

	pop	ds		; Restore caller's DS

    	jmp	finish_neg1 
_get_peer	ENDP



; get_addr(nd)
;	int	nd;			BX
;

	CPROC	_get_addr

	chkinst

	push	bp
	mov	bp,sp

	mov	ah,GET_ADDR
	mov	bx,[bp+SARG]
 
	call	__dosyscall 
 
	jmp	finish_name
_get_addr	ENDP


; net_select(maxid, &in, &out) 
; 
;	maxid	BX 
;	in	DS:DX 
;	out	ES:DI 

	CPROC	_net_select

	chkinst

    	push	bp 
    	mov	bp,sp 
    	push	di 
    	push	ds 
         
    	mov	dx,[bp+SARG+SINT] 
IFDEF	LDATA
	mov	ds,[bp+SARG+SINT+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss
	mov	ds, ax
ENDIF
	zseg	dx,ds
ENDIF
	mov	di,[bp+SARG+SINT+SPTR]

IFDEF	LDATA
	mov	es,[bp+SARG+SINT+SPTR+2]
ELSE
IFDEF	SS_NE_DS
	mov	es, ax
ELSE
	mov	ax,ds		; In non-large data models, make ES == DS
	mov	es,ax
ENDIF
	zseg	di,es
ENDIF
    	mov	bx,[bp+SARG]	; Network descr.
    	mov	ah,NET_SELECT 	; Function code

    	call	__dosyscall 

	pop	ds
	pop	di
         
    	jmp	finish_neg1 
_net_select	ENDP


; net_swap(nd1, nd2)
;	int	nd1;			BX
;	int	nd2;			CX

	CPROC	_net_swap

	chkinst

	push	bp
	mov	bp,sp

	mov	ah,NET_SWAP
	mov	bx,[bp+SARG]
	mov	cx,[bp+SARG+SINT]
 
	call	__dosyscall 
 
	jmp	finish_ax0

_net_swap	ENDP


; net_globalize(nd)
;	int	nd;			BX
;

	CPROC	_net_globalize

	chkinst

	push	bp
	mov	bp,sp

	mov	ah,NET_GLOBALIZE
	mov	bx,[bp+SARG]
 
	call	__dosyscall 
 
	jmp	finish_neg1

_net_globalize	ENDP

_TEXT	ENDS 
	END 

;
; $Log:   J:/22vcs/srclib/netlib/syscall2.asv  $
;  
;     Rev 1.3   20 Jun 1992 13:49:52   paul
;  
;     Rev 1.2   17 Jun 1992 15:12:12   paul
;  _get_addr: jmp finish_name to set neterrno
;  
;     Rev 1.1   30 Jan 1992 00:31:48   arnoff
;   
;
