/*
 * $Header:   E:/22vcs/srclib/netlib/pneterro.c_v   1.7   03 Jul 1992 15:55:22   bill  $
 */

/*
 * PNETERRO.C
 *
 * Copyright (C) 1987,1988,1991 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 07-Feb-88	jbvb	Added message for NET_ERR_REENTRY.
 * 17-Feb-88	jbvb	NET_ERR_NOMEM can mean out of connections, too...
 * 19-Feb-88	jbvb	Print messages on stdout for HP
 * 08-Jul-88	jbvb	Add support for netsuberrno, messages.
 * 09-Sep-88	jbvb	Add Sue's form that takes ptr to output routine.
 * 20-Sep-89	jbvb	Add bounds check, no sub-codes on NET_ERR_NOMEM
 * 01-Dec-89	jbvb	Fix ppneterror() to do sub-codes right.
 * 17-Oct-91	paul	changed to new-style declarators
 * 13-Jan-92	gub	Add 2.1-specific errors and NET_SUB_ADMIN_PROHIB
 * 14-Feb-92	davec	added number comments & messages 33 & 34
 * 20-Mar-92	gub	Add message for NET_ERR_PARKED_IN
 * 20-May-92	gub	Add messages 4 NET_ERR_NOQIOS, NET_ERR_WOULD_TRUNCATE
 * 04-Jun-92	kek	**********WARNING************
 *			Please notify a windev person if you add a NET_ERR_*
 *			or NET_SUB_* value BEFORE you submit changes to the 
 *			library. PCTCPAPI.DLL must be updated with the new 
 *			error text.
 * 03-Jul-92	wcl	Added NET_ERR_APPENDED #38
 */

#include <stdio.h>
#include <pctcp/error.h>
#include <pctcp/types.h>
#include <pctcp/pctcp.h>

char *neterr_list[] = {
	"No error",				/*  0 */
	"Address in use",			/*  1 */
	"DOS error",				/*  2 */
	"Out of resources (memory/connections)",/*  3 */
	"Not a network descriptor",		/*  4 */
	"Illegal operation",			/*  5 */
	"Bad packet buffer",			/*  6 */
	"No address for descriptor",		/*  7 */
	"Can't open DOS file",			/*  8 */
	"Network unreachable",			/*  9 */
	"Host unreachable",			/* 10 */
	"Protocol not active in host",		/* 11 */
	"No process listening on socket",	/* 12 */ 
	"Timeout",				/* 13 */
	"Host unknown",				/* 14 */
	"No servers configured",		/* 15 */
	"Bad response from server",		/* 16 */
	"Bad format",				/* 17 */
	"Bad argument to system call",		/* 18 */
	"End of receive",			/* 19 */
	"Connection reset",			/* 20 */
	"Operation would block",		/* 21 */
	"No address bound to descriptor",	/* 22 */
	"Can't allocate descriptor",		/* 23 */
	"Bad system call",			/* 24 */
	"Can't broadcast",			/* 25 */
	"Connection not established",		/* 26 */
	"Kernel re-entered",			/* 27 */
	"got ICMP error",			/* 28 */
        "Kernel unloading",			/* 29 */
	"Configuration tag locked",		/* 30 */
	"Bad interface number",			/* 31 */
	"Configuration incomplete",		/* 32 */
        "Expanded memory error",		/* 33 */
        "Can't unload kernel under a multitasker", /* 34 */
	"Can't release INT2F - not last on chain", /* 35 */
	"No free QIOs",				/* 36 */
	"Datagram would be truncated",		/* 37 */
	"Data appended, packet being held",	/* 38 */
	NULL
	};

char *netsuberr_list[] = {
	"No error",		 		/*  0 */
	"Dest. Unreachable",			/*  1 */
	"ARP failed",				/*  2 */
	"Hardware error",			/*  3 */
	"Link failure",				/*  4 */
	"No route",				/*  5 */
	"Gateway down",				/*  6 */
	"Unknown ICMP msg",			/*  7 */
	"Couldn't fragment",			/*  8 */
	"Source Route failed",			/*  9 */
	"Source Quench",			/* 10 */
	"Time to Live exceeded",		/* 11 */
	"Parameter Problem",			/* 12 */
	"Communication Prohibited",		/* 13 */
	NULL
};

int net_nerr = sizeof(neterr_list)/sizeof(char *) - 2;
int net_nsuberr = sizeof(netsuberr_list)/sizeof(char *) - 2;

static	char	*err_fmt = "%s: %s";
static	char	*sub_fmt = ": %s";

void pneterror(char *s)
{

#ifdef HP
	if ((unsigned)neterrno > MAX_PCTCP_ERR)
		fprintf(stdout, "%s: unknown err (%d)", s, neterrno)
	else
		fprintf(stdout, err_fmt, s, neterr_list[neterrno]);
	if ((neterrno != NET_ERR_NOMEM) && (netsuberrno) &&
	    ((unsigned)netsuberrno < MAX_PCTCP_SUBERR))
		fprintf(stdout, sub_fmt, netsuberr_list[netsuberrno]);
	fputc('\n', stdout);
#else
	if ((unsigned)neterrno > MAX_PCTCP_ERR)
		fprintf(stderr, "%s: unknown err (%d)", s, neterrno);
	else
		fprintf(stderr, err_fmt, s, neterr_list[neterrno]);
	if ((neterrno != NET_ERR_NOMEM) && (netsuberrno) &&
	    ((unsigned)netsuberrno < MAX_PCTCP_SUBERR))
		fprintf(stderr, sub_fmt, netsuberr_list[netsuberrno]);
	fputc('\n', stderr);
#endif
	}

void 
ppneterror(char *s, int (*io_rtn)(char *))
{
	char buf[128];
	int j;

	if ((unsigned)neterrno > MAX_PCTCP_ERR)
		j = sprintf(buf, "%s: unknown err (%d)", s, neterrno);
	else
		j = sprintf(buf, err_fmt, s, neterr_list[neterrno]);
	if ((neterrno != NET_ERR_NOMEM) && (netsuberrno) &&
	    ((unsigned)netsuberrno < MAX_PCTCP_SUBERR))
		sprintf(buf + j, sub_fmt, netsuberr_list[netsuberrno]);
	(*io_rtn)(buf);
}

/*
 * $Log:   E:/22vcs/srclib/netlib/pneterro.c_v  $
 * 
 *    Rev 1.7   03 Jul 1992 15:55:22   bill
 * Added Appended error message
 * 
 *    Rev 1.6   05 Jun 1992 11:24:36   arnoff
 *  04-Jun-92	kek	**********WARNING************
 * 			Please notify a windev person if you add a NET_ERR_*
 * 			or NET_SUB_* value BEFORE you submit changes to the 
 * 			library. PCTCPAPI.DLL must be updated with the new 
 * 			error text.
 * 
 *    Rev 1.5   20 May 1992 15:03:04   arnoff
 * Added messages for NET_ERR_NOQIOS and NET_ERR_WOULD_TRUNCATE.
 * 			--Gub
 * 
 *    Rev 1.4   03 Apr 1992 15:34:12   arnoff
 * Changed the can't unload message to please the DOC people!
 * 
 *    Rev 1.3   23 Mar 1992 17:47:34   arnoff
 * Added new message for NET_ERR_PARKED_IN (int2F patched after us).
 * 		--Gub
 * 
 *    Rev 1.2   17 Feb 1992 16:38:54   arnoff
 * DaveC added error messages #33 & #34
 * 
 *    Rev 1.1   30 Jan 1992 00:31:40   arnoff
 *  
 */
