/*
 *  Filename: ftp_put.c         Programmer: rcq         Date: 11/13/92
 *
 *  Description: Simple demonstration program that takes a filename
 *    from the command line and sends it via FTP to the specifed host.
 *    The primary purpose of the program is to provide an example of
 *    how some of the PC/TCP Ftp library functions are used.
 *
 * Edit History
 *  16-Apr-93	rcq	fixed filespec to be argv[argc-1] not argv[4]
 */

#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <pctcp/types.h>
#include <pctcp/pctcp.h>
#include <pctcp/ftp.h>
#include <pctcp/error.h>
#include <stddef.h>

#ifdef __TURBOC__
extern unsigned stklen = 4000;
#endif

/* int get_failed=0;       This is not needed, but is included in case its
                           not defined in the version of ftp.lib used... */

static int  f_hndl;        /* File Handle of local file being sent */
static char filespec [64]; /* Filename of file being sent */


/* function: put_data()
 *
 * description: get data from file for ftp_put() to send (until EOF).
 */
static int put_data (ftpcon *ftp, char *data, unsigned len) {
	if (data == (char *)0) { /* Ignore the close indication */
		printf ("ftp_put() handler received close indication!\n");
		return 0;
	}

	len = read(f_hndl, data, len);     /* Read Input File */
	if (len<0) {
		perror ("read() ");        /* Error Reading File */
		len = 0;
	} else if (len == 0) {
		printf ("ftp_put() handler closing file %s\n",
			filespec);
		if ((close (f_hndl)) < 0)  /* Close the input file  */
			perror("close(): ");
	} else {
		printf ("    ftp_put() handler read %d bytes from file %s\n", 
			len, filespec);
	}
	return len;        
}

main (int argc, char *argv[]) {
    in_name host;
    ftpcon *ftp;
    int ret, ret2;

    if (argc < 4) {
        printf ("useage: ftp_put {host} {username} [password] {filespec}\n");
        printf ("    host:     hostname or IP address of FTP Server\n");
        printf ("    username: username to logon to FTP Server with\n");
        printf ("    password: username's password (if required)\n");
        printf ("    filespec: name of file to send\n");
        exit(1);
    } else {
	printf ("connecting to host: %s\n", argv[1]);
	printf ("          username: %s\n", argv[2]);
	printf ("      file to send: %s\n", argv[argc-1]);
    }
  
    /* Get file specification for file we want to send and open it*/
    strcpy (filespec, argv[argc-1]);
    if ((f_hndl = open (filespec, O_RDWR, 0)) < 0) {
	printf ("filename: %s",filespec);
	perror ("open(): ");
	exit (1);
    }
  
    host = nm_res_name(argv[1], (char *)NULL, 0);
    if (host == 0) {
	pneterror("nm_res_name");
	exit(1);
    }
    
    ftp = ftp_open(host, 256, 512, 0);
    if (ftp == NULL){
	pneterror("ftp_open");
	exit(1);
    }
    else
	    printf ("\nConnected to %s\n", argv[1]);
    
    ret = ftp_user (ftp, argv[2]);
    switch (ret) {
	    case FTP_ERROR:
		    printf ("ftp_user failed: %s\n", ftp_msgbuf(ftp));
		    break;
	    case FTP_GOAHEAD:
		    printf ("\nNo User Password required!\n");
		    break;
	    case FTP_NEED_PASSWORD:
		    if (argc < 4) {
			    printf ("ERROR: Password req'd, not provided!\n");
			    break;
		    }
		    else {
			    ret2 = ftp_pass(ftp, argv[3]);
			    switch (ret2) {
				    case FTP_ERROR:
					    printf ("ftp_user failed: %s\n", 
						    ftp_msgbuf(ftp));
					    break;
				    case FTP_GOAHEAD:
					    printf ("\nUser Password OK!\n");
					    break;
				    case FTP_NEED_ACCOUNT:
					    printf("\nAccount Name req'd!\n");
			    }
		    }
    }
    
    /* Send (put) the file already! */
    if (!ftp_put(ftp, filespec, 0, put_data)) {
	    printf ("ftp_put failed: %s\n", ftp_msgbuf(ftp));
	    perror ("ftp_put(): ");
    }
        
    /* Close the ftp connection */
    printf ("Closing ftp connection...\n");
    ftp_close(ftp);
}

