/*
 * $Header:   J:/pctcp.dos/vcs/dosapps/cookie/src/vrfy.c_v   1.3.1.0   28 Apr 1993 13:56:00   rcq  $
 */

/*
 * VRFY.C
 *
 * Copyright (C) 1988,1991 by FTP Software, Inc.
 * 
 * This program is provided as an example of the use of the PC/TCP
 * Developer's Kit socket library.  This program, or modified versions
 * thereof, may be freely distributed, provided that this notice is
 * retained in any modifed versions.
 *
 *
 * Description:
 *
 * This program is a example client which verifies a user's mail address
 * (given on the command line) via the TCP-based Simple Mail Transfer
 * Protocol, as described in RFC 821.  It obtains the verification via the
 * SMTP port (port 25) from the host specified on the command line.
 *
 * Edit History
 * 04-Sep-91	Ben	Cleaned up for compling with -W3.
 * 12-Nov-91	paul	changed to new-style declarators, added return types,
 *			changed forever loop from while(1) to for(;;)
 * 16-Jun-92	paul	set stack size for Turbo/Borland version
 * 28-Apr-93	rcq	changed "mail" service request to "smtp"
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <process.h>			/* for exit () */
#include <errno.h>

#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <pctcp/types.h>
#include <arpa/inet.h>

void 	handle_mesg (int sock, char *buf);
void 	pr_notice(char *);
   
/* If you haven't defined a buffer size elsewhere, define it here */
#ifndef	BUFSIZ
#define	BUFSIZ	256
#endif

#ifdef __TURBOC__
extern unsigned _stklen = 4000;
#endif

void
main (int argc, char *argv[])
{
	/* General purpose re-usable holders for things */
	int	flag;
	static	char	buf[BUFSIZ];

	/* The socket number */
	int	sock;

	/* Buffer for my hostname */
	static	char	Me[BUFSIZ/2];
	
	/* Buffer for my domain name */
	static	char	Domain[BUFSIZ/2];
	
	/* Pointer to the @ in the hostname argument (if supplied) */
	char	*At;
	
	/* Pre-defined 4bsd structures (as emulated by PC/TCP) */
	struct	sockaddr_in dest;
	struct	servent *serv_ptr;
	struct	hostent *host_ptr;
	struct	linger	ling;		/* Introduced in 4.3 */
	fd_set		rdfds;

	/* Print out version information when requested */
	if ((argc == 2) && (strcmp(argv[1], "-version") == 0)) {
		pr_notice("vrfy");
		exit(0);
	}

	/* Start out with the @ pointer to NULL */
	At = NULL;
		
	/* Print out usage information if they didn't type the args
		correctly, and set the @ pointer, if supplied */
	if (argc < 3) {
		if ((At = strchr(argv[1],'@')) == NULL) {
		       puts("usage:\t'vrfy name@host' OR 'vrfy name host'");
		       exit(1);
		} else

			/* Replace the @ with a NULL; then argv[1] points to
				the NULL terminated name string and At
				points to the host name */
			*At++ = '\0';
	}

	/* Get a pointer to a structure describing the smtp (mail) service */
	serv_ptr = getservbyname("smtp", "tcp");
	if (serv_ptr == NULL) {
		puts("getservbyname failed");
		exit(1);
	}

	/* Get a pointer to a structure describing the destination host */
	if (At)
		host_ptr = gethostbyname(At);
	else
		host_ptr = gethostbyname(argv[2]);

	if (host_ptr == NULL) {
		perror("gethostbyname");
		exit(1);
	}

	/* Copy pieces of the structures obtained above into the dest
	 * structure to be used in creating a socket:
	 *	1 the only supported protocol family is the Internet family
	 *	2 we got the destination port from the getservbyname call
	 *	3 we got the destination address from the gethostbyname call
	*/
	dest.sin_family = AF_INET;
	dest.sin_port = serv_ptr->s_port;
	bcopy(host_ptr->h_addr, &dest.sin_addr, host_ptr->h_length);

	/* Create a socket */
	sock = socket(AF_INET, SOCK_STREAM, 0);
	if (sock == -1) {
		perror("socket");
		exit(1);
	}

	/* Set SO_LINGER option on the socket, preparing for graceful close
	*/
	ling.l_onoff = 1;		/* We want to linger */
	ling.l_linger = 10;		/*  but only for 10 seconds */
	flag = setsockopt(sock, SOL_SOCKET, SO_LINGER, (char *)&ling,
		sizeof(struct linger));
	if (flag == -1) {
		perror("setsockopt");
		exit(1);
	}

	/* Open the STREAM (TCP) connection on the socket */
	flag = connect(sock, (struct sockaddr *) &dest, sizeof(dest));
	if (flag == -1) {
		perror("connect");
		exit(1);
	}

	/* Call handle_mesg() to read and print the SMTP opening banner */
	handle_mesg(sock, buf);

	/* Retrieve the name of the domain from the ipconfig structure */
	if(getdomainname(Domain, sizeof(Domain)) < 0) {
		perror("GETDOMAINNAME");
		exit(1);
	}
	
	/* Retrieve the name of the host from the ipconfig structure */
	if(gethostname(Me, sizeof(Me)) < 0) {
		perror("GETHOSTNAME");
		exit(1);
	}

	/* Send a HELO message using the domain name and host we just got */
	flag = sprintf(buf, "HELO %s.%s\r\n", Me, Domain);
	flag = write(sock, buf, flag);
	if (flag == -1) {
		perror("write");
		exit(1);
	}
	
	/* Call handle_mesg() to read and print the SMTP response from HELO */
	handle_mesg(sock, buf);

	/* Send the VRFY token with the name argument from the command line */
	flag = sprintf(buf, "VRFY %s\r\n", argv[1]);
	flag = write(sock, buf, flag);
	if (flag == -1) {
		perror("write");
		exit(1);
	}
	
	/* Check to see if there is queued data available for reading; if
	 * there is no data waiting, block indefinitely until data arrives
	 */
	FD_SET(sock, &rdfds);
	flag = select(sock + 1, &rdfds, (fd_set *)NULL, (fd_set *)NULL,
		(struct timeval *)NULL);
	if (flag == -1) {
		perror("select 1");
		exit(1);
	}

	/* Call handle_mesg() to read and print the reply to the VRFY token
		we sent */
	handle_mesg(sock, buf);

	/* tell SMTP that we want to close the connection */
	flag = write(sock, "QUIT\r\n", 6);
	if (flag == -1) {
		perror("write");
		exit(1);
	}

	/* Since we set SO_LINGER, even if the connection hasn't closed by
		now, we will get a graceful close */
	close(sock);
	exit(0);
	/* If MSC complains about "no return value", please ignore it. */
	/* MSC wants a return(), even though there is an exit() here. */
}

/* This routine consists of an infinite loop which reads the data in from
 * the connection one character at a time, spooling up a line at a time.
 * The SMTP spec says that a multiline message ends when a message contains
 * a space between the code and the data on the line as follows:
 *		250-foo
 *		250-bar
 *		250 baz
 * So we break out of the loop when the 4th character on the line is a space.
*/

void
handle_mesg (
	int sock,			/* socket to get message from */
	char *buf)			/* buffer address */
{
	char	*c;			/* pointer for reading in string */
	buf[0] = '\0';
	c = buf;
	for (;;) {
		
		/* Get a single character into c and check to see if the
			connection has been closed on us */
		if (recv(sock, c, 1, 0) == 0) {
			printf("Connection closed abnormally\r\n");
			exit(1);
		}
		
		/* If next character would overflow buffer let them know */
		if (((c + 1) - buf) > BUFSIZ) {
			printf("Line overflowed the buffer\r\n");
			printf("Line: %s\r\n", buf);
			break;
		}

		/* Two ways have been established to terminate SMTP input...
			The SMTP spec says to end data with a CRLF.
			However, UNIX implementations end with a newline
			character.  Therefore, if this is a UNIX Newline,
			terminate this line of input here. */
		if (*c == '\n') {
			*c = '\0';

			/* Otherwise, if we don't get a blank line and this
			 * is legal SMTP syntax, terminate line of input here.
			 */
			if ((c > buf) && (*(c - 1) == '\r')) {
				*(--c) = '\0';
			}
			
			/* Since we've got a complete line, print it out */
			puts(buf);

			/* The spec says that if there is a space instead of
			 * a hyphen after the return code, that will be the
			 * last line
			 */
			if (buf[3] == ' ') {
				break;
			}

			/* Reset the point back to the beginning of the
			 * buffer for the next line of input
			 */
			c = buf;
		}

		/* If not end of line, increment pointer to input buffer */
		else {
			c++;
		}
	}
}

/*
 * $Log:   J:/pctcp.dos/vcs/dosapps/cookie/src/vrfy.c_v  $
 * 
 *    Rev 1.3.1.0   28 Apr 1993 13:56:00   rcq
 * changed "mail" service name request to more proper "smtp"
 * 
 *    Rev 1.3   20 Jul 1992 19:29:48   paul
 * set stack size for Turbo/Borland version
 * 
 *    Rev 1.2   03 Feb 1992 21:12:46   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.1   29 Jan 1992 20:00:08   arnoff
 *  
 */
