/*
 * $Header:   J:/22vcs/srccmd/cookie/cookie.c_v   1.5   14 Sep 1992 13:08:24   natalia  $
 */

/*
 * COOKIE.C
 *
 * Copyright (C) 1986-1992 by FTP Software, Inc.  All rights reserved.
 * 
 * This program is provided as an example of the use of the PC/TCP
 * Developer's Kit library routines. This program, or modified versions
 * thereof, may be freely distributed, provided that this notice is
 * retained in any modifed versions.
 *
 *
 * Description:
 *
 * This program is a client for the UDP-based "Quote of the Day Protocol",
 * as described in RFC 865.  It obtains the IP address of a server either
 * from the command line (possibly via a name resolver or host table), or
 * from the IPCUST configuration entry.  It sends an empty datagram to the
 * proper port, and waits COOKIETMO seconds for a reply.  It then writes
 * the reply to stdout and exits.  The name "Cookie" has its roots in the
 * pithy sayings found in Chinese fortune cookies.
 *
 * Edit History
 * 02-Mar-88	jbvb	Added casts of NULL for large data models, comments.
 * 13-Dec-89	jbvb	More casts for ANSI C prototypes.
 * 26-Jun-91	Ben	Use getconf() instead of get_ipconfig().
 * 08-aug-91	Ben	Added check for "-?"
 * 04-Sep-91	Ben	Cleaned up for compling with -W3.
 * 15-Oct-91	Ben	Check for empty string from getconf.
 * 12-Nov-91	paul	changed to new-style declarators, added return types
 * 05-Jan-92	arnoff	check of pvcs system.
 * 31-Mar-92	Ben	Replaced nm_prs_addr() with nm_res_name().
 * 16-Jun-92	paul	set stack size for Turbo/Borland version
 */

#include <stdio.h>			/* From Microsoft C */
#include <string.h>
#include <process.h>			/* for exit () */

#include <pctcp/types.h>
#include <pctcp/pctcp.h>
#include <pctcp/sockets.h>
#include <pctcp/options.h>
#include <pctcp/error.h>
#include <pctcp/rwconf.h>

#define	COOKIETMO	10		/* Wait 10 seconds for a response */

#ifdef __TURBOC__
extern unsigned _stklen = 5000;
#endif

void
main(int argc, char *argv[])
{
	in_name	fhost;			/* The cookie server's IP address */
	int	cookie_con;		/* The network descriptor */
	char	buf[512];		/* A buffer for the cookie */
	int	len;			/* Length of the cookie */
	struct	addr a;			/* Destination of cookie request */

	if ((argc == 2) && (strcmp(argv[1], "-version") == 0)) {
		pr_notice("cookie");
		exit(0);
	}

	if ((argc > 2) || (strcmp (argv[1], "-?") == 0)) {
		printf("usage:  cookie [server]\n");
		exit(1);
	}
	/*
	 * A 2nd argument that isn't "-version", should be a server name or
	 * address.  Try to convert it to a binary IP address (in_name).
	 */
	if (argc == 2) {
		fhost = nm_res_name(argv[1], (char *) NULL, 0);
		if (fhost == 0) {
			pneterror("can't resolve cookie server name");
			exit(1);
		}
	} else {			/* No server specified: try to use */
		char	srv_str [16];	/*  the configured server */
		
		if (!getconf ("addresses", "cookie-server", srv_str, sizeof (srv_str)) ||
		    (strlen (srv_str) == 0)) {
		    printf("No cookie server configured via config!\n");
		    exit(1);
		}
		config_close (0);
		
		fhost = nm_res_name (srv_str, NULL, 0);
	}

	/* Set up the address of the cookie server we want to use.
	*/
	a.lsocket = 0;
	a.fsocket = SOCK_UDP_COOKIE;
	a.fhost = fhost;

	/* Open the UDP "connection" (datagram port)
	*/
	cookie_con = net_connect(-1, DGRAM, &a);
	if (cookie_con < 0) {
		printf("Can't open cookie connection.\n");
		pneterror("net_connect");
		net_releaseall();
		exit(1);
	}
	/* Write an empty datagram to the server (request packet).
	*/
	if (net_write(cookie_con, (char *) NULL, 0, 0) < 0) {
		pneterror("net_write");
		printf("Can't send cookie request packet!\n");
		net_releaseall();
		exit(1);
	}
	/* Set timeout (so we won't wait forever for a packet).
	*/
	set_option(cookie_con, DGRAM, NET_OPT_TIMEOUT,
		(char far *)(COOKIETMO*1000L), sizeof(long));

	/* Try to read a packet, length less than 0 indicates error.
	*/
	len = net_read(cookie_con, buf, 512, (struct addr *) NULL, 0);
	if (len < 0) {
		pneterror("Error reading cookie packet: net_read");
		net_releaseall();
		exit(1);
	}
	buf[len] = '\0';		/* Make sure message is terminated */
	puts(buf);			/* Write cookie to stdout */
	net_release(cookie_con);
	exit(0);			/* All done, successful. */
}

/*
 * $Log:   J:/22vcs/srccmd/cookie/cookie.c_v  $
 * 
 *    Rev 1.5   14 Sep 1992 13:08:24   natalia
 * changed <rwconf.h> to <pctcp/rwconf.h>
 * 
 *    Rev 1.4   20 Jul 1992 19:28:46   paul
 * set stack size for Turbo/Borland version
 * 
 *    Rev 1.3   31 Mar 1992 14:36:16   arnoff
 * Replaced nm_prs_addr() with nm_res_name().   ---Ben
 * 
 *    Rev 1.2   03 Feb 1992 21:12:40   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.1   29 Jan 1992 20:00:04   arnoff
 *  
 */
