/*
 * $Header:   J:/devkit.dos/vcs/srcsmpl/alarm/src/listen.c_v   1.4.1.0   28 Apr 1993 14:21:06   rcq  $
 */

/*
 * LISTEN.C - TSR message printer for Alarm system
 *
 * Copyright (C) 1986-1991 by FTP Software, Inc.  All rights reserved.
 * 
 * This program is provided as an example of the use of the PC/TCP
 * Developer's Kit library routines. This program, or modified versions
 * thereof, may be freely distributed, provided that this notice is
 * retained in any modifed versions.
 *
 * Description:
 *
 * This is the server side of a simple UDP-based network protocol for
 * displaying short messages from other hosts.  The message is displayed
 * and an acknowlegement is sent (containing the text of the message).
 *
 * Bugs: Since it was written as an example of the PC/TCP asynchronous
 *	 notification facilities, the protocol doesn't have any way of
 *	 naming a specific user at a (multi-user) host.  Use SMTP instead.
 *
 *	 The server is very DOS-specific, acting as a TSR and using the
 *	 Video BIOS interrupt to display the message.
 *
 *	 Only 80 characters can be displayed, and only 128 characters
 *	 of message can be acknowleged correctly.  It doesn't understand
 *	 that screens might not be 25x80.
 *
 * Edit History
 * 30-Jul-87	jbvb	Begun.
 * 31-Jul-87	jbvb	More work.
 * 04-Aug-87	jbvb	Use NET_AS_RCV instead of NET_AS_RCVFLUSH, then
 *			 do net_read() in asynch handler.
 * 19-Sep-87	jbvb	Fix several bugs in net function calls.
 * 30-Dec-88	jbvb	Free extra memory
 * 21-Sep-89	jbvb	Convert to Video BIOS display writes.
 * 30-Aug-91	Ben	Compiled with -W3
 * 12-Nov-91	paul	change to new-style declarators, add return types
 * 20-Jul-92	paul	play with TSR size calculation for Borland C++
 * 08-Oct-92	rcq	changed "MSC" macro to "_MSC_VER" for MSC7
 * 28-Apr-93	rcq	added "-d" cmd line description and fixed so usage
 *			 message will print
 */

#include <stdio.h>
#include <string.h>
#include <process.h>
#include <time.h>
#include <conio.h>
#include <dos.h>		/* Microsoft C DOS definitions */

#include <pctcp/types.h>
#include <pctcp/pctcp.h>
#include <pctcp/error.h>
#include <pctcp/asynch.h>

#include "alarm.h"

extern	void	ring(void);	/* ring the bell; lives in spc.lib	*/

static	int	display_msg(int	alarm_con);

static	int	error_flag = 0;		/* Asynch upcall puts neterrno here */
static	union	REGS	regs;		/* General purpose registers */
static	union	REGS	cregs;		/* Registers for cursor position */
static	union	REGS	wregs;		/* Registers for write char */

void
main(int argc, char *argv[])
{
	int	alarm_con;	      /* Keep network descriptor here */
	int	terminate = TRUE;
	struct	addr a;		      /* Address & port for UDP connection */
	struct	SREGS seg;	      /* Save our segment values here */
	unsigned mem;		      /* For "memory used" calculation */
	char	far *fool_msc;	      /* Workaround for spurious conversion */
#ifdef _MSC_VER
	extern	int end;	      /* MSC puts this at end of data */
#endif /* _MSC_VER */
#ifdef __TURBOC__
	extern unsigned _psp;	      /* segment address of PSP */
	extern unsigned __heapbase;   /* undoc base of TC heap area */
#endif /* __TURBOC__ */

	if (argc > 1) {
		if (strcmp(argv[1], "-version") == 0) {
			pr_notice("listen");
			exit(0);
		} else if (strcmp(argv[1], "-d") == 0) {
			terminate = FALSE;
			puts("Hit any key to terminate");
		} else {
		    puts("usage: listen [-d]");
		    puts("   -d: debug mode (runs realtime not in TSR)");
		    exit(1);
		}
	}

	segread(&seg);			/* Get segments... */

	/* Initialize argument blocks (tiresome to do statically)
	*/
	cregs.h.ah = SET_CURSOR;
	cregs.h.bh = 0;			/* Display page 0 */
	wregs.h.ah = WRITE_CHAR;
	wregs.h.bh = 0;
	wregs.x.cx = 1;			/* Write 1 character */
	wregs.h.bl = 0x70;		/* Attrib = white on black */

	a.lsocket = SOCK_ALARM_RECV;
	a.fsocket = 0;			/* Leave remote port unspecified */
	a.fhost = 0L;

	/* Get a global network descriptor (DOS-independent, for asynch).
	*/
	alarm_con = net_getglobdesc();	/* Explicit release needed */
	if (alarm_con < 0) {
		pneterror("net_getglobdesc");
		puts("listen: can't get global nd.");
		exit(1);
	}
	/* Establish the UDP connection we will use.
	*/
	if (net_connect(alarm_con, DGRAM, &a) < 0) {
		pneterror("net_connect");
		puts("listen: can't open to network.");
		net_release(alarm_con);		/* Explicitly free global */
		exit(1);
	}
	/* Set up the C asynch event handler for incoming messages
	*/
	FP_SEG(fool_msc) = seg.cs;		/* Get correct CS value */
	FP_OFF(fool_msc) = (unsigned)display_msg;
	if ((long) net_asynch(alarm_con, NET_AS_RCV, asynch_stub,
			(unsigned long)fool_msc) < 0) {
		pneterror("net_asynch");
		puts("listen: error setting asynch handler");
		net_release(alarm_con);		/* Explicitly free global */
		exit(1);
	}
	/* For debugging, spin here and let the asynch upcall print.
	*/
	while (!terminate) {
		if (kbhit()) {			/* Exit on any keystroke */
			net_release(alarm_con);
			puts("Exiting");
			exit(1);
		}
		disable_asynch();		/* So we don't miss errors */
		if (error_flag) {
			pneterror("in asynch routine");
			error_flag = 0;
		}
		enable_asynch();		/* Let upcall run again */
	}
	/*
	 * Everything is set up, tell DOS how much memory we're leaving
	 * behind.  Note that this technique frees everything in the data
	 * segment except global and static variables.  The startup stack
	 * vanishes, as does everything that was malloc'ed.
	 *
	 *		data		code	    extra
	 */
#ifdef _MSC_VER
	mem = ((unsigned)&end)/16 + seg.ds - seg.cs + 20;
#endif /* _MSC_VER */
#ifdef __TURBOC__
	mem = ((__heapbase + 16) >> 4) + seg.ds - _psp;
#endif /* __TURBOC__ */
	printf("Listen occupies %lu bytes\n", ((long)mem)*16L);

	bdos(0x31, (unsigned)mem, 0x00);	/* Terminate/stay resident */
						/*  (should not return!) */
	puts("Listen couldn't terminate & stay resident!");
	net_release(alarm_con);			/* explicit cleanup needed */
	exit(1);
}

/*
 * display_msg() - write the contents of the incoming UDP datagram on the
 * screen, using Video BIOS to avoid DOS re-entrancy (the worst that can
 * happen, I'm told, is that your cursor gets trashed...).
 */
static	int
display_msg(int alarm_con)		/* Connection event was on */
{
	char	read_buf[128];		/* A buffer for the data */
	int	temp = 0;
	int	len;			/* Length of the data in packet */
	int	oldpos;			/* Saved BIOS cursor position */
	struct	addr	reply_to;	/* IP address message came from */

	/*
	 * Now, drain data from queue (and find out who we have to reply
	 * to as a side effect).  Then, print it.
	 */
	if ((len = net_read(alarm_con, read_buf, sizeof(read_buf),
			    (struct addr *) &reply_to, 0)) == -1) {
		error_flag = neterrno;	/* So mainline can print it */
		return (1);
	}
	/* Send the confirmation back to the source host.
	*/
	if (net_writeto(alarm_con, read_buf, len, &reply_to, 0) == -1) {
		error_flag = neterrno;
		return (1);
	}
	/* Get the current BIOS cursor position.
	*/
	regs.h.ah = GET_CURSOR;		/* BIOS read cursor position */
	regs.h.bh = 0;			/*  active page is 0 */
	int86(VIDEO_IO, &regs, &regs);	/* Do the interrupt */
	oldpos = regs.x.dx;

	/* Set cursor positioning register struct to line 25, column 1
	*/
	cregs.h.dh = 24;
	cregs.h.dl = 0;

	if (len > 80)			/* Trim data to fit screen */
		len = 80;

	/* For each character, position the cursor, then write character. 
	*/
	for (temp = 0; temp < len; temp++) {
		int86(VIDEO_IO, &cregs, &regs);	/* Set the cursor. */
		wregs.h.al = read_buf[temp];	/* Get the next character, */
		int86(VIDEO_IO, &wregs, &regs);	/*  write it to the screen */
		cregs.h.dl++;			/*  & move to next position */
	}
	/* Put the cursor back where it was when we were called & alert user.
	*/
	cregs.x.dx = oldpos;
	int86(VIDEO_IO, &cregs, &regs);
	ring();				/* Beep the bell */
	return(0);			/*  & return to the kernel */
}

/*
 * $Log:   J:/devkit.dos/vcs/srcsmpl/alarm/src/listen.c_v  $
 * 
 *    Rev 1.4.1.0   28 Apr 1993 14:21:06   rcq
 * fixed usage to it will display
 * 
 *    Rev 1.4   08 Oct 1992 09:54:40   rcq
 * changed 'MSC' manifest to "_MSC_VER' to work with MSC7
 * 
 *    Rev 1.3   20 Jul 1992 19:02:10   paul
 * play with TSR size calculation for Borland C++
 * 
 *    Rev 1.2   03 Feb 1992 20:57:28   arnoff
 * No change.
 * 
 *    Rev 1.1   29 Jan 1992 19:51:40   arnoff
 *  
 */
