/*
 * $Header:   J:/22vcs/srccmd/alarm/alarm.c_v   1.3   20 Jul 1992 19:02:04   paul  $
 */

/*
 * ALARM.C - user interface for Alarm system
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc., all rights reserved.
 * 
 * This program is provided as an example of the use of the PC/TCP
 * Developer's Kit library routines. This program, or modified versions
 * thereof, may be freely distributed, provided that this notice is
 * retained in any modifed versions.
 *
 * Description:
 *
 * This is the client side of a simple UDP-based network protocol for
 * delivering short messages to other hosts.  The message is sent as a
 * UDP datagram, and we expect acknowlegement (in the form of a reply
 * datagram containing the text of the message we sent).  If there is
 * no reply within a short timeout interval, we try sending the message
 * again.
 *
 * Bugs: Since it was written as an example of the PC/TCP asynchronous
 *	 notification facilities, the protocol doesn't have any way of
 *	 naming a specific user at a multi-user host.  Use SMTP instead.
 *
 *	 Only 80 characters can be displayed, and only 128 characters
 *	 of message can be acknowleged correctly.
 *
 * Edit History
 * 13-Jul-87	jbvb	UDP version written
 * 29-Jul-87	jbvb	Change socket number to 990.
 * 19-Sep-87	jbvb	Debugging.
 * 21-Sep-89	jbvb	Fix arguments to match prototypes.
 * 12-Nov-91	paul	change to new-style declarator, add return type
 * 20-Jul-92	paul	set stack size for Turbo/Borland version
 */

#include <stdio.h>
#include <string.h>
#include <process.h>		/* for exit() */

#include <pctcp/types.h>
#include <pctcp/pctcp.h>
#include <pctcp/ipconfig.h>
#include <pctcp/options.h>
#include <pctcp/error.h>

#include "alarm.h"

#ifdef __TURBOC__
extern unsigned _stklen = 3000;
#endif

void
main(int argc, char *argv[])
{
	int	alarm_con;		/* Network descriptor in use */
	int	len;			/* Length of the message */
	struct	addr a;			/* Remote IP address & port to use */
	long	tmo	= ALARM_TIMEOUT;
	int	retry	= ALARM_RETRY;
	char	inbuf[256];

	/* First, parse the command-line arguments.
	 * 1st argument is host, 2nd is message
	 */
	if ((argc == 2) && (strcmp(argv[1], "-version") == 0)) {
		pr_notice("alarm");
		exit(0);
	}

	if (argc != 3) {				/* Must be 3 args */
		printf("usage:  alarm host message\n");
		exit(1);
	}
	/* Convert the text name on command line into a numeric IP address.
	*/
	a.fhost = nm_res_name(argv[1], (char *) 0, 0);
	if (a.fhost == 0) {
		pneterror(argv[1]);	/* Give name asked for as message */
		exit(1);
	}
	/* Set up send & receive UDP datagram ports & get network descriptor
	*/
	a.lsocket = 0;			/* Use a random local port number */
	a.fsocket = SOCK_ALARM_RECV;	/*  & a "well-known" remote port. */

	alarm_con = net_connect(-1, DGRAM, &a);
	if (alarm_con < 0) {
		printf("Alarm: can't open to network.\n");
		pneterror("net_connect");
		net_releaseall();
		exit(1);
	}
	/* Set the timeout option, so our reads won't wait forever.
	*/
	if ((set_option(alarm_con, DGRAM, NET_OPT_TIMEOUT,
			(char far *)tmo, 4)) != 0) {
		printf("Alarm: couldn't set timeout option.\n");
		exit(1);
	}
	/* Try to deliver message; if no reply, send again (ALARM_RETRY times)
	*/
	while (retry--) {
		if (net_write(alarm_con, argv[2], strlen(argv[2])+1, 0) < 0) {
			pneterror("net_write");
			printf("Alarm: error on attempt to transmit.\n");
			exit(1);
		}
		/* If we get an answer, check the data to be sure.
		*/
		if ((len = net_read(alarm_con, inbuf, sizeof(inbuf),
				(struct addr *)0, 0)) >= 0) {
			if (strcmp(inbuf, argv[2]) == 0) {
				puts("Alarm: message delivered.");
				exit(0);			/* Success! */
			} else {
				inbuf[len] = '\0';
				printf("Bad echo, %d bytes: %s\n",len,inbuf);
			}
		} else if (neterrno != NET_ERR_TIMEOUT) {
			pneterror("net_read");
			printf("Alarm: error on attempt to receive.\n");
			exit(1);
		}
	}					/* No successful attempts */
	puts("Couldn't deliver message");
	exit(1);
}

/*
 * $Log:   J:/22vcs/srccmd/alarm/alarm.c_v  $
 * 
 *    Rev 1.3   20 Jul 1992 19:02:04   paul
 * set stack size for Turbo/Borland version
 * 
 *    Rev 1.2   03 Feb 1992 20:57:22   arnoff
 * No change.
 * 
 *    Rev 1.1   29 Jan 1992 19:51:34   arnoff
 *  
 */
