/*
 * $Header:   J:/22vcs/include/sys/types.h_v   1.13   05 Oct 1992 11:12:52   rcq  $
 */

/*
 * INCLUDE/SYS/TYPES.H - Definitions of basic system data types.
 *
 * Copyright (C) 1986,1987,1992 by FTP Software, Inc.  All rights reserved.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * EDIT HISTORY:
 * 9/2/87	romkey		Changed ino_t from u_long to unsigned short
 *				for MSC compatability.
 * 05-Jun-88	jbvb	Remove size_t definition (for MSC 5.1).
 * 27OCT89	stev	add 4.3 stuff for select()
 * 24JAN90	stev	add #define _SYS_TYPES_ to avoid multiple includes
 * 05-Apr-91    Ben     Put '_' in front of time_t_defined to match msc
 * 13-Jun-91	wcl	changed '1' to '1L' in FD_SET, FD_ISSET, FD_CLR
 * 27-Feb-92	Ben	Added #ifdefs for ino_t, dev_t, & off_t
 * 24-Aug-92	paul	added MSC7-compatible typedefs _ino_t, _dev_t, _off_t
 * 04-Oct-92	rcq	added ifdefs to handle different time_t definitions
 *			between MSC6, MSC7 and other compilers
 */

#ifndef _SYS_TYPES_
#define _SYS_TYPES_

typedef	unsigned char	u_char;
typedef	unsigned short	u_short;
typedef	unsigned int	u_int;
typedef	unsigned long	u_long;

typedef	long		daddr_t;
typedef	char *		caddr_t;

/* Microsoft C hack to avoid getting ino_t, dev_t, off_t, & time_t 
 * multiply defined.
 */
#ifndef _INO_T_DEFINED
typedef	unsigned short	 ino_t;		/* i-node number (not used on DOS) */
typedef unsigned short	_ino_t;		/* MSC7 version */
#define _INO_T_DEFINED
#endif

#ifndef _DEV_T_DEFINED
typedef	short		 dev_t;		/* device code */
typedef short		_dev_t;		/* MSC7 version */
#define _DEV_T_DEFINED
#endif

#ifndef _OFF_T_DEFINED
typedef	long		 off_t;		/* file offset value */
typedef long		_off_t;		/* MSC7 version */
#define _OFF_T_DEFINED
#endif

#ifndef	_TIME_T_DEFINED
#ifdef _MSC_VER
#if (_MSC_VER <= 600)
typedef long time_t;          /* definition for pre-MSC7 */
#else
typedef unsigned long time_t; /* definition for MSC7 */
#endif /* _MSC_VER */
#else
typedef long time_t;          /* definition for non-MSC compilers */
#endif
#define	_TIME_T_DEFINED
#endif

/* stuff added for select()
*/

#define NBBY	8	/* number of bits in a byte			*/

#ifdef   FD_SETSIZE	/* no matter what they want, they only get 20	*/
#undef   FD_SETSIZE	/* descriptors from DOS, to reset it if they	*/
#endif /*FD_SETSIZE*/	/* tried to change it.				*/

#define  FD_SETSIZE	20	/* maximum number of DOS file descrs	*/

#define MAXSELFD	20	/* maxnumber of descrs select() groks	*/

typedef long	fd_mask;	/* longest easily used number type	*/

#define NFDBITS	(sizeof(fd_mask)* NBBY)	/* Number of File Descr BITS	*/

#define NFDSHIFT	0	/* how far to shift over sizeof(fd_mask)*/

#ifndef  howmany	/* used to find howmany longs needed for allowed*/
#define  howmany(x,y)	(((x) + ((y) - 1)) / (y)) /* number of FDs	*/
#endif /*howmany*/

typedef struct fd_set  {
    fd_mask	fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;

#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1L << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1L << ((n)% NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1L << ((n) % NFDBITS)))
#define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))

#endif /*_SYS_TYPES_*/

/*
 * $Log:   J:/22vcs/include/sys/types.h_v  $
 * 
 *    Rev 1.13   05 Oct 1992 11:12:52   rcq
 * types.new
 * 
 *    Rev 1.12   24 Aug 1992 15:25:48   paul
 * added MSC7-compatible typedefs _ino_t, _dev_t, _off_t
 * 
 *    Rev 1.11   27 Feb 1992 17:37:44   arnoff
 * Ben	Added #ifdefs for ino_t, dev_t, & off_t
 * 
 *    Rev 1.10   03 Feb 1992 23:28:10   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.9   30 Jan 1992 19:50:26   arnoff
 *  
 */
