#ifndef FTP
#define FTP /*Copyright 1992, FTP Software, Inc.  All Rights Reserved.*/
#endif /* FTP */
#ifdef FTP /* added code */
#ifndef RC_INVOKED
#pragma comment (exestr, "$Id: rpc_msg.h%v 1.4 1993/02/24 20:24:12 db Sta $")
#endif /* RC_INVOKED */
/*
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Revision 1.2  1992/06/12  03:06:29  dwh
 * Initial FTP port for OS/2.
 *
 * Revision 1.1  1992/03/13  02:17:25  dwh
 * Sun RPCSRC4.0 Porting Base.
 */
#else /* FTP superceded code */
/* @(#)rpc_msg.h	2.1 88/07/29 4.0 RPCSRC */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
/*      @(#)rpc_msg.h 1.7 86/07/16 SMI      */

/*
 * rpc_msg.h
 * rpc message definition
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 */
#endif /* FTP */

#ifndef _RPC_RPC_MSG_H_
#define _RPC_RPC_MSG_H_

#define RPC_MSG_VERSION		((u_long) 2)
#define RPC_SERVICE_PORT	((u_short) 2048)

/*
 * Bottom up definition of an rpc message.
 * NOTE: call and reply use the same overall stuct but
 * different parts of unions within it.
 */

enum msg_type {
	CALL=0,
	REPLY=1
};

enum reply_stat {
	MSG_ACCEPTED=0,
	MSG_DENIED=1
};

enum accept_stat {
	SUCCESS=0,
	PROG_UNAVAIL=1,
	PROG_MISMATCH=2,
	PROC_UNAVAIL=3,
	GARBAGE_ARGS=4,
	SYSTEM_ERR=5
};

enum reject_stat {
	RPC_MISMATCH=0,
	AUTH_ERROR=1
};

/*
 * Reply part of an rpc exchange
 */

/*
 * Reply to an rpc request that was accepted by the server.
 * Note: there could be an error even though the request was
 * accepted.
 */
struct accepted_reply {
	struct opaque_auth	ar_verf;
	enum accept_stat	ar_stat;
	union {
		struct {
			u_long	low;
			u_long	high;
		} AR_versions;
		struct {
			caddr_t	where;
			xdrproc_t proc;
		} AR_results;
		/* and many other null cases */
	} ru;
#define	ar_results	ru.AR_results
#define	ar_vers		ru.AR_versions
};

/*
 * Reply to an rpc request that was rejected by the server.
 */
struct rejected_reply {
	enum reject_stat rj_stat;
	union {
		struct {
			u_long low;
			u_long high;
		} RJ_versions;
		enum auth_stat RJ_why;  /* why authentication did not work */
	} ru;
#define	rj_vers	ru.RJ_versions
#define	rj_why	ru.RJ_why
};

/*
 * Body of a reply to an rpc request.
 */
struct reply_body {
	enum reply_stat rp_stat;
	union {
		struct accepted_reply RP_ar;
		struct rejected_reply RP_dr;
	} ru;
#define	rp_acpt	ru.RP_ar
#define	rp_rjct	ru.RP_dr
};

/*
 * Body of an rpc request call.
 */
struct call_body {
	u_long cb_rpcvers;	/* must be equal to two */
	u_long cb_prog;
	u_long cb_vers;
	u_long cb_proc;
	struct opaque_auth cb_cred;
	struct opaque_auth cb_verf; /* protocol specific - provided by client */
};

/*
 * The rpc message
 */
struct rpc_msg {
	u_long			rm_xid;
	enum msg_type		rm_direction;
	union {
		struct call_body RM_cmb;
		struct reply_body RM_rmb;
	} ru;
#define	rm_call		ru.RM_cmb
#define	rm_reply	ru.RM_rmb
};
#define	acpted_rply	ru.RM_rmb.ru.RP_ar
#define	rjcted_rply	ru.RM_rmb.ru.RP_dr


/*
 * XDR routine to handle a rpc message.
 * xdr_callmsg(xdrs, cmsg)
 * 	XDR *xdrs;
 * 	struct rpc_msg *cmsg;
 */

/* r_callms.c */
extern bool_t _DLL_FLAGS xdr_callmsg(XDR FAR *xdrs, struct rpc_msg FAR *cmsg);


/*
 * XDR routine to pre-serialize the static part of a rpc message.
 * xdr_callhdr(xdrs, cmsg)
 * 	XDR *xdrs;
 * 	struct rpc_msg *cmsg;
 */

/* r_prot.c */
extern bool_t _DLL_FLAGS xdr_callhdr(XDR FAR *xdrs, struct rpc_msg FAR *cmsg);


/*
 * XDR routine to handle a rpc reply.
 * xdr_replymsg(xdrs, rmsg)
 * 	XDR *xdrs;
 * 	struct rpc_msg *rmsg;
 */

/* r_prot.c */
extern bool_t _DLL_FLAGS xdr_replymsg(XDR FAR *xdrs, struct rpc_msg FAR *rmsg);


/*
 * Fills in the error part of a reply message.
 * _seterr_reply(msg, error)
 * 	struct rpc_msg *msg;
 * 	struct rpc_err *error;
 */

/* r_prot.c */
extern void _DLL_FLAGS _seterr_reply(struct rpc_msg FAR *msg,
                                     struct rpc_err FAR *error);

#ifdef FTP /* added code */

/* r_dtable.c */
extern _DLL_FLAGS _rpc_dtablesize(void);
#endif /* FTP */

#endif /* _RPC_RPC_MSG_H_ */


/*
 *
 * RCS automatic edit history:
 * $Log:   J:/devkit.dos/vcs/include/rpc/rpc_msg.h_v  $
 * 
 *    Rev 1.12.1.2   08 Apr 1993 15:24:14   rcq
 * added #ifndef RC_INVOKED
 * 
 *    Rev 1.12.1.1   06 Apr 1993 09:56:58   natalia
 * No change.
 * 
 *    Rev 1.12.1.0   04 Apr 1993 14:44:14   db
 * RPC Update 4/4 for 2.21
 * 
 *    Rev 1.0   31 Mar 1993 17:28:46   db
 * Initial revision.
 * Revision 1.4  1993/02/24  20:24:12  db
 * windows stable
 *
 * Revision 1.3  1993/01/15  20:28:09  db
 * removed redefinition of _DLL_FLAGS
 *
 * Revision 1.2  1993/01/15  18:38:48  db
 * changed prototypes and data structures to FAR pointers for
 * windows .DLLdom
 * .,
 *
 * Revision 1.1  1993/01/07  01:13:51  bala
 * Initial revision
 */
