#ifndef FTP
#define FTP /*Copyright 1992, FTP Software, Inc.  All Rights Reserved.*/
#endif /* FTP */
#ifdef FTP /* added code */
#ifndef RC_INVOKED
#pragma comment (exestr, "$Id: pmap_pro.h%v 1.6 1993/02/24 20:23:50 db Sta $")
#endif /* RC_INVOKED */
/*
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Revision 1.2  1992/06/12  03:06:29  dwh
 * Initial FTP port for OS/2.
 *
 * Revision 1.1  1992/03/13  02:17:25  dwh
 * Sun RPCSRC4.0 Porting Base.
 */
#else /* FTP superceded code */
/* @(#)pmap_prot.h	2.1 88/07/29 4.0 RPCSRC; from 1.14 88/02/08 SMI */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#endif /* FTP */
#ifndef _RPC_PMAP_PROT_H_
#define _RPC_PMAP_PROT_H_


/*
 * pmap_prot.h
 * Protocol for the local binder service, or pmap.
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 *
 * The following procedures are supported by the protocol:
 *
 * PMAPPROC_NULL() returns ()
 * 	takes nothing, returns nothing
 *
 * PMAPPROC_SET(struct pmap) returns (bool_t)
 * 	TRUE is success, FALSE is failure.  Registers the tuple
 *	[prog, vers, prot, port].
 *
 * PMAPPROC_UNSET(struct pmap) returns (bool_t)
 *	TRUE is success, FALSE is failure.  Un-registers pair
 *	[prog, vers].  prot and port are ignored.
 *
 * PMAPPROC_GETPORT(struct pmap) returns (long unsigned).
 *	0 is failure.  Otherwise returns the port number where the pair
 *	[prog, vers] is registered.  It may lie!
 *
 * PMAPPROC_DUMP() RETURNS (struct pmaplist *)
 *
 * PMAPPROC_CALLIT(unsigned, unsigned, unsigned, string<>)
 * 	RETURNS (port, string<>);
 * usage: encapsulatedresults = PMAPPROC_CALLIT(prog, vers, proc, encapsulatedargs);
 * 	Calls the procedure on the local machine.  If it is not registered,
 *	this procedure is quite; ie it does not return error information!!!
 *	This procedure only is supported on rpc/udp and calls via
 *	rpc/udp.  This routine only passes null authentication parameters.
 *	This file has no interface to xdr routines for PMAPPROC_CALLIT.
 *
 * The service supports remote procedure calls on udp/ip or tcp/ip socket 111.
 */

#define PMAPPORT		((u_short)111)
#define PMAPPROG		((u_long)100000)
#define PMAPVERS		((u_long)2)
#define PMAPVERS_PROTO		((u_long)2)
#define PMAPVERS_ORIG		((u_long)1)
#define PMAPPROC_NULL		((u_long)0)
#define PMAPPROC_SET		((u_long)1)
#define PMAPPROC_UNSET		((u_long)2)
#define PMAPPROC_GETPORT	((u_long)3)
#define PMAPPROC_DUMP		((u_long)4)
#define PMAPPROC_CALLIT		((u_long)5)

struct pmap {
	long unsigned pm_prog;
	long unsigned pm_vers;
	long unsigned pm_prot;
	long unsigned pm_port;
};

struct pmaplist {
	struct pmap	pml_map;
	struct pmaplist FAR *pml_next;
};
 

#include <rpc/xdr.h>
/* p_prot.c */
extern bool_t _DLL_FLAGS xdr_pmap(XDR FAR *xdrs, struct pmap FAR *regs);


extern bool_t _DLL_FLAGS xdr_pmaplist(XDR FAR *xdrs,
                                      struct pmaplist FAR * FAR *rp);
#ifdef WINSOCK
void _DLL_FLAGS pmap_init(HWND hwin);
#else
void pmap_init(void);
#endif /* winsock */


#endif /* _RPC_PMAP_PROT_H_ */

/*
 * RCS automatic edit history:
 * $Log:   J:/devkit.dos/vcs/include/rpc/pmap_pro.h_v  $
 * 
 *    Rev 1.12.1.2   08 Apr 1993 15:24:00   rcq
 * added #ifndef RC_INVOKED
 * 
 *    Rev 1.12.1.1   06 Apr 1993 09:56:40   natalia
 * No change.
 * 
 *    Rev 1.12.1.0   04 Apr 1993 14:41:54   db
 * RPC Update 4/4 for 2.21
 * 
 *    Rev 1.0   31 Mar 1993 17:28:40   db
 * Initial revision.
 * Revision 1.6  1993/02/24  20:23:50  db
 * windows stable
 *
 * Revision 1.5  1993/02/23  13:53:00  db
 * merge with DOS and Windows seemingly complete
 * pre Borland merge
 *
 * Revision 1.4  1993/01/29  22:29:55  db
 * added FAR pointers for all structures
 *
 * Revision 1.3  1993/01/15  20:27:15  db
 * removed redefinition of _DLL_FLAGS
 * .,
 *
 * Revision 1.2  1993/01/15  19:59:31  db
 * changed data structures to have FAR pointers for
 * conversion to windows .DLL
 *
 * Revision 1.1  1993/01/07  01:13:44  bala
 * Initial revision
 */
