#ifndef FTP
#define FTP /*Copyright 1992, FTP Software, Inc.  All Rights Reserved.*/
#endif /* FTP */
#ifdef FTP /* added code */
#ifndef RC_INVOKED
#pragma comment (exestr, "$Id: clnt.h%v 1.5 1993/02/24 20:23:26 db Sta $")
#endif /* RC_INVOKED */
/*
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Sun RPCSRC4.0 Porting Base.
 */
#else /* FTP superceded code */
/* @(#)clnt.h	2.1 88/07/29 4.0 RPCSRC; from 1.31 88/02/08 SMI*/
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/*
 * clnt.h - Client side remote procedure call interface.
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 */
#endif /* FTP */

#ifndef _CLNT_
#define _CLNT_


/*
 * Rpc calls return an enum clnt_stat.  This should be looked at more,
 * since each implementation is required to live with this (implementation
 * independent) list of errors.
 */
enum clnt_stat {
	RPC_SUCCESS=0,			/* call succeeded */
	/*
	 * local errors
	 */
	RPC_CANTENCODEARGS=1,		/* can't encode arguments */
	RPC_CANTDECODERES=2,		/* can't decode results */
	RPC_CANTSEND=3,			/* failure in sending call */
	RPC_CANTRECV=4,			/* failure in receiving result */
	RPC_TIMEDOUT=5,			/* call timed out */
	/*
	 * remote errors
	 */
	RPC_VERSMISMATCH=6,		/* rpc versions not compatible */
	RPC_AUTHERROR=7,		/* authentication error */
	RPC_PROGUNAVAIL=8,		/* program not available */
	RPC_PROGVERSMISMATCH=9,		/* program version mismatched */
	RPC_PROCUNAVAIL=10,		/* procedure unavailable */
	RPC_CANTDECODEARGS=11,		/* decode arguments error */
	RPC_SYSTEMERROR=12,		/* generic "other problem" */

	/*
	 * callrpc & clnt_create errors
	 */
	RPC_UNKNOWNHOST=13,		/* unknown host name */
	RPC_UNKNOWNPROTO=17,		/* unkown protocol */

	/*
	 * _ create errors
	 */
	RPC_PMAPFAILURE=14,		/* the pmapper failed in its call */
	RPC_PROGNOTREGISTERED=15,	/* remote program is not registered */
	/*
	 * unspecified error
	 */
	RPC_FAILED=16
};


/*
 * Error info.
 */
struct rpc_err {
	enum clnt_stat re_status;
	union {
		int RE_errno;		/* realated system error */
		enum auth_stat RE_why;	/* why the auth error occurred */
		struct {
			u_long low;	/* lowest verion supported */
			u_long high;	/* highest verion supported */
		} RE_vers;
		struct {		/* maybe meaningful if RPC_FAILED */
			long s1;
			long s2;
		} RE_lb;		/* life boot & debugging only */
	} ru;
#define	re_errno	ru.RE_errno
#define	re_why		ru.RE_why
#define	re_vers		ru.RE_vers
#define	re_lb		ru.RE_lb
};


/*
 * Client rpc handle.
 * Created by individual implementations, see e.g. rpc_udp.c.
 * Client is responsible for initializing auth, see e.g. auth_none.c.
 */

typedef struct client {
	AUTH FAR *cl_auth;			/* authenticator */
	struct clnt_ops {
		enum clnt_stat	(_DLL_FLAGS *cl_call)(struct client FAR *,
						      u_long,
						      xdrproc_t,
						      caddr_t,
						      xdrproc_t,
						      caddr_t,
						      struct timeval);
						/* call remote procedure */
	        void		(_DLL_FLAGS *cl_abort)(struct client FAR *);
						/* abort a call */
		void		(_DLL_FLAGS *cl_geterr)(struct client FAR *, 
					     struct rpc_err FAR *);
						/* get specific error code */
		bool_t		(_DLL_FLAGS *cl_freeres)(struct client FAR *,
			                      xdrproc_t,
					      caddr_t);
				        	/* frees results */
		void		(_DLL_FLAGS *cl_destroy)(struct client FAR *rh);
						/* destroy this structure FAR */
		bool_t          (_DLL_FLAGS *cl_control)(struct client FAR *cl,
					      u_int request,
					      char FAR *info);
						/* the ioctl() of rpc */
	} FAR *cl_ops;
	caddr_t			cl_private;	/* private stuff */
} CLIENT;

/*
 * client side rpc interface ops
 *
 * Parameter types are:
 *
 */

/*
 * enum clnt_stat
 * CLNT_CALL(rh, proc, xargs, argsp, xres, resp, timeout)
 * 	CLIENT *rh;
 *	u_long proc;
 *	xdrproc_t xargs;
 *	caddr_t argsp;
 *	xdrproc_t xres;
 *	caddr_t resp;
 *	struct timeval timeout;
 */

#define	CLNT_CALL(rh, proc, xargs, argsp, xres, resp, secs)	\
	((*(rh)->cl_ops->cl_call)(rh, proc,	\
		(xdrproc_t)xargs, (caddr_t)argsp,	\
		(xdrproc_t)xres, (caddr_t)resp, secs))
#define	clnt_call(rh, proc, xargs, argsp, xres, resp, secs)	\
	((*(rh)->cl_ops->cl_call)(rh, proc,	\
		(xdrproc_t)xargs, (caddr_t)argsp,	\
		(xdrproc_t)xres, (caddr_t)resp, secs))

/*
 * void
 * CLNT_ABORT(rh);
 * 	CLIENT *rh;
 */
#define	CLNT_ABORT(rh)	((*(rh)->cl_ops->cl_abort)(rh))
#define	clnt_abort(rh)	((*(rh)->cl_ops->cl_abort)(rh))

#ifdef FTP /* added code */
/*
 * struct rpc_err
 * CLNT_GETERR(rh, errp);
 * 	CLIENT *rh;
 * 	rpc_err *errp;
 */
#else /* FTP superceded code */
/*
 * struct rpc_err
 * CLNT_GETERR(rh);
 * 	CLIENT *rh;
 */
#endif /* FTP */
#define	CLNT_GETERR(rh,errp)	((*(rh)->cl_ops->cl_geterr)(rh, errp))
#define	clnt_geterr(rh,errp)	((*(rh)->cl_ops->cl_geterr)(rh, errp))


/*
 * bool_t
 * CLNT_FREERES(rh, xres, resp);
 * 	CLIENT *rh;
 *	xdrproc_t xres;
 *	caddr_t resp;
 */
#define	CLNT_FREERES(rh,xres,resp) ((*(rh)->cl_ops->cl_freeres)(rh,xres,resp))
#define	clnt_freeres(rh,xres,resp) ((*(rh)->cl_ops->cl_freeres)(rh,xres,resp))

/*
 * bool_t
 * CLNT_CONTROL(cl, request, info)
 *      CLIENT *cl;
 *      u_int request;
 *      char *info;
 */
#define	CLNT_CONTROL(cl,rq,in) ((*(cl)->cl_ops->cl_control)(cl,rq,in))
#define	clnt_control(cl,rq,in) ((*(cl)->cl_ops->cl_control)(cl,rq,in))

/*
 * control operations that apply to both udp and tcp transports
 */
#define CLSET_TIMEOUT       1   /* set timeout (timeval) */
#define CLGET_TIMEOUT       2   /* get timeout (timeval) */
#define CLGET_SERVER_ADDR   3   /* get server's address (sockaddr) */
/*
 * udp only control operations
 */
#define CLSET_RETRY_TIMEOUT 4   /* set retry timeout (timeval) */
#define CLGET_RETRY_TIMEOUT 5   /* get retry timeout (timeval) */

/*
 * void
 * CLNT_DESTROY(rh);
 * 	CLIENT *rh;
 */
#define	CLNT_DESTROY(rh)	((*(rh)->cl_ops->cl_destroy)(rh))
#define	clnt_destroy(rh)	((*(rh)->cl_ops->cl_destroy)(rh))


/*
 * RPCTEST is a test program which is accessable on every rpc
 * transport/port.  It is used for testing, performance evaluation,
 * and network administration.
 */

#define RPCTEST_PROGRAM		((u_long)1)
#define RPCTEST_VERSION		((u_long)1)
#define RPCTEST_NULL_PROC	((u_long)2)
#define RPCTEST_NULL_BATCH_PROC	((u_long)3)

/*
 * By convention, procedure 0 takes null arguments and returns them
 */

#define NULLPROC ((u_long)0)

/*
 * Below are the client handle creation routines for the various
 * implementations of client side rpc.  They can return NULL if a 
 * creation failure occurs.
 */

/*
 * Memory based rpc (for speed check and testing)
 * CLIENT *
 * clntraw_create(prog, vers)
 *	u_long prog;
 *	u_long vers;
 */

extern CLIENT FAR *   _DLL_FLAGS clntraw_create(
                struct sockaddr_in FAR *raddr,
                u_long prog, u_long vers,
                SOCKET FAR *sockp,
                u_int sendsz,
                u_int recvsz);


/*
 * Generic client creation routine. Supported protocols are "udp" and "tcp"
 */

/* c_generi.c */
extern CLIENT FAR * _DLL_FLAGS clnt_create(char FAR *hostname, 
	u_long prog,
	u_long vers,
	char FAR *prot);
/*
	char *host; 	-- hostname
	u_long prog;	-- program number
	u_long vers;	-- version number
	char *prot;	-- protocol
*/


/*
 * TCP based rpc
 * CLIENT *
 * clnttcp_create(raddr, prog, vers, sockp, sendsz, recvsz)
 *	struct sockaddr_in *raddr;
 *	u_long prog;
 *	u_long version;
 *	register int *sockp;
 *	u_int sendsz;
 *	u_int recvsz;
 */

/* c_tcp.c */

extern CLIENT FAR * _DLL_FLAGS clnttcp_create(
	struct sockaddr_in FAR *raddr,
	u_long prog, u_long vers,
	SOCKET FAR *sockp,
	u_int sendsz,
	u_int recvsz);


	
/*
 * UDP based rpc.
 * CLIENT *
 * clntudp_create(raddr, program, version, wait, sockp)
 *	struct sockaddr_in *raddr;
 *	u_long program;
 *	u_long version;
 *	struct timeval wait;
 *	int *sockp;
 *
 * Same as above, but you specify max packet sizes.
 * CLIENT *
 * clntudp_bufcreate(raddr, program, version, wait, sockp, sendsz, recvsz)
 *	struct sockaddr_in *raddr;
 *	u_long program;
 *	u_long version;
 *	struct timeval wait;
 *	int *sockp;
 *	u_int sendsz;
 *	u_int recvsz;
 */
/* c_udp.c */

extern CLIENT FAR * _DLL_FLAGS clntudp_bufcreate(
	struct sockaddr_in FAR *raddr,
	u_long program,
	u_long version,
	struct timeval wait,
	SOCKET FAR *sockp,
	u_int sendsz,
	u_int recvsz);
extern CLIENT FAR * _DLL_FLAGS clntudp_create(
	struct sockaddr_in FAR *raddr,
	u_long program,
	u_long version,
	struct timeval wait,
	SOCKET FAR *sockp);


	
/*
 * Print why creation failed
 */

/* c_perror.c */
extern void _DLL_FLAGS clnt_pcreateerror(char FAR *s);
extern char FAR * _DLL_FLAGS clnt_spcreateerror(char FAR *s);

/*
 * Like clnt_perror(), but is more verbose in its output
 */ 

/* c_perror.c */
extern void _DLL_FLAGS clnt_perrno(enum clnt_stat num);

/*
 * Print an English error message, given the client error code
 */

extern char FAR *_DLL_FLAGS clnt_sperror(CLIENT FAR *rpch, char FAR *s);
extern void _DLL_FLAGS clnt_perror(CLIENT FAR *rpch, char FAR *s);

/* 
 * If a creation fails, the following allows the user to figure out why.
 */
struct rpc_createerr {
	enum clnt_stat cf_stat;
	struct rpc_err cf_error; /* useful when cf_stat == RPC_PMAPFAILURE */
};

extern struct rpc_createerr rpc_createerr;

int _DLL_FLAGS callrpc(char FAR *host, u_long prognum, u_long versnum, u_long procnum,
	xdrproc_t inproc, char FAR *in, xdrproc_t outproc, char FAR *out);

typedef bool_t (_DLL_FLAGS *resultproc_t)(caddr_t, struct sockaddr_in FAR *);

enum clnt_stat _DLL_FLAGS clnt_broadcast(u_long prog, u_long vers, u_long proc, 
	xdrproc_t xargs, caddr_t argsp, xdrproc_t xresults, caddr_t resultsp, 
	resultproc_t eachresult);


/*
 * Copy error message to buffer.
 */

extern char FAR * _DLL_FLAGS clnt_sperrno(enum clnt_stat stat);

#define UDPMSGSIZE	8800	/* rpc imposed limit on udp msg size */
#define RPCSMALLMSGSIZE	400	/* a more reasonable packet size */

#endif /*!_CLNT_*/

/*
 * RCS automatic edit history:
 * $Log:   J:/devkit.dos/vcs/include/rpc/clnt.h_v  $
 * 
 *    Rev 1.13.1.2   08 Apr 1993 15:23:42   rcq
 * added #ifndef RC_INVOKED
 * 
 *    Rev 1.13.1.1   06 Apr 1993 09:56:22   natalia
 * No change.
 * 
 *    Rev 1.13.1.0   04 Apr 1993 14:39:54   db
 * RPC Update 4/4 for 2.21
 * 
 *    Rev 1.0   31 Mar 1993 17:28:34   db
 * Initial revision.
 * Revision 1.5  1993/02/24  20:23:26  db
 * windows stable
 *
 * Revision 1.4  1993/01/29  22:26:51  db
 * changed for windows .dll
 * first working windows .dll
 * added strong prototypeing and _DLL_FLAGS cast
 * to all functions
 *
 * Revision 1.3  1993/01/15  18:37:01  db
 * continued the unstoppable march toward .DLLdom
 *
 * Revision 1.2  1993/01/13  14:21:10  db
 * fixed some forward declarations,
 * etc.
 *
 * Revision 1.1  1993/01/07  01:13:22  bala
 * Initial revision
 *
 * Revision 1.2  1992/06/12  03:06:29  dwh
 * Initial FTP port for OS/2.
 *
 * Revision 1.1  1992/03/13  02:17:25  dwh
 */
