/*
 * $Header:   K:\devkit.dos\vcs\include\pctcp\wtelnet.h_v   1.12.1.1   08 Apr 1993 17:32:42   arnoff  $
 */

#ifndef __WTELNET_HEADER__
#define __WTELNET_HEADER__



/*
 * Copyright (C) 1986, 1992 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 11-Mar-88	jbvb	Add output buffer, definition for tn_write()
 * 17-Mar-88    joga    Added tn_bin_mode[] to telnet structure and appropiate
 *                      #defines to describe status of binary options, and
 *                      definitions for tn_rqst_bin() and tn_bin_off().
 * 18-Mar-88    jog     Added tn_is_bin(tn) macro;   
 * 08-Jun-88    joga    Added tn_cname to structure for multiple connections.
 * 01-Aug-88    jog     Added tn_term_index (init to 0)
 * 02-Sep-88    jog     func. ptr to routine to send term type to remote host
 * 06-Sep-88	jbvb	Add function prototypes, remove line noise.
 * 06-Sep-88	jog	Func called by func ptr returns char * to ascii string
 *                      to send as term type
 * 17-May-89	jbvb	Make tn_putc()'s argument an unsigned char.
 * 10-Aug-89    jog     Added abort(), _remote(), _local(), _ayt() and 
 *                      _break() declarations
 * 17-Aug-89	jbvb	Prevent negotiation loops on SPGA & TTTYPE
 * 11-Dec-89    jog     make tn_is_open test tn == NULL also
 * 09-Mar-90	kek	Added tel_mode union to make room for local and
 *			 remote eor modes.
 * 13-Mar-90	kek	Added tn3270 indicator to telnet structure.
 * 22-May-90	kek	Enlarged tn_wbuf for tn3270 ReadBuffer problem.
 * 04-Sep-90	kek	Define TN_FLG_RAW
 * 04-Oct-90	kek	Bill's macro fix
 * 17-Oct-90	kek	Remove unneccessary tn_echolocal/remote() definitions.
 * 18-Oct-90	kek	Make blocked a structure member, not a global.
 * 22-Apr-91	kek	Rename spga to do_spga & define will_spga to avoid 
 *			 negotiation loop.
 *	 
 *---------------->WINDOWS: rename to wtelnet.h<---------------------------
 * 01-May-91	gakio	Add FAR declarations of telnet DLL entry points and
 *			 modify send_ttype field of telnet structure.
 * 13-May-91	gakio	Add _alarm_handler() and _asynch_handler() to catch
 *			 'net_alarm's and 'net_asynch's.
 * 26-Jun-91	joel    moved all the "special characters" from wtelnet.c,
 *			may move back when all done, and app layer
 *			doesn't need them...
 * 30-Jul-91	jog	add next ptr and hwnd to the structure (don't really 
 *			like having the pointer to the next tn in the list
 *			but it's either that or another structure and layer
 *			of indirection)
 * 01-Aug-91	jog	define TN_NOTIFY, add notify field, add flag param to 
 *			tn_open
 * 22-Aug-91	jog	OKAY! scheme finally planned. 3 tn_open's...
 *			so original tn_open goes back: no flag but still 
 *			passed windows handle
 * 22-Aug-91	jog	prototype tn_openc & tn_openm
 * 23-Aug-91	jog	fix prototype of tn_openm
 * 07-Aug-91	MTowfiq juat as the beta site said, the next pointer has to be
 *			a FAR; things were buggyaccessing the structure, MT
 *			astutely tracked it down agin (I forgot to change it;
 *			then I shoot myself in the other foot. Jog)
 * 12-Dec-91	jog	to be consistent with other dlls, rename tn_openm
 *			to tn_openw...
 * 07-Jan-92	jog	add neterrno and netsuberrno to struct
 * 04-Feb-92	jog	take out definitions of TRUE and FALSE
 * 06-Feb-92	jog	get rid of tn_destroy...
 * 21-Feb-92	jog	get rid of tn->next
 * 08-Apr-92	jog	add tn_eof
 * 30-Oct-92	jog	add BRK #define
 */

/* special characters */
#define TN_IAC	255
#define WILL	251
#define WONT	252
#define DO	253
#define DONT	254
#define SE	240
#define NOP	241
#define DM	242
#define BRK     243
#define INTP	244
#define AO	245
#define AYT	246
#define GA	249
#define SB	250
#define EOR	239
#define OPTBIN  0
#define OPTECHO	1
#define	OPTSPGA	3
#define	OPTTYPE	24
#define OPTEOR  25

#define	SEND    1
#define	IS      0

/*
#define	FALSE	0
#define	TRUE	!FALSE
*/

/* the telnet control structure, passed around by applications using
 * the telnet library     
 */
union tel_mode {
	char tn_bin_mode[2];
	struct {
		unsigned char rem_eor_mode:2;
		unsigned char rem_bin_mode:2;
		unsigned char loc_eor_mode:2;
		unsigned char loc_bin_mode:2;
	} u;
} ;

union notify_u {
	WORD     msg_to_use;    /* use this value when Postmessage */
	FARPROC  event_handler; /* call this routine for events    */
} ;

/* probably add something to tell what DLL scheme to use */ 
typedef	struct telnet {
	int	tn_tcp;		/* the telnet's TCP connection  */
	unsigned tttype:    1;	/* Have we agreed to TTTYPE?    */
	unsigned do_spga:   1;	/* Have we agreed to Do SPGA?   */
				/* (spga in previous releases)  */
	unsigned tn3270:    1;	/* Is this a tn3270 connection? */
	unsigned blocked:   1;  /* Blocked in tn_write? */
	unsigned will_spga: 1;  /* Have we agreed to Will SPGA? */
	unsigned res_1: 11;     /* Reserved flag bits */
	char	tn_echom;	/* Echo mode */
				/* LOCAL - local echo */
				/* REMOTE - remote echo */
	char	tn_echongo;	/* Echo negotiation request outstanding */
				/* NORMALMODE */
				/* LECHOREQ - IAC DONT ECHO was sent */
				/* RECHOREQ - IAC DO ECHO was sent */
	union	tel_mode tn_modes;
		                /* OFF  (0)  */
				/* ON   (1)  */
				/* reqtosend */
				/* reqtostop */
	int	tn_wmode;	/* write mode */
	int	tn_chars;	/* # of valid characters in buffer */
	int	tn_next;	/* next character in buffer */
	unsigned char tn_buf[512];	/* buffer */
	int	tn_wchars;		/* Number of characters in wbuf */
	int	tn_wnext;		/* Next char to write in wbuf */
	unsigned char tn_wbuf[512];	/* Output buffer */
	char    far * tn_cname;		/* -> canonical name of rem host  */
	int     tn_term_index;		/* indicates term type negotiated */
	char    notify;		/* what scheme are using with this conn   */
				/*      (0); old/DOS way (DON'T tell em)  */
				/* WMSG (1); use W messages to tell em	  */
				/* CALL (1); use func call to tell em	  */
	union   notify_u async_thang;
	FARPROC send_ttype;	/* ptr to a function which returns an int and 
				   whose arg is a string containing ttype */
	HWND    hwnd;		/* belongs to the app using telnet struct */ 
	int	tn_neterrno;    /* last network err that happened	  */
	int	tn_netsuberrno; /* last network suberr that happened	  */
				/* should we put the string in also???    */
} telnet;

#define	BLOCK		1
#define NOBLOCK		2
#define URGENTM		1
#define EVERYC		1
#define NEWLINE		2
#define LOCAL		1
#define REMOTE		2

#define	NORMALMODE	1
#define LECHOREQ	2
#define RECHOREQ	3
                                /* binary option status  */
#define OFF          0    /* host not sending binary, no neg in progress   */
#define ON           1    /* host sending binary, no neg in progress       */
#define reqtosend    2    /* outstanding req for host to start sending bin */
#define reqtostop    3    /* outstanding req for host to stop sending bin  */

#define	TN_FLG_RAW  0x0100	/* raw telnet data  for tn_write */

				/* possible events for Telnet connection */
#define TN_OPEN	   1		/* successful open		 */
#define TN_DATA	   2		/* data has arrived		 */
#define TN_CLOSE   3		/* successful close		 */
#define TN_EOF     4		/* other side closed its side    */
#define TN_ERROR   5		/* something ain't totally happy */

/* #define XXXX 0 /* do not notify them at all, are using "blocking" calls */
#define WMSG 1   /* use Windows messages to notify app of events	  */
#define CALL 2   /* use function callback of events (unsupported          */

					/* remote hosts status: = to one */
#define rem_bin_mode(tn)  (tn)->tn_modes.u.rem_bin_mode
					/* local    "     "   : of above */
#define loc_bin_mode(tn)  (tn)->tn_modes.u.loc_bin_mode

#define rem_eor_mode(tn)  (tn)->tn_modes.u.rem_eor_mode
#define loc_eor_mode(tn)  (tn)->tn_modes.u.loc_eor_mode


#define	tn_is_open(tn)	((tn) && ((tn)->tn_tcp >= 0))
#define	tn_is_bin(tn)	((rem_bin_mode(tn) == ON) && (loc_bin_mode(tn) == ON))


/* telnet entry points */
int FAR PASCAL LibMain (HANDLE, WORD, WORD, LPSTR);
int FAR PASCAL WEP (int);

/* various tn_open routines */
/* Now Playing.... */
telnet FAR *FAR tn_open(in_name, unsigned, int (FAR PASCAL *)(char FAR *),
	HWND);

/* Coming Soon! */
/* passed message # to use to pass event info back to Winapp */
telnet FAR *FAR tn_openw(in_name, unsigned, int (FAR PASCAL *)(char FAR *), 
	HWND, WORD);

/* Coming This Fall... */
/* passed routine "up" in Winapp to call when an event happens */
telnet FAR *FAR tn_openc(in_name, unsigned, int (FAR PASCAL *)(char FAR *), 
	HWND, int (FAR PASCAL *)(WORD wParam, DWORD lParam));

int FAR tn_getc(telnet FAR *);
int FAR tn_putc(telnet FAR *, unsigned char);
int FAR tn_eof(telnet FAR *);
int FAR tn_close(telnet FAR *);
int FAR tn_write(telnet FAR *, char FAR *, int, unsigned);
int FAR tn_rqst_bin(telnet FAR *);
int FAR tn_bin_off(telnet FAR *);

int FAR tn_local(telnet FAR *);
int FAR tn_remote(telnet FAR *);
int FAR tn_abort(telnet FAR *);
int FAR tn_break(telnet FAR *);
int FAR tn_ayt(telnet FAR *);

BOOL tn_echoremote(telnet FAR *);
BOOL tn_echolocal(telnet FAR *);

/* From :dllglue.asm": */
int FAR _alarm_handler();	/* assembly routine to catch 'net_alarm's */
int FAR _asynch_handler();	/* assembly routine to catch 'net_asynch's */


/*
 * $Log:   K:\devkit.dos\vcs\include\pctcp\wtelnet.h_v  $
 * 
 *    Rev 1.12.1.1   08 Apr 1993 17:32:42   arnoff
 * Protected from multiple includes.
 * 
 *    Rev 1.12   30 Oct 1992 18:14:42   joel
 * add BRK #define
 * 
 *    Rev 1.11   13 Apr 1992 15:21:00   arnoff
 *  * 06-Feb-92	jog	get rid of tn_destroy...
 *  * 21-Feb-92	jog	get rid of tn->next
 *  * 08-Apr-92	jog	add tn_eof
 * 
 *    Rev 1.10   17 Mar 1992 11:30:06   arnoff
 *  * 17-Mar-92	MPR ifdef'ed TRUE definition to reduce compiler warnings
 * 
 * 
 *    Rev 1.9   03 Feb 1992 23:27:38   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:49:40   arnoff
 *     
 *    Rev 1.3   21 Feb 1992 16:53:30   arnoff
 * Added Joel's new changes
 * 
 *    Rev 1.2   06 Feb 1992 14:41:10   arnoff
 * take out tn_destroy, net_taskinit when need to, not int LibMain
 * 
 *    Rev 1.1   30 Jan 1992 01:17:48   arnoff
 *  
 */


#endif /* __WTELNET_HEADER__ */

