/*
 * $Header:   J:/22vcs/include/pctcp/winapp.h_v   1.13   25 Sep 1992 12:32:04   natalia  $
 */

/*
 * Copyright (C) 1990 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * 
 * EDIT HISTORY:
 * 05-Sep-90  msd@ayuda	Original author.
 * 20-Sep-90  msd@ayuda	Addition of 'net_msgEvent' and 'net_msgND' macros
 *			to isolate asynch message details.
 * 09-Nov-90  msd@ayuda	Expanded to support DNS & ICMP routines.
 * 29-Nov-90  msd@ayuda	Add support for back-version kernels.
 * 03-Dec-90  msd@ayuda	Add support for DLLs as clients; name modules.
 * 01-Apr-91  msd@ayuda	To FTP for 2.05 pl 2 beta.
 * xx-Jun-91  msd@ayuda Begin work on 2.10 version.
 * xx-Sep-91  msd@ayuda To FTP for 2.10 beta testing.
 * 21-Oct-91  msd@ayuda	Begin blocking i/o augmentation.
 * 17-Dec-91  Ben	Removed pneterror macro to make life easier (it was
 *			 colliding with the real pneterror prototype).
 *			 Added ifdef to prevent multiple inclusion.
 * 03-Jan-92  kek@ftp	Add is_kernel_busy(). Not officially supported.
 * 06-Jan-92  kek@ftp	Incorporated msd version into source tree.
 * 10-Jan-92  kek@ftp	Removed get_kapi_info() macro completely.
 * 14-Jan-92  Ben	Removed undef of TRUE.
 * 20-Jan-92  kek@ftp	Change net_shutdown parms so no error msg is gen'ed.
 * 28-Jan-92  kek@ftp	Change from "pctcp wnetlib" to "pctcp pctcpapi".
 * 27-Apr-92  kek@ftp	Change to suit 286 DLL.
 * 29-May-92  jbvb@ftp  Added ND to net_globalize macro.
 * 09-Sep-92  kek@ftp	Prototype *_getnetversion() routines.
 */

/* NOTE: This file is expected to be included *after* <windows.h> as it
   depends heavily upon its definitions. */

#ifndef _WINAPP_H	/* don't multiply include this file */
#define _WINAPP_H

#ifndef	MSW3
#define	MSW3	/*MS Windows 3.0: a general indication that we're doing this*/
#endif

#include <time.h>

#include <pctcp/types.h>
#include <pctcp/k_config.h>
#include <pctcp/netinfo.h>
#include <pctcp/options.h>
#include <pctcp/pctcp.h>
#include <pctcp/stats.h>

/* A few basic things used (below) by many API declarations. */
typedef int (*pfiT)();			/* inscrutable, yes? */
typedef int (FAR *FpfiT)();		/* and then some! */

#define DOPEPT	struct net_dope FAR *
#define	DOPEP	((DOPEPT) NET_DOPE)
#define DLLFAR	FAR			/* pointers to objects in the DLL */

/* The per-task network dope structure.  Used as a repository for
   information needed by a task to deal with the DLL.  Most of the items
   are hidden and some are aliased to look like separate variables. */
struct net_dope {
	char		netd_version;	/* NET_DOPE_VSN */
	char		netd_1pad;
	WORD		netd_msgType;	/* which WM_* to send */
	int		netd_errno;	/* errno cell for net calls */
	HANDLE		netd_hTask;	/* this task's GetCurrentTask handle */
	unsigned	netd_tid;	/* DLL-assigned task ID */
};
/* Version # of this interface / structure. */
#define	NET_DOPE_VSN	2


	/* DLL vs. normal application interface... */

/* Conditionally define a network dope structure instance here.  If
   the manifest NET_DOPE has been defined, then it is assumed to be a
   pointer to an existing 'net_dope' structure.  Such usage would be
   expected when called from a user-provided DLL.  Conversely, a regular
   application would include this file WITHOUT defining NET_DOPE.  This
   causes the application's static dope structure instance to be silently
   defined and used. */
#ifdef	NET_DOPE
	/* DLL usage */

#else	/*NET_DOPE*/
	/* normal application usage */
#define	NET_DOPE	(&net_dope)

struct net_dope net_dope;	/* The actual structure declaration. */

#endif	/*NET_DOPE*/

/* Conditionally deal with allowing non-task callers to co-exist in the
   task HANDLE space.  If the manifest NET_HTASK has been defined, then
   this library will cause the PC/TCP DLL to automatically generate a
   unique HANDLE-like identifier within whatever dope structure is
   being used (see notes on NET_DOPE above).  Conversely, a regular
   application will silently use the task HANDLE, as given by the
   'GetCurrentTask' call.  */
#define NULL_HTASK	((HANDLE) -1)
#ifdef	NET_HTASK
	/* DLL usage */

	/* force 'net_taskInit' to serialize the dope structure */
#define	HTASK	NULL_HTASK

#else	/*NET_HTASK*/
	/* normal application usage */

	/* silently supply this task's HANDLE to 'net_taskInit' */
#define HTASK	GetCurrentTask()

#endif	/*NET_HTASK*/


	/* Error code handling interface... */

#define net_errno	(NET_DOPE->netd_errno)
#define neterrno	((unsigned)(net_errno & 0xFF))
#define netsuberrno	((unsigned)((net_errno >> 8) & 0xFF))

/* ... now bring in the error code file, which will not define local
   variables for 'neterrno' nor 'netsuberrno' nor any of the error
   string arrays or functions ... */
#include <pctcp/error.h>


	/* Asynch message delivery interface... */

#define net_msgType	(NET_DOPE->netd_msgType)
/* Window message types (NET_ASWM_*). */
/*			0		   means undefined */
#define	NET_ASWM_POST	1		/* deliver using 'PostMessage' */
#define	NET_ASWM_SEND	2		/* deliver using 'SendMessage' */
#define NET_ASWM__RES	32		/* from here on is RESERVED */
/* Macros to extract bits of information from the 'wParam' in NET_ASWM_*
   messages. */
#define net_msgEvent(W)	((W) & 0xFF)	/* NET_AS_* event type */
#define net_msgND(W)	(((W) >> 8) & 0xFF)  /* ND # */


	/* Blocking request state structure... */

/* Structure containing the current state of a blocking (i/o) request.  A
   pointer to this is passed to any registered blocking request polling
   function, allowing that function knowledge of the progress of that request.
   It is worthy to note that, if the polling function is called at all
   (i.e. the request must block), it will be called at least twice, the
   last time just prior to completion of the requests, successful or no. */
struct wbrq {
	char		b_done;		/* request complete, last call */
	char		b_init;		/* initial call */
	char		b_opcode;	/* function code designator (below) */
	char		b_alarmed;	/* last try before timeout */
	DWORD		b_user1;	/* client-defined data #1 */
	DWORD		b_user2;	/* client-defined data #2 */
	int		b_errno;	/* completion or pending error */
	int		b_2pad;
	unsigned long	b_timeout;	/* msecs before timeout */
	DWORD		b_timeNext;	/* time of next pseudo-alarm */
	DWORD		b_timeNow;	/* time just sampled */
	DWORD		b_timeStart;	/* time at start of i/o call */
	union {		/* variant data, depending on 'b_opcode' */
		struct {	/* ND-based i/o */
			int		b_UDnd;		/* network descriptor */
			int		b_UD1pad;
		} b_ud;
		struct {	/* name service: address -> name; also PING */
			in_name		b_UAaddr;	/* address given */
		} b_una;
		struct {	/* name service: name -> address */
			LPSTR		b_UNname;	/* name given */
		} b_unn;
	} b_u;
};
/* Type of a far pointer to the above, typically used in declaring the
   posting function's input argument. */
typedef struct wbrq FAR *FARWBRQPT;
/* Manifest abbreviations of variant data above */
#define	b_nd		b_u.b_ud.b_UDnd
#define	b_hint		b_u.b_ud.b_UDhint
#define	b_addr		b_u.b_una.b_UAaddr
#define	b_name		b_u.b_unn.b_UNname

/* Function code designators in 'b_opcode'.  Generally follow the codes
   placed in the AH register for a PC/TCP kernel call. */
#ifndef NET_READ
#define	AD_DOMAIN	0x27		/* addr -> name: 'b_una' */
#define	AD_RES_NAME	0x25		/* addr -> name: 'b_una' */
#define	ICMP_PING	0x30		/* address: 'b_una' */
#define NET_CONNECT	0x13		/* ND-based: 'b_ud' */
#define NET_LISTEN	0x23		/* ND-based: 'b_ud' */
#define NET_READ	0x1B		/* ND-based: 'b_ud' */
#define NET_READFROM	0x1D		/* ND-based: 'b_ud' */
#define NET_RELEASE	0x08		/* ND-based: 'b_ud' */
#define NET_RELEASEALL	0x09		/* ND-based: 'b_ud' */
#define NET_WRITE	0x1A		/* ND-based: 'b_ud' */
#define NET_WRITETO	0x1C		/* ND-based: 'b_ud' */
#define	NM_DOMAIN	0x52		/* name -> addr: 'b_unn' */
#define	NM_RES_NAME	0x54		/* name -> addr: 'b_unn' */
#endif  /*NET_READ*/
/* Additional '[gs]et_option' and '[gs]_taskOption' selectors */
#define NET_OPT_POLLFN	0x7F		/* register a polling function */


	/* Private profile file contents... */

/* Private profile pathname which parameterizes this DLL. */
#define DLL_PROFILE	"pctcp.ini"
/* Names used within the profile file. */
#ifdef  NOT_YET
#define DLL_NAME        "pctcp wnetlib"
#else   /*NOT_YET*/
#define DLL_NAME        "pctcp pctcpapi"
#endif  /*NOT_YET*/
#define DLL_286DOSMapSize "286DOSMapSize" /* integer, # Kbytes of PM->DOS map */
#define DLL_dbgInt3     "dbgInt3"       /* integer, debug INT 3 flags */
#define DLL_errorLog    "errorLog"      /* string, logfile path (if any) */
#define DLL_initNDAs	"initNDAs"	/* integer, init # of NDAs */
#define DLL_maxTasks	"maxTasks"	/* integer, max # of DLL clients */
#define	DLL_msgType	"msgType"	/* integer, gives a WM_ thing */
#define DLL_postStksize	"postStksize"	/* integer, # bytes for posting stack */
#define DLL_kVsnOk      "kVsnOk"        /* *reserved* */
#define DLL_vsnOk       "vsnOk"         /* *reserved* */
/* Environment values to use to determine the path of PCTCP.INI. */
#define DLL_PROFPATH1	"PCTCP"		/* first choice */
#define DLL_PROFPATH2	"FTP_CONFIG"	/* second choice */
/* Bits in "dbgInt3" -- others are *reserved* */
#define DBGINT3_LibMain         0x1     /* before WNETLIB gets going */
#define DBGINT3_WEP             0x2     /* before WNETLIB unwinds to leave */
#define DBGINT3_bugCheck        0x4     /* going stop working soon */
#define DBGINT3_taskInit        0x8     /* at task registration */
#define DBGINT3_taskDestroy     0x10    /* at task deregistration */
#define DBGINT3_asynch          0x20    /* as WNETLIB is about to upcall */
#define DBGINT3_asynchw         0x40    /* as WNETLIB is about to message */
#define DBGINT3_asynchwFails    0x80    /* task PostMessage just failed */


	/* ICMP ECHO interface... */

/* The per-ping structure.  Holds the context of a currently active
   ICMP 'ping' request, as issued by 'icmp_echo'. */
typedef struct wping {
	int		p_nd;		/* network descriptor */
	unsword		p_id;		/* ECHO 'socket' # */
	unsigned	p_seq;		/* current/last ECHO sequence # */
	time_t		p_timeout;	/* number of ms. to wait */
	time_t		p_basetime;	/* time at start of query */
} wping;

#define PingRTT(P)	(GetTickCount() - (P)->p_basetime)

	/* Internal garf; mostly macros to interface to the API... */

/* Formal declarations of API function entrypoints.  Each normal PC/TCP
   entrypoint is defined as a macro, which in turn calls a DLL-based
   function.  All standard API functions are accounted for, including
   ones which are unsupported for WinApps (these return error statuses
   or do nothing).  Nearly all of the DLL functions take a pointer to
   the per-task network dope structure, which contains many useful
   objects.  This structure is instantiated by the "net_taskInit"
   call and destroyed by "net_taskDestroy". */

#define ad_domain(ADDR, NAME, LEN) \
	_ad_domain(DOPEP, ADDR, NAME, LEN)
int FAR _ad_domain(DOPEPT, in_name, char FAR *, unsigned);

#define ad_htable(ADDR, NAME, LEN) \
	_ad_htable(DOPEP, ADDR, NAME, LEN)
int FAR _ad_htable(DOPEPT, in_name, char FAR *, unsigned);

#define ad_res_name(ADDR, NAME, LEN) \
	_ad_res_name(DOPEP, ADDR, NAME, LEN)
int FAR _ad_res_name(DOPEPT, in_name, char FAR *, unsigned);

#define disable_asynch() \
	_disable_asynch(DOPEP)
int FAR _disable_asynch(DOPEPT);

#define enable_asynch() \
	_enable_asynch(DOPEP)
int FAR _enable_asynch(DOPEPT);

#define get_addr(ND) \
	_get_addr(DOPEP, ND)
in_name FAR _get_addr(DOPEPT, int);

#define get_configstruct(DEVNAME, SP, LEN) \
	_get_configstruct(DOPEP, DEVNAME, (void FAR *)(SP), LEN)
int FAR _get_configstruct(DOPEPT, char FAR *, void FAR *, unsigned);

#define get_kernel_info(ND, TAG, DEV_ID, DATA, SIZE) \
	_get_kernel_info(DOPEP, ND, TAG, DEV_ID, (void FAR *)(DATA), SIZE)
int FAR _get_kernel_info(DOPEPT, int, byte, byte, void FAR *, unsigned FAR *);

#define get_netversion() \
	_get_netversion()
int FAR _get_netversion();

#define get_option(ND, LEVEL, OPTION, VALUE, LEN) \
	_get_option(DOPEP, ND, LEVEL, OPTION, (char FAR *)(VALUE), LEN)
char FAR * FAR _get_option(DOPEPT, int, int, int, char FAR *, int);

#define GetPCTCPProfileInt(APPNAME, KEYNAME, DEFAULT) \
	_GetPCTCPProfileInt(APPNAME, KEYNAME, DEFAULT)
WORD FAR _GetPCTCPProfileInt(LPSTR, LPSTR, int);

#define GetPCTCPProfileString(APPNAME, KEYNAME, DEFAULT, RETURNSTRING, SIZE) \
	_GetPCTCPProfileString(APPNAME, KEYNAME, DEFAULT, RETURNSTRING, SIZE)
int FAR _GetPCTCPProfileString(LPSTR, LPSTR, LPSTR, LPSTR, int);

#define get_peer(ND, ADDR) \
	_get_peer(DOPEP, ND, ADDR)
int FAR _get_peer(DOPEPT, int, struct addr FAR *);

#define get_taskOption(OPTION, VALUE, LEN) \
	_get_taskOption(DOPEP, OPTION, (char FAR *)(VALUE), LEN)
char FAR * FAR _get_taskOption(DOPEPT, int, char FAR *, int);

#define icmp_echo(NPU, IN, DATA, DLEN, OPT, OLEN) \
	_icmp_echo(DOPEP, (long)(NPU), IN, (char FAR *)(DATA), DLEN \
	  , (unsigned char FAR *)(OPT), OLEN, 0L)
struct wping DLLFAR * FAR _icmp_echo(DOPEPT, long, in_name
  , char FAR *, unsigned, unsigned char FAR *, unsigned, long);

#define icmp_echo_rcv(PINGP, DATA, DLEN, OPT, OLENP) \
	_icmp_echo_rcv(DOPEP, PINGP, (char FAR *)(DATA), DLEN \
	  , (unsigned char FAR *)(OPT), OLENP, 0L)
unsigned FAR _icmp_echo_rcv(DOPEPT, struct wping DLLFAR *, char FAR *, unsigned
  , unsigned char FAR *, unsigned FAR *, long);

#define icmp_free(PINGP) \
	_icmp_free(DOPEP, PINGP)
int FAR _icmp_free(DOPEPT, struct wping DLLFAR *);

#define icmp_ping(HOST, LEN) \
	_icmp_ping(DOPEP, HOST, LEN)
int FAR _icmp_ping(DOPEPT, in_name, unsigned);

#define is_netnd(ND) \
	_is_netnd(DOPEP, ND)
int FAR _is_netnd(DOPEPT, int);

#define net_abort(ND) \
	_net_abort(DOPEP, ND)
int FAR _net_abort(DOPEPT, int);

#define net_abortall() \
	_net_abortall(DOPEP)
int FAR _net_abortall(DOPEPT);

#define net_alarm(ND, TIME, HANDLER, HINT) \
	_net_alarm(DOPEP, ND, TIME, HANDLER, HINT)
int FAR _net_alarm(DOPEPT, int, unsigned long, FpfiT, unsigned long);

#define net_asynch(ND, EVENT, HANDLER, HINT) \
	_net_asynch(DOPEP, ND, EVENT, HANDLER, HINT)
FpfiT FAR _net_asynch(DOPEPT, int, int, FpfiT, unsigned long);

#define net_asynchw(ND, EVENT, HWNDX, HOW) \
	_net_asynchw(DOPEP, ND, EVENT, HWNDX, HOW)
DWORD FAR _net_asynchw(DOPEPT, int, int, HWND, int);

#define net_config(TAG, DEV_ID, DATA, SIZE) \
	_net_config(DOPEP, TAG, DEV_ID, (void FAR *)(DATA), SIZE)
int FAR _net_config(DOPEPT, byte, byte, void FAR *, unsigned);

#define net_connect(ND, TYPE, ADDR) \
	_net_connect(DOPEP, ND, TYPE, ADDR)
int FAR _net_connect(DOPEPT, int, int, struct addr FAR *);

#define net_debug(P) \
	_net_debug(DOPEP, P)
int FAR _net_debug(DOPEPT, struct ifstat far *);

#define net_eof(ND) \
	_net_eof(DOPEP, ND)
int FAR _net_eof(DOPEPT, int);

#define net_errname() \
	_net_errname(DOPEP)
char FAR * FAR _net_errname(DOPEPT);

#define net_flush(ND) \
	_net_flush(DOPEP, ND)
int FAR _net_flush(DOPEPT, int);

#define net_getdesc() \
	_net_getdesc(DOPEP)
int FAR _net_getdesc(DOPEPT);

#define net_getglobdesc() \
	_net_getglobdesc(DOPEP)
int FAR _net_getglobdesc(DOPEPT);

#define net_get_k_conf(KC) \
	_net_get_k_conf(DOPEP, KC)
int FAR _net_get_k_conf(DOPEPT, struct kernel_conf FAR *);

#define net_globalize(ND) \
	_net_globalize(DOPEP, ND)
int FAR _net_globalize(DOPEPT, int);

#define net_info(ND, NI) \
	_net_info(DOPEP, ND, NI)
int FAR _net_info(DOPEPT, int, struct netinfo FAR *);

#define net_listen(ND, TYPE, ADDR) \
	_net_listen(DOPEP, ND, TYPE, ADDR)
int FAR _net_listen(DOPEPT, int, int, struct addr FAR *);

#define net_memAlloc(SIZE) \
	_net_memAlloc(DOPEP, SIZE)
char FAR * FAR _net_memAlloc(DOPEPT, unsigned);

#define net_memCheck(MEMP) \
	_net_memCheck(MEMP)
int FAR _net_memCheck(char FAR *);

#define net_memFree(MEMP) \
	_net_memFree(DOPEP, MEMP)
int FAR _net_memFree(DOPEPT, char FAR *);

#define net_memReAlloc(MEMP, SIZE) \
	_net_memReAlloc(DOPEP, MEMP, SIZE)
char FAR * FAR _net_memReAlloc(DOPEPT, char FAR *, unsigned);

#define net_read(ND, BUF, LEN, FROM, FLAGS) \
	_net_read(DOPEP, ND, (char FAR *)(BUF), LEN, FROM, FLAGS)
int FAR _net_read(DOPEPT, int, char FAR *, unsigned
  , struct addr FAR *, unsigned);

#define net_readfrom(ND, BUF, LEN, FROM, FLAGS) \
	_net_readfrom(DOPEP, ND, (char FAR *)(BUF), LEN, FROM, FLAGS)
int FAR _net_readfrom(DOPEPT, int, char FAR *, unsigned
  , struct addr FAR *, unsigned);

#define net_reconfig() \
	_net_reconfig()
void FAR _net_reconfig();

#define net_release(ND) \
	_net_release(DOPEP, ND)
int FAR _net_release(DOPEPT, int);

#define net_releaseall() \
	_net_releaseall(DOPEP)
int FAR _net_releaseall(DOPEPT);

#define net_select(MAXID, IFLAGS, OFLAGS) \
	_net_select(MAXID, (long FAR *)(IFLAGS), (long FAR *)(OFLAGS))
void FAR _net_select(int, long FAR *, long FAR *);

#define net_shutdown() \
	_net_shutdown(DOPEP)
void FAR _net_shutdown(DOPEPT);

#define net_stat(ND, STATS) \
	_net_stat(DOPEP, ND, STATS)
int FAR _net_stat(DOPEPT, int, struct net_stats FAR *);

#define net_suberrname() \
	_net_suberrname(DOPEP)
char FAR * FAR _net_suberrname(DOPEPT);

#define net_swap(ND1, ND2) \
	_net_swap(DOPEP, ND1, ND2)
int FAR _net_swap(DOPEPT, int, int);

#define net_taskDestroy() \
	_net_taskDestroy(DOPEP)
int FAR _net_taskDestroy(DOPEPT);

#define net_taskInit(NAME) \
	_net_taskInit(HTASK, DOPEP, NET_DOPE_VSN, NAME)
int FAR _net_taskInit(HANDLE, DOPEPT, int, char FAR *);

#define net_write(ND, BUF, LEN, FLAGS) \
	_net_write(DOPEP, ND, (char FAR *)(BUF), LEN, FLAGS)
int FAR _net_write(DOPEPT, int, char FAR *, unsigned, unsigned);

#define net_writeto(ND, BUF, LEN, TO, FLAGS) \
	_net_writeto(DOPEP, ND, (char FAR *)(BUF), LEN, TO, FLAGS)
int FAR _net_writeto(DOPEPT, int, char FAR *, unsigned
  , struct addr FAR *, unsigned);

#define nm_domain(NAME, CNAME, CNAME_LEN) \
	_nm_domain(DOPEP, NAME, CNAME, CNAME_LEN)
in_name FAR _nm_domain(DOPEPT, char FAR *, char FAR *, unsigned);

#define nm_htable(NAME, CNAME, CNAME_LEN) \
	_nm_htable(DOPEP, NAME, CNAME, CNAME_LEN)
in_name FAR _nm_htable(DOPEPT, char FAR *, char FAR *, unsigned);

#define nm_ien116(NAME) \
	_nm_ien116(DOPEP, NAME)
in_name FAR _nm_ien116(DOPEPT, char FAR *);

#define nm_prs_addr(NAME) \
	_nm_prs_addr(DOPEP, NAME)
in_name FAR _nm_prs_addr(DOPEPT, char FAR *);

#define nm_res_name(NAME, CNAME, CNAME_LEN) \
	_nm_res_name(DOPEP, NAME, CNAME, CNAME_LEN)
in_name FAR _nm_res_name(DOPEPT, char FAR *, char FAR *, unsigned);

#ifdef undef
#define pneterror(msg)\
        if ((msg) != (char *) 0) {\
		char buffer[256] ;\
		wsprintf (buffer, "%s: %s", msg, net_errname());\
		MessageBox(NULL, buffer, "PC/TCP Error", MB_OK|MB_ICONSTOP);\
	}
#endif

#define set_option(ND, LEVEL, OPTION, VALUE, LEN) \
	_set_option(DOPEP, ND, LEVEL, OPTION, (char FAR *)(VALUE), LEN)
int FAR _set_option(DOPEPT, int, int, int, char FAR *, int);

#define set_taskOption(OPTION, VALUE, LEN) \
	_set_taskOption(DOPEP, OPTION, (char FAR *)(VALUE), LEN)
int FAR _set_taskOption(DOPEPT, int, char FAR *, int);

#define is_kernel_busy() \
	_is_kernel_busy(DOPEP)
int FAR _is_kernel_busy(DOPEPT);

int FAR pctcpapi_getnetversion(void);

int FAR wnet286_getnetversion(void);

int FAR wnet386_getnetversion(void);

#endif	/* _WINAPP_H */
/* eof */

/*
 * $Log:   J:/22vcs/include/pctcp/winapp.h_v  $
 * 
 *    Rev 1.13   25 Sep 1992 12:32:04   natalia
 * kek Prototype *_getnetversion() routines.
 * 
 *    Rev 1.12   22 Jun 1992 16:59:10   paul
 * track changes from 2.1
 * 
 *    Rev 1.12   29 May 1992 16:45:08   arnoff
 * jbvb@ftp  Added ND to net_globalize macro.
 * 
 *    Rev 1.11   28 Apr 1992 19:30:58   arnoff
 *  * 27-Apr-92  kek@ftp	Change to suit 286 DLL.
 * 
 *    Rev 1.10   03 Feb 1992 23:27:30   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.9   30 Jan 1992 19:49:30   arnoff
 *  
 */
