/*
 * $Header:   K:\devkit.dos\vcs\include\pctcp\telnet.h_v   1.11.1.1   08 Apr 1993 17:31:04   arnoff  $
 */

#ifndef __TELNET_HEADER__
#define __TELNET_HEADER__



/*
 * Copyright (C) 1986-1992 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 11-Mar-88	jbvb	Add output buffer, definition for tn_write()
 * 17-Mar-88    joga    Added tn_bin_mode[] to telnet structure and appropiate
 *                      #defines to describe status of binary options, and
 *                      definitions for tn_rqst_bin() and tn_bin_off().
 * 18-Mar-88    jog     Added tn_is_bin(tn) macro;   
 * 08-Jun-88    joga    Added tn_cname to structure for multiple connections.
 * 01-Aug-88    jog     Added tn_term_index (init to 0)
 * 02-Sep-88    jog     func. ptr to routine to send term type to remote host
 * 06-Sep-88	jbvb	Add function prototypes, remove line noise.
 * 06-Sep-88	jog	Func called by func ptr returns char * to ascii string
 *                      to send as term type
 * 17-May-89	jbvb	Make tn_putc()'s argument an unsigned char.
 * 10-Aug-89    jog     Added abort(), _remote(), _local(), _ayt() and 
 *                      _break() declarations
 * 17-Aug-89	jbvb	Prevent negotiation loops on SPGA & TTTYPE
 * 11-Dec-89    jog     make tn_is_open test tn == NULL also
 * 09-Mar-90	kek	Added tel_mode union to make room for local and
 *			 remote eor modes.
 * 13-Mar-90	kek	Added tn3270 indicator to telnet structure.
 * 22-May-90	kek	Enlarged tn_wbuf for tn3270 ReadBuffer problem.
 * 04-Sep-90	kek	Define TN_FLG_RAW
 * 04-Oct-90	kek	Bill's macro fix
 * 17-Oct-90	kek	Remove unneccessary tn_echolocal/remote() definitions.
 * 18-Oct-90	kek	Make blocked a structure member, not a global.
 * 22-Apr-91	kek	Rename spga to do_spga & define will_spga to avoid 
 *			 negotiation loop.
 * 25-Feb-92	paul	added parameter to function pointer in 
 *			 telnet.send_ttype, tn_open(send_term_func)
 */

/* the telnet control structure, passed around by applications using
	the telnet library     */
	
union tel_mode {
	char tn_bin_mode[2];
	struct {
		unsigned char rem_eor_mode:2;
		unsigned char rem_bin_mode:2;
		unsigned char loc_eor_mode:2;
		unsigned char loc_bin_mode:2;
	} u;
} ;

typedef	struct telnet {
	int	tn_tcp;		/* the telnet's TCP connection */
	unsigned tttype: 1;	/* Have we agreed to TTTYPE? */
	unsigned do_spga: 1;	/* Have we agreed to Do SPGA? */
				/* (spga in previous releases) */
	unsigned tn3270: 1;	/* Is this a tn3270 connection?? */
	unsigned blocked: 1;    /* Blocked in tn_write?? */
	unsigned will_spga: 1;  /* Have we agreed to Will SPGA? */
	unsigned res_1: 11;     /* Reserved flag bits */
	char	tn_echom;	/* Echo mode */
				/* LOCAL - local echo */
				/* REMOTE - remote echo */
	char	tn_echongo;	/* Echo negotiation request outstanding */
				/* NORMALMODE */
				/* LECHOREQ - IAC DONT ECHO was sent */
				/* RECHOREQ - IAC DO ECHO was sent */
	union	tel_mode tn_modes;
		                /* OFF  (0)  */
				/* ON   (1)  */
				/* reqtosend */
				/* reqtostop */
	int	tn_wmode;	/* write mode */
	int	tn_chars;	/* # of valid characters in buffer */
	int	tn_next;	/* next character in buffer */
	unsigned char tn_buf[512];	/* buffer */
	int	tn_wchars;		/* Number of characters in wbuf */
	int	tn_wnext;		/* Next char to write in wbuf */
	unsigned char tn_wbuf[512];	/* Output buffer */
	char   *tn_cname;  		/* -> canonical name of rem host  */
	int     tn_term_index;		/* indicates term type negotiated */
	char   *(*send_ttype)(struct telnet *);/* func ptr->rets ttype to send   */
	char    principal[64];		/* kerberos local identifier	  */
	char	kerberos4_auth;		/* do kerberos authentication flag*/
	char	kerberos4_only;	/* close connection if kerberos fails*/
	char	kerberos4_realm[64];	/* user defined realm name */
	} telnet;
#define	BLOCK		1
#define NOBLOCK		2
#define URGENTM		1
#define EVERYC		1
#define NEWLINE		2
#define LOCAL		1
#define REMOTE		2

#define	NORMALMODE	1
#define LECHOREQ	2
#define RECHOREQ	3
                                /* binary option status  */
#define OFF          0    /* host not sending binary, no neg in progress   */
#define ON           1    /* host sending binary, no neg in progress       */
#define reqtosend    2    /* outstanding req for host to start sending bin */
#define reqtostop    3    /* outstanding req for host to stop sending bin  */

#define	TN_FLG_RAW  0x0100	/* raw telnet data  for tn_write */


					/* remote hosts status: = to one */
#define rem_bin_mode(tn)  (tn)->tn_modes.u.rem_bin_mode
					/* local    "     "   : of above */
#define loc_bin_mode(tn)  (tn)->tn_modes.u.loc_bin_mode

#define rem_eor_mode(tn)  (tn)->tn_modes.u.rem_eor_mode
#define loc_eor_mode(tn)  (tn)->tn_modes.u.loc_eor_mode


#define	tn_is_open(tn)	((tn) && ((tn)->tn_tcp >= 0))
#define	tn_is_bin(tn)	((rem_bin_mode(tn) == ON) && (loc_bin_mode(tn) == ON))

/* telnet entry points */
telnet *tn_open(in_name, unsigned, char *(*)(telnet *));
int tn_getc(telnet *);
int tn_putc(telnet *, unsigned char);
int tn_close(telnet *);
int tn_write(telnet *, char *, int, unsigned);
int tn_rqst_bin(telnet *);
int tn_bin_off(telnet *);

int tn_local(telnet *);
int tn_remote(telnet *);
int tn_abort(telnet *);
int tn_break(telnet *);
int tn_ayt(telnet *);

/*
 * $Log:   K:\devkit.dos\vcs\include\pctcp\telnet.h_v  $
 * 
 *    Rev 1.11.1.1   08 Apr 1993 17:31:04   arnoff
 * Protected from multiple includes.
 * 
 *    Rev 1.11   06 Oct 1992 14:30:42   betty
 * kerberized version -- Betty & Arnoff
 * 
 *    Rev 1.10   12 Apr 1992 21:21:02   arnoff
 * Added parameter to function pointer in 
 *   telnet.send_ttype, tn_open(send_term_func).
 * 
 *    Rev 1.9   03 Feb 1992 23:27:18   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:49:20   arnoff
 *  
 */


#endif /* __TELNET_HEADER__ */

