/*
 * $Header:   K:\devkit.dos\vcs\include\pctcp\stats.h_v   1.14.1.1   08 Apr 1993 17:29:56   arnoff  $
 */

#ifndef __STATS_HEADER__
#define __STATS_HEADER__


/*
 * INCLUDE\PCTCP\STATS.H
 *
 * Copyright (C) 1988-1992 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 09-Sep-88	jbvb	Add display_stat() definition.
 * 07-Apr-92	kek	Warning for structure size changes affecting VxD.
 * 21-Aug-92	daveb	added comments describing fields (their meanings
 *			differ by protocol: see srccmd/pctcp/general.c)
 * 27-Aug-92	Ben	Added missing semi-colon to display_stat definition.
 * 03-Nov-92	snyders	ifdef net_stat prototype on MSW3.
 */

/*
 * WARNING: If you change the size of this structure, make sure to 
 *	    reflect the change in srcdrv/vxd/vpctcp.inc's LEN_STATS EQUATE!
 */
struct net_stats {
	unsigned long	bytes_unxmt;   /* Fields defined below */
	unsigned long	bytes_unrcv;
	unsigned long	oob_bytes_unxmt;
	unsigned long	oob_bytes_unrcv;
	unsigned long	bytes_xmt;
	unsigned long	bytes_rcv;
	unsigned long	oob_bytes_xmt;
	unsigned long	oob_bytes_rcv;
	unsigned long	pkts_xmt;
	unsigned long	pkts_rcv;
	unsigned long	bad_xsums;
	unsigned long	prot_errors;
	unsigned long	timeouts;
	unsigned long	errors;
	unsigned long	rcv_retransmits;
	unsigned long	xmt_retransmits;
	};

#ifndef	MSW3
int	net_stat(int, struct net_stats *);
#endif	/*MSW3*/
int	display_stat(int (*)(char *));


/* ------------Information on the net_stats structure--------------------- 
	The information returned by the net_stat() function call depends on
	network descriptor passed into the function.  In general, net_stat()
	will return information about a connection described by the network
	descriptor.  If one passes values -1, -2, -3, or -4 into the
	net_stat() as a network descriptor (Note that these are invalid 
	numbers for network descriptors: local descriptors (returned by 
	net_getdesc()) are numbers between 0 and 31 and global descriptors
	(returned by net_getglobdesc()) are numbers greater than 64.), then 
	information specific to a certain protocol subtree is returned.
	
	If nd == -1: TCP Protocol information
	If nd == -2: IP Protocol information
	If nd == -3: UDP Protocol information
	If nd == -4: ICMP Protocol information
	
	Note that the net_stats structure (defined above) is returned in all
	cases, to conserve space.  The fields have the same names, but have 
	different interpretations based on the protocol family.  Below the 
	field are described for each protocol:

For the TCP Protocol (nd == -1):
struct net_stats {
    bytes_unxmt:	unused
    bytes_unrcv:	unused
    oob_bytes_unxmt:	unused
    oob_bytes_unrcv:	unused
    bytes_xmt:		TCP bytes sent 
    bytes_rcv:		TCP bytes received
    oob_bytes_xmt:	unused
    oob_bytes_rcv:	unused
    pkts_xmt:		TCP packets sent
    pkts_rcv:		TCP packets received
    bad_xsums:		TCP bad checksums received
    prot_errors:	TCP window ignored by fhost
    timeouts:		TCP segments timed-out
    errors:		TCP resets sent and received
    rcv_retransmits:	TCP retransmits received
    xmt_retransmits:	TCP retransmits sent
};


For the IP Protocol (nd == -2):
struct net_stats {
    bytes_unxmt:	unused
    bytes_unrcv:	unused
    oob_bytes_unxmt:	IP invalid length errors (header vs. actual 
	                    received length)
    oob_bytes_unrcv:	IP protocol errors (no protocol on top of IP 
			    listening for these IP packets.  Also indicates 
			    number of ICMP Destination unreachable packets
			    issued.
    bytes_xmt:		IP duplicate fragments received 
    bytes_rcv:		IP bad fragments received 
    oob_bytes_xmt:	IP bad security received
    oob_bytes_rcv:	IP bad IP address received 
    pkts_xmt:		IP packets sent
    pkts_rcv:		IP packets received 
    bad_xsums:		IP bad checksum received
    prot_errors:	sum of IP errors:
	                    IP invalid length (in oob_bytes_unxmt)
			    IP protocol (in oob_bytes_unrecv),
			    IP version number mis-match
			    IP packets rcvd *not* for this IP addr
    timeouts:		difference of the number of IP fragments received and
			    the sum of the number of bad fragments received, 
			    number of duplicate fragments, and the number of 
			    fragments successfully reassembled.
    errors:		sum of the number of IP packets discarded, bad IP 
			    fragments, and packets with bad IP security
    rcv_retransmits:	IP fragments received
    xmt_retransmits:	unused
};

For the UDP Protocol (nd == -3):
struct net_stats {
    bytes_unxmt:	unused
    bytes_unrcv:	unused
    oob_bytes_unxmt:	unused
    oob_bytes_unrcv:	unused
    bytes_xmt:		unused
    bytes_rcv:		unused
    oob_bytes_xmt:	unused
    oob_bytes_rcv:	UDP datagrams dropped for lack of packet buffer space
    pkts_xmt:		UDP datagrams sent	
    pkts_rcv:		UDP datagrams received
    bad_xsums:		UDP checksum present, but checksum was bad
    prot_errors:	no application listening for received UDP datagram
    timeouts:		unused
    errors:		Datagram's receive length less than length in header
    rcv_retransmits:	unused
    xmt_retransmits:	unused
};

For the ICMP Protocol (nd == -4):
struct net_stats {
    bytes_unxmt:	Time Exceeded messages issued
    bytes_unrcv:	Time Exceeded messages received
    oob_bytes_unxmt:	Parameter Problem messages issued 
    oob_bytes_unrcv:	Parameter Problem messages received
    bytes_xmt:		Redirect messages received
    bytes_rcv:		Source Quench messages received 
    oob_bytes_xmt:	Echo Requests sent
    oob_bytes_rcv:	Echo Requests received
    pkts_xmt:		Total ICMP messages sent
    pkts_rcv:		Total ICMP messages received
    bad_xsums:		ICMP messages received with bad ICMP checksum
    prot_errors:	Destination Unreachable messages received
    timeouts:		PC/TCP unable to transmit ICMP message
    errors:		Destination Unreachable messages sent
    rcv_retransmits:	Echo Replies received 
    xmt_retransmits:	Echo Replies sent
};


Note that all elements of this structure are unsigned long counters of 
the given events.

------------Information on the net_stats structure--------------------- */

/*
 * $Log:   K:\devkit.dos\vcs\include\pctcp\stats.h_v  $
 * 
 *    Rev 1.14.1.1   08 Apr 1993 17:29:56   arnoff
 * Protected from multiple includes.
 * 
 *    Rev 1.14   03 Nov 1992 15:43:16   snyders
 * ifdef net_stat prototype on MSW3. checked by paul.
 * 
 *    Rev 1.13   27 Aug 1992 12:35:18   arnoff
 * Also added a missing ')'.   ---Ben
 * 
 *    Rev 1.12   27 Aug 1992 11:53:20   arnoff
 * Added missing semi-colon to display_stat definition.   ---Ben
 * 
 *    Rev 1.11   26 Aug 1992 20:33:56   arnoff
 *  * 21-Aug-92	daveb	added comments describing fields (their meanings
 *  *			differ by protocol: see srccmd/pctcp/general.c)
 * 
 *    Rev 1.10   07 Apr 1992 21:14:32   arnoff
 *  * 07-Apr-92	kek	Warning for structure size changes affecting VxD.
 * 
 *    Rev 1.9   03 Feb 1992 23:27:12   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:49:14   arnoff
 *  
 */


#endif /* __STATS_HEADER__ */

