/*
 * $Header:   K:\devkit.dos\vcs\include\pctcp\rlogin.h_v   1.9.1.1   08 Apr 1993 17:27:36   arnoff  $
 */

#ifndef __RLOGIN_HEADER__
#define __RLOGIN_HEADER__



/*
 * INCLUDE\PCTCP\RLOGIN.H
 *
 * Copyright (C) 1986,1991 by FTP Software, Inc., all rights reserved.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 17-Jun-89	joga    began edit history
 *                      (re?) Added rl_cname to struct for mult. connections.
 * 17-Aug-89	jbvb	Add function prototypes.
 * 11-Dec-89    jog     make rl_is_open test rl == NULL also
 * 23-Jan-91    kek	Prototype rl_write().
 */

/* the rlogin control structure, passed around by applications using
 * the rlogin library
 */
typedef	struct rlogin {
	int	rl_tcp;		/* the rlogin's TCP connection */
	int	rl_chars;	/* # of valid characters in buffer */
	int	rl_next;	/* next character in buffer */
	unsigned char rl_buf[512];	/* buffer */
	char   *rl_cname;  		/* -> canonical name of remote host */
	} rlogin;

#define	rl_is_open(rl)	((rl) && ((rl)->rl_tcp >= 0))

/* rlogin function declarations
*/
rlogin *rl_open(in_name, char *, char *);
int	rl_close(rlogin *);
int	rl_abort(rlogin *);
int	rl_putc(rlogin *, char);
int	rl_getc(rlogin *);
int	rl_write(rlogin *, char *, int);

/*
 * $Log:   K:\devkit.dos\vcs\include\pctcp\rlogin.h_v  $
 * 
 *    Rev 1.9.1.1   08 Apr 1993 17:27:36   arnoff
 * Protected from multiple includes.
 * 
 *    Rev 1.9   03 Feb 1992 23:27:02   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:49:04   arnoff
 *  
 */


#endif /* __RLOGIN_HEADER__ */

