/*
 * $Header:   E:/22vcs/include/pctcp/pctcp.h_v   1.15   12 Nov 1992 12:39:54   snyders  $
 */

/*
 * INCLUDE\PCTCP\PCTCP.H
 *
 * Copyright (C) 1986 - 1992 by FTP Software, Inc.  All rights  reserved.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * 
 * EDIT HISTORY:
 * 19-Sep-87	romkey	added missing nm_prs_addr() declaration
 * 23-Feb-88	jbvb	net_releaseall() can return an error.
 * 24-Mar-88	jbvb	Add declarations for more routines.
 * 02-May-88	jbvb	Declare inet_ntoa() (note argument has different type
 *			 than given in 4BSDDEFS.H)
 * 25-Aug-88	jbvb	Add definition for RAW_ICMP connection type.
 * 17-Aug-89	jbvb	Always use function prototypes, fix inet_ntoa() decl,
 *			 remove net_recv(), net_recvfrom().
 * 18-Sep-89	jbvb	Avoid conflict with sockets over inet_ntoa()
 * 20-Sep-89	jbvb	Create NET_FLG_DONTTRUNCATE, for short datagram reads.
 * 20-Jan-91	jog	all functions that take no args, protptyped (void)
 * 31-Jan-91	jog	add prototype for pr_notice and helperr..
 * 18-Jun-91	gub	Add prototype for net_config(), remove net_reconfig()
 * 12-Aug-91	gub	Add prototype for get_kernel_info()
 * 15-Aug-91	gub	Fix get_kernel_info() to take a length pointer
 *			 + replace net_reconfig()
 * 10-Sep-91 msd@ayuda	Pad struct addr cuz the 2.10 kernel copies more!
 * 10-Sep-91	Ben	Added 'net_yield'.
 * 06-Jan-92	kek	Incorporated msd version into source tree.
 * 14-Jan-92	Ben	Protected against multiple inclusion
 * 07-Apr-92	kek	Warning for structure size changes affecting VxD.
 * 09-Jun-92	wcl	Added NET_FLG_APPEND and NET_FLG_OVERSIZE
 * 21-Jul-92	paul	added changed from 2.1:
 *  11-May-92	jbvb	Define NET_FLG_REROUTE.
 *  10-Jul-92	jbvb	Get rid of padding in struct addr for compatibility.
 * 18-Sep-92	snyders	net_shutdown returns int not void following davec's
 *			change in \netlib\syscall5.asm
 * 09-Nov-92	snyders changed size parameter in get_kernel_info to be
 *			unsigned.
 */


#ifndef _PCTCP_PCTCP_H
#define _PCTCP_PCTCP_H INCLUDED

/* network address structure for net_connect() and net_listen() for types
 *	RAW_IP, DGRAM and STREAM
 *
 * WARNING: If you change the size of this structure, make sure to 
 *	    reflect the change in srcdrv/vxd/vpctcp.inc's LEN_ADDR EQUATE!
 */

struct addr {
	in_name		fhost;
	unsigned	fsocket;
	unsigned	lsocket;
	unsigned char	protocol;
	};

/* network address structure for net_connect() and net_listen() for type
	RAW_NET. class and type values are found in <pctcp/interfaces.h>
*/
struct rawnet_addr {
	int	class;
	int	type;
	int	number;
	};

/* connection types for net_connect() and net_listen()
*/
#define	RAW_NET		1
#define	RAW_IP		2
#define	DGRAM		3
#define	STREAM		4
#define	RAW_ICMP	5

/* flags for net_read(), net_readfrom(), net_recv(), net_recvfrom(),
	net_write(), net_writeto(), net_send(), net_sendto()
*/
#define	NET_FLG_OOB		0x0001	/* out of band data */
#define	NET_FLG_PEEK		0x0002	/* don't dequeue data */
#define	NET_FLG_DRAIN		0x0004	/* don't copy data */
#define	NET_FLG_REROUTE		0x0008	/* request re-routing */
#define	NET_FLG_PUSH		0x0010	/* reserved */
#define	NET_FLG_DONTTRUNCATE	0x0020	/* Don't truncate oversized dgram */
#define	NET_FLG_NONBLOCKING	0x0040	/* don't block */
#define	NET_FLG_BROADCAST	0x0080	/* broadcast data */
#define	NET_FLG_OVERSIZE	0x0100	/* outgoing IP fragmentation */
#define	NET_FLG_APPEND		0x0200	/* Don't write the packet to driver */
					/*  until this flag is NOT set */


/* Declarations for the PC/TCP network library */
#ifndef	MSW3
int	ad_res_name(in_name, char *, unsigned);
int	ad_htable(in_name, char *, unsigned);
int	ad_domain(in_name, char *, unsigned);
int	net_getdesc(void);
int	net_getglobdesc(void);
int	net_globalize(int);
int	net_swap(int, int);
int	is_netnd(int);
int	net_connect(int, int, struct addr *);
int	net_listen(int, int, struct addr *);
in_name	get_addr(int);
int	get_peer(int, struct addr *);
int	net_select(int, long *, long *);
int	net_read(int, char *, unsigned, struct addr *, unsigned);
int	net_readfrom(int, char *, unsigned, struct addr *, unsigned);
int	net_write(int, char *, unsigned, unsigned);
int	net_writeto(int, char *, unsigned, struct addr *, unsigned);
int	net_eof(int);
int	net_flush(int);
int	net_release(int);
int	net_releaseall(void);
int	net_abort(int);
int	net_abortall(void);
int	net_yield(void);
int	net_reconfig(void);
int	net_config(byte, byte, void far *, unsigned);
int	get_kernel_info(int, byte, byte, void far *, unsigned far *);
int	get_netversion(void);
int	net_shutdown(void);
int	disable_asynch(void);
int	enable_asynch(void);
in_name	nm_res_name(char *, char *, int);
in_name	nm_prs_addr(char *);
in_name	nm_ien116(char *);
in_name	nm_domain(char *, char *, int);
in_name	nm_htable(char *, char *, int);
int	icmp_ping(in_name, int);
#ifndef SOCKETS
char	*inet_ntoa(in_name);
#endif
#endif	/*MSW3*/

void pr_notice(char *);
void helperr(int, char *, char *);

#endif /* _PCTCP_PCTCP_H */

/*
 * $Log:   E:/22vcs/include/pctcp/pctcp.h_v  $
 * 
 *    Rev 1.15   12 Nov 1992 12:39:54   snyders
 * Changed size parameter in get_kernel_info to be unsigned.
 * 
 *    Rev 1.14   18 Sep 1992 16:03:50   snyders
 * net_shutdown returns int not void
 * 
 *    Rev 1.13   21 Jul 1992 18:28:16   paul
 * added changed from 2.1:
 *  *  11-May-92	jbvb	Define NET_FLG_REROUTE.
 *  *  10-Jul-92	jbvb	Get rid of padding in struct addr for compatibility.
 * 
 *    Rev 1.12   03 Jul 1992 17:05:06   bill
 * Added NET_FLG_APPEND and NET_FLG_OVERSIZE
 * 
 *    Rev 1.10   07 Apr 1992 21:12:12   arnoff
 *  * 07-Apr-92	kek	Warning for structure size changes affecting VxD.
 * 
 *    Rev 1.9   03 Feb 1992 23:26:56   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:49:00   arnoff
 *  
 */
