/*
 * $Header:   K:\devkit.dos\vcs\include\pctcp\netinfo.h_v   1.11.1.1   08 Apr 1993 17:26:52   arnoff  $
 */

#ifndef __NETINFO_HEADER__
#define __NETINFO_HEADER__



/*
 * Copyright (C) 1987-1992 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History:
 * 07-Apr-92	kek	Warning for structure size changes affecting VxD.
 * 03-Nov-92	snyders	ifdef net_info prototype on MSW3.
 */

/* this structure is returned by the net_info() system call, and provides
 *	information about a network interface
 *
 * WARNING: If you change the size of this structure, make sure to 
 *	    reflect the change in srcdrv/vxd/vpctcp.inc's LEN_NETINFO EQUATE!
 */
struct netinfo {
	int	class;		/* the class of interface: 802.3, 802.5,... */
	int	type;		/* the type of the interface: manufacturer */
	int	number;		/* interface # 0, 1, ... of this class/type */
	in_name	ip_address;	/* this interface's IP address */
	in_name	ip_subnet;	/* this interface's subnet and network mask */
	int	up;		/* true if this interface is up */
	unsigned long in;	/* # of packets received */
	unsigned long out;	/* # of packets transmitted */
	unsigned long inerr;	/* # of receiver errors */
	unsigned long outerr;	/* # of transmitter errors */
	int	lanlen;		/* length of local net address */
	unsbyte	far *lanaddr;	/* pointer to the lan address */
	};

#ifndef	MSW3
int net_info(int, struct netinfo *);
#endif	/*MSW3*/

/*
 * $Log:   K:\devkit.dos\vcs\include\pctcp\netinfo.h_v  $
 * 
 *    Rev 1.11.1.1   08 Apr 1993 17:26:52   arnoff
 * Protected from multiple includes.
 * 
 *    Rev 1.11   03 Nov 1992 15:44:12   snyders
 * ifdef net_info prototype on MSW3. checked by paul.
 * 
 *    Rev 1.10   07 Apr 1992 21:13:58   arnoff
 *  * 07-Apr-92	kek	Warning for structure size changes affecting VxD.
 * 
 *    Rev 1.9   03 Feb 1992 23:26:48   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:48:52   arnoff
 *  
 */


#endif /* __NETINFO_HEADER__ */

