/*
 * $Header:   K:\devkit.dos\vcs\include\pctcp\interfac.h_v   1.9.1.1   08 Apr 1993 17:26:06   arnoff  $
 */

#ifndef __INTERFAC_HEADER__
#define __INTERFAC_HEADER__



/*
 * INCLUDE\INTERFAC.H - Define interface type & class constants for PC/TCP.
 */

/* Copyright (C) 1986,1988 by FTP Software, Inc.  All rights reserved.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 *
 * EDIT HISTORY:
 * 31-Aug-87	jbvb/romkey	Added WD8003, 3C503 definitions.
 * 31-Aug-87	romkey		Added new class for Banyan Vines.
 * 22-Sep-87	romkey		Inserted 'extern' before if_classes.
 * 25-Feb-88	jbvb	Add TRW PC-2000, update NT_NUM_TYPES to 15.
 * 21-Apr-88	jbvb	Add 3Com 3C523, DEC DEPCA, NT_NUM_TYPES now 17.
 * 23-May-88	jbvb	AT&T Network Access Unit moved to ETHERNET class
 * 20-Sep-88	jbvb	Add GENERIC type & class (for IFCUST.SYS).
 * 06-Oct-88	jbvb	Add NT_TIARA for Tiara LCE/LCE2 cards.
 * 02-Nov-88	jbvb	Add NT_INTEL for Intel PC586E demo cards.
 * 29-Nov-88	dab	Added Gateway Communications numbers.
 * 09-Dec-88	dab	Removed previous.  We decided that the two lists
 *			of numbers would not be the same after all.
 * 12-Jan-89	jbvb	Added 6 ATKK cards (smart & dumb for PC98, AX, FMR)
 * 1-Oct-90	wcl	Added NT_GENERIC_TR and NT_PPP
 */

/* constants used to name various classes and kinds of network interfaces.
	this is mostly used by custom, the cardfinder, and the interface
	initialization routine for consistency checking.
*/

/* interface classes */
#define	NC_ETHERNET	1
#define	NC_PRONET	2
#define	NC_IEEE8025	3
#define	NC_OMNINET	4
#define	NC_APPLETALK	5
#define	NC_SERIAL	6
#define	NC_STARLAN	7
#define	NC_DDN		8
#define	NC_VINES	9
#define	NC_GENERIC	10

#define	NC_NUM_CLASSES	10

/* specific interface types:
	ETHERNET
*/
#define	NT_ETHDRV	0	/* generic ethernet packet driver */
#define	NT_3C500	1	/* 3COM etherlink interface */
#define	NT_3C505	2	/* 3COM smart card */
#define	NT_NI5010	3	/* Interlan NI5010 interface */
#define	NT_BDN4110	4	/* BICC 4110 interface */
#define	NT_BDNINT	5	/* BICC 4110 via int 5b interface */
#define	NT_NP600	6	/* Interlan NP600 interface */
#define	NT_EBANYAN	7	/* Banyan ethernet packet driver */
#define	NT_UBNIC	8	/* Ungermann-Bass Net. Interface Controller */
#define	NT_UNIVATION	9	/* Univation ethernet interface */
#define	NT_EXOS205	10	/* Excelan EXOS 205 ethernet interface */
#define	NT_DP839EB	11	/* National Semiconductor DP839EB interface */
#define NT_NI5210	12	/* Interlan NI5210 interface */
#define NT_WD8003	13	/* Western Digital WD8003 interface */
#define NT_3C503	14	/* 3Com 3C503 Ethernet interface */
#define NT_TRWPC20	15	/* TRW PC-2000 interface (dumb version) */
#define NT_3C523	16	/* 3Com 3C523 (IE-MC) interface */
#define NT_DEPCA	17	/* DEC DEPCA resident driver interface */
#define	NT_ATT_NAU	18	/* AT&T Network Adapter Unit */
#define	NT_TIARA	19	/* Tiara LCE/LCE2 Ethernet card */
#define	NT_INTEL	20	/* Intel PC586E Ethernet card */
#define NT_SIC98	21	/* ATKK SIC for PC98 */
#define NT_SIU98	22	/* ATKK SIU for PC98 */
#define NT_SICAX	23	/* ATKK SIC for AX */
#define NT_SIUAX	24	/* ATKK SIU for AX */
#define NT_SICFMR	25	/* ATKK SIC for FMR */
#define NT_SIUFMR	26	/* ATKK SIU for FMR */


/*	PRONET
*/
#define	NT_P1300	1	/* proNET 10 interface */
#define	NT_PR_NOVELL	2	/* Novell ProNET packet driver */

/* IEEE 802.5 Token Ring
*/
#define	NT_IBM_TR	1	/* IBM Token ring interface */
#define	NT_P1340	2	/* Proteon p1340/p1344 ProNET-4 interface */
#define	NT_GENERIC_TR	3

/*	SERIAL lines
*/
#define	NT_OLD_MIT	1	/* old MIT serial line protocol */
#define	NT_JNC_COMPRESS	2	/* Noel Chiappa's compression protocol */
#define	NT_SLIP		3	/* Serial Line IP: rick@seismo's protocol */
#define	NT_PPP		4	/* PointtoPointProtocol */

/*	StarLan interfaces (Starlan merged with Ethernet 5/23/88)
*/

/* 	DDN interfaces
 *		1822 or X.25
 */
#define	NT_SCOPE	1	/* SCOPE 1822/X.25 board */

/*	Generic (IP address and Subnet only) interface
 */
#define NT_GENERIC	1

#ifndef	NT_GENERIC_TR
#define	NT_GENERIC_TR	3
#endif

#define	NT_NUM_TYPES	26

/* macros for composing and decomposing network interface names */
#define	mk_interface(class, type)	(((class)<<8)|(type))
#define	get_if_class(if)	((if)>>8)
#define	get_if_type(if)		((if)&0xff)

/* useful externals */
extern char *if_classes[];	/* names of the classes of interaces */

/*
 * $Log:   K:\devkit.dos\vcs\include\pctcp\interfac.h_v  $
 * 
 *    Rev 1.9.1.1   08 Apr 1993 17:26:06   arnoff
 * Protected from multiple includes.
 * 
 *    Rev 1.9   03 Feb 1992 23:26:40   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:48:40   arnoff
 *  
 */


#endif /* __INTERFAC_HEADER__ */

