/*
 * $Header:   K:\devkit.dos\vcs\include\pctcp\if_info.h_v   1.9.1.1   08 Apr 1993 17:25:36   arnoff  $
 */

#ifndef __IF_INFO_HEADER__
#define __IF_INFO_HEADER__



/*
 * Copyright (C) 1986,1991 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * EDIT HISTORY:
 * 	9/3/86	Romkey	added IFF_FAST_SPEED and IFF_BACK2BACK flags
 * 	11/1/86	Romkey	added IFF_DOES_MEMORY in support of interfaces that
 * 			use both I/O and memory addresses
 * 	11/10/86 Romkey	added IFF_DOES_1822, IFF_DOES_X25standard,
 * 			IFF_DOES_X25basic, IFF_DOES_DTE_DCE in support
 * 			of the Scope interface.
 * 	11/12/86 Romkey	added memory address fields to structures
 * 	08/31/87 jbvb/Romkey	Added IFF_DOES_MSIZE (memory size flag),
 * 			memory size fields to structures.
 * 			Added IFF_DOES_PORT (port value, initially used by
 * 			 3C503 for Xcvr/BNC select, maybe later by SLIP),
 * 			 and fields to structure.
 * 20-Jun-91	paul	add support for init code (make extern data far)
 * 20 jun-91	wls	added back gordons changes (does serial: does ppp)
 */

/* This file declares the "if_info" structure, which gives information
	about network interfaces that is used by ifconfig and cardfinder
	in order to do consistency checking.
   Info stored is things like whether or not it does DMA, interrupts,
	ARP, etc., and what possible base addresses, interrupts, DMA
	channels there are.
*/

struct if_info {
	int	if_kind;	/* the class and type of interface */
	char	*if_name;	/* full name of the interface */
	char	*if_sname;	/* short name */	
	long	if_flags;	/* flags: can do ARP, can change ints, etc. */
	int	if_num_dma;	/* number of possible dma channels */
	int	if_num_ints;	/* number of possible int vectors */
	int	if_num_bases;	/* number of possible base i/o addresses */
	int	*if_dmas;	/* dma channels */
	int	*if_ints;	/* interrupt vectors */
	int	*if_bases;	/* base i/o addresses */
	int	if_num_mems;	/* number of possible base memory addresses */
	int	*if_mems;	/* base memory addresses */
	int	if_num_msize;	/* number of possible memory sizes */
	int	*if_msize;	/* pointer to values for memory sizes */
	int	if_num_port;	/* number of possible port values */
	int	*if_port;	/* pointer to values for "port" */
	};

/* flags */
#define	IFF_CAN_ARP		0x00000001	/* can use ARP */
#define	IFF_CAN_RARP		0x00000002	/* can use RARP */
#define	IFF_CAN_BROADCAST	0x00000004	/* can do broadcast */
#define	IFF_DOES_DMA		0x00000008	/* does use dma */
#define	IFF_DOES_INT		0x00000010	/* does use interrupts */
#define	IFF_DOES_BASE		0x00000020	/* does use base io address */
#define	IFF_DOES_BAUD		0x00000040	/* baud rate field is used */
#define	IFF_FAST_SPEED		0x00000080	/* fast, like an ethernet */
#define	IFF_BACK2BACK		0x00000100	/* receives back2back pkts */
#define	IFF_DOES_MEMORY		0x00000200	/* does use base mem. addr */
#define	IFF_DOES_1822		0x00000400	/* can do 1822 protocol */
#define	IFF_DOES_X25standard	0x00000800	/* can do X.25 standard */
#define	IFF_DOES_X25basic	0x00001000	/* can do X.25 basic */
#define	IFF_DOES_DTE_DCE	0x00002000	/* can choose DTE/DCE */
#define	IFF_DOES_ADDR		0x00004000	/* can chose address */
#define IFF_DOES_MSIZE		0x00008000	/* can set memory size */
#define IFF_DOES_PORT		0x00010000	/* has settable "port" */
#define IFF_DOES_PPP		0x00020000	/* uses the PPP ext struct */
#define IFF_DOES_SERIAL		0x00040000	/* uses a serial line */

/* the if_info library has an array of if_info structures for
  all the network interfaces in the world, and it's called...
*/
struct if_info *find_if(int);

#ifndef INIT
extern struct if_info *if_infos[];
#else
extern struct if_info * far if_infos[];
#endif /* INIT */

/*
 * $Log:   K:\devkit.dos\vcs\include\pctcp\if_info.h_v  $
 * 
 *    Rev 1.9.1.1   08 Apr 1993 17:25:36   arnoff
 * Protected from multiple includes.
 * 
 *    Rev 1.9   03 Feb 1992 23:26:34   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:48:34   arnoff
 *  
 */


#endif /* __IF_INFO_HEADER__ */

