/*
 * $Header:   K:\devkit.dos\vcs\include\ifstat.h_v   1.12.1.0   19 Apr 1993 13:35:22   arnoff  $
 */

#ifndef __IFSTAT_HEADER__
#define __IFSTAT_HEADER__



/*
 * INCLUDE\IFSTAT.H - 2.0 internal net interface statistics structure
 *
 * Copyright (C) 1986-1993 by FTP Software, Inc., all rights reserved.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 29-Aug-89	jbvb	Define lostcrs and heartbeat as transmit errors.
 * 05-Sep-89	jbvb	Add pointers to TCP, IP and ARP tables.
 * 07-May-91	gub	Add multiple sizes of packet buffers
 * 16-Dec-91	gordon	Made et_unknown an unsigned long, arp code was 
 *			 treating it as such
 * 07-Apr-92	kek	Enhanced warning for structure size changes affecting 
 *			 VxD.
 * 09-Sep-92	snyders	Added prototype for net_debug
 */

/*
 * WARNING: If you change the size of this structure, make sure to 
 *	    reflect the change in srcdrv/vxd/vpctcp.inc's LEN_IFSTAT EQUATE!
 *
 *	    Only add to the end of the structure; the VxD uses hardcoded 
 *	    offsets for this structure's far pointers!!
 */

struct ifstat	{
	unsigned long	ints;		/* total interrupts */
	unsigned long	rcv_ints;	/* receive interrupts */
	unsigned long	xmt_ints;	/* transmit interrupts */
	unsigned long	rcvs;		/* received packets */
	unsigned long	xmts;		/* transmitted packets */
	unsigned long	rcv_errs;	/* receiver errors */
	unsigned long	xmt_errs;	/* transmitter errors */
	unsigned long	resets;		/* interface resets */
	unsigned long	rcv_resets;	/* receiver resets */
	unsigned long	xmt_resets;	/* transmitter resets */

	/* receive-type errors
	*/
	unsigned long	runt_errs;	/* packet too short */
	unsigned long	align_errs;	/* bit alignment error */
	unsigned long	crc_errs;	/* cyclic redundancy check error */
	unsigned long	parity_errs;	/* parity error */
	unsigned long	overflow_errs;	/* receiver overlowed */
	unsigned long	toobig_errs;	/* packet too big to buffer */
	unsigned long	nobuf_errs;	/* software out of buffers */
	unsigned long	rcv_tmo;	/* receiver timeout */
	unsigned long	rcve_rsvd[8];	/* for future use */

	/* transmit-type errors
	*/
	unsigned long	collisions;	/* what it says */
	unsigned long	xmt_tmo;	/* transmitter timed out */
	unsigned long	underflow_errs;	/* transmitter underflows */
	unsigned long	lostcrs_errs;	/* transmitter carrier sense */
	unsigned long	heartbeat_errs;	/* transmitter heartbeat */
	unsigned long	xmte_rsvd[6];	/* for future use */

	/* packet buffer stats
	*/
	unsigned	lpb_free;	/* Large buffers */
	unsigned	lpb_max;
	unsigned	lpb_min;

	unsigned	spb_free;	/* Small buffers */
	unsigned	spb_max;
	unsigned	spb_min;
	
	/* arp stats
	*/
	unsigned	does_arp;	/* flag whether we do arp or not */
	unsigned	arp_xmt;
	unsigned	arp_xmt_req;
	unsigned	arp_xmt_rep;
	unsigned	arp_rcv;
	unsigned	arp_rcv_req;
	unsigned	arp_rcv_rep;
	unsigned	arp_not_me;
	unsigned	arp_bad_opcode;
	unsigned	arp_bad_hardware;
	unsigned	arp_bad_protocol;

	unsigned long	et_unknown;	/* unknown ethernet type */

	/* Pointers to kernel data structures for SNMP, etc.
	*/
	char	far 	*tcp_table;	/* Address of "conlist[]" */
	char	far	*route_table;	/* Address of "redent[] " */
	char	far	*arp_table;	/* 0 if driver doesn't use ARP */

	/* reserved for future use
	*/
	unsigned	rsvd[13];
};

#define ARP_CACHE_SIZE 40

#ifndef	MSW3
int net_debug(struct ifstat *);
#endif	/*MSW3*/

/*
 * $Log:   K:\devkit.dos\vcs\include\ifstat.h_v  $ * 
 * 
 *    Rev 1.12.1.0   19 Apr 1993 13:35:22   arnoff
 * Removed extra LF chars, updated copyright date
 *    Rev 1.12.1.0   07 Apr 1993 15:22:50   arnoff
 * Protected for multiple inclusion.

 * 
 *    Rev 1.12   06 Nov 1992 16:16:14   snyders
 * added define for ARP_CACHE_SIZE both the kernel and inet need to know.
 * 
 *    Rev 1.11   13 Oct 1992 09:31:52   snyders
 * ifdef net_debug prototype on MSW3
 * 
 *    Rev 1.10   09 Oct 1992 11:17:14   snyders
 * added prototype for net_debug
 * 
 *    Rev 1.9   07 Apr 1992 21:10:56   arnoff
 *  * 07-Apr-92	kek	Warning for structure size changes affecting VxD.
 * 
 *    Rev 1.8   30 Jan 1992 08:25:44   arnoff
 *  
 */


#endif /* __IFSTAT_HEADER__ */

