/*
 * $Header:   F:/21vcs/include/pctcp/ifconfig.h_v   1.9   03 Feb 1992 23:26:36   arnoff  $
 */

/*
 * INCLUDE\IFCONFIG.H - IF configuration information
 *
 * Copyright (C) 1986,1990,1991,1992 by FTP Software, Inc.  
 *  All rights reserved.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 */

/* EDIT HISTORY:
 * 	10/31/86 Romkey	added c_memory field in support of boards that
 * 			use both memory and i/o ports (like the p1340).
 * 	1/7/87	Romkey	added c_addr field to allow setting of the local
 * 			net address.
 * 	08/31/87 jbvb/Romkey	Added c_msize and c_port storage.
 * 03-Dec-90	gordon	Added the ppp_ifc_ext struct to handle PPP options
 * 20-Jun-91	paul	added get_ifconfig prototype
 * 14-Jan-92	Ben	Protected against multiple inclusion
 */

/* Interface configuration information - this structure is stored in a
	device driver and kept in memory at all times
*/

#ifndef _IFCONFIG_H
#define _IFCONFIG_H INCLUDED

#define	IFC_VERSION	1	/* version number */
#define	IFC_TYPE	2	/* structure type */

struct ethaddr {
	char	ea_bytes[6];
	};

/* this structure is 134 bytes long */
struct ifconfig {
	char		c_dummy[18];	/* 18 bytes of padding */
	char		c_iver;		/* internal version number */
	char		c_type;		/* structure type */
	unsigned	c_driver;	/* interface type */
	unsigned	c_number;	/* number of the interface */

	/* common stuff */
	unsigned	c_intvec;	/* net interface interrupt number */
	unsigned	c_tx_dma;	/* net interface xmit dma channel */
	unsigned	c_rcv_dma;	/* net interface rcv dma channel */
	unsigned	c_base;		/* net interface CSR base address */
	in_name		c_me;		/* skeletal my-internet-address */
	in_name		c_net_mask;	/* net & subnet address mask */
	in_name		c_broadcast;	/* broadcast address */
	unsigned	c_flags;

	/* serial line stuff */
	unsigned	c_baud;		/* serial line speed */

	/* ethernet stuff	*/
	struct	ethaddr	c_ether[3];	/* ip - ether address xlation cache */
	in_name		c_ipname[3];

	/* reserved space */
	int		c_subnet_bits;
	unsigned	c_memory;	/* base memory address */
	char		c_addr[6];	/* local network address */
	int		c_msize;	/* Size of on-board memory */
	int		c_port;		/* "port" value (board dependent) */
	char		c_reserved[26];
	int		c_interface[10];	/* per interface stuff */
	};

#define	FL_DOWN		0x0001		/* interface is "turned off" */
#define	FL_RARP		0x0002		/* choose ip address via RARP */
#define	FL_ARP		0x0004		/* use ARP */
#define	FL_DMA		0x0008		/* use DMA */
#define	FL_NOSETIP	0x0010		/* user can't set IP address */
#define	FL_1822		0x0020		/* select 1822 */
#define	FL_X25standard	0x0040		/* select X.25 standard */
#define	FL_X25basic	0x0080		/* select X.25 basic */
#define	FL_DCE		0x0100		/* be DCE instead of DTE */
#define	FL_ADDR		0x0200		/* local net address is set */

int get_ifconfig(char *device, struct ifconfig *conf);

/* this structure is laid down over the reserved space */
struct ppp_ifc_ext {
	unsigned c_mru;
	unsigned c_mtu;
	unsigned c_auth;
	unslword c_accm;
	unslword c_magic_num;
	unslword c_peer_magic_num;
	unslword c_lqm_period;
	in_name  c_laddr;
	in_name  c_raddr;
	unsbyte  c_flags;
	unsigned c_timeout;
};

/* defines for ppp_ifc_ext.c_flags */
#define PPP_FL_LQM	((unsbyte)0x01)
#define PPP_FL_PFC	((unsbyte)0x02)
#define PPP_FL_ACFC	((unsbyte)0x04)
#define PPP_FL_MC	((unsbyte)0x08)
#define PPP_FL_PASS	((unsbyte)0x10)
#define PPP_FL_OPEN	((unsbyte)0x20)

#endif /* _IFCONFIG_H */

/*
 * $Log:   F:/21vcs/include/pctcp/ifconfig.h_v  $
 * 
 *    Rev 1.9   03 Feb 1992 23:26:36   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:48:38   arnoff
 *  
 */
