/*
 * $Header:   K:\devkit.dos\vcs\include\pctcp\ftp.h_v   1.15.1.1   08 Apr 1993 17:25:02   arnoff  $
 */

#ifndef __FTP_HEADER__
#define __FTP_HEADER__



/*
 * INCLUDE\PCTCP\FTP.H
 *
 * Copyright (C) 1986-1992 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * 
 * EDIT HISTORY:
 * 08-Dec-87	romkey	declare ftp_response() as int declare ftp_cmd()
 * 09-Dec-87	romkey	added missing LINT_ARGS section and missing ftp
 *			library functions removed extra arguments from
 *			ftp_pwd()
 * 24-Mar-88	jbvb	'ftpcon' changed to be same size packed or unpacked.
 * 14-Oct-88    jog     added ftp_pasv() to list, passive to structure
 * 02-Nov-88    jog     added 4th argument to ftp_open() list
 * 28-Dec-88    jog     added data_idx, data_in_buf & cr_last to structure
 * 17-Aug-89	jbvb	Always use function prototypes.
 * 25-Oct-89	jbvb	Packed/unpacked was broken in 10/14/88 edit, fix it.
 * 29-Sep-91    davec   Fix prototype for ftp_type
 * 05-Nov-91	paul	changed ftp_pasv return type to void
 * 11-Feb-92	paul	added parameters to function pointer parameters in
 *			 ftp_dir, ftp_ls, ftp_get, ftp_put prototypes
 *			added parameters to Malloc and Free prototypes
 * 24-Apr-92	towfiq	Added #defines for Windows
 * 01-Jun-92	towfiq	Added variable, prototypes for blocking hooks.
 * 03-Jul-92	towfiq	Added cancel logic to blocking scheme.
 * 22-Jul-92	kek	Change ftp_open() so cancel blocking scheme will work.
 * 23-Jul-92	kek	Add user_supplied field to ftp_con so ftp_abort and 
 *			 ftp_close() can skip free when necessary!
 * 01-Sep-92	kek	Introduce a get_failed field for Windows.
 *			Prototype ftp_abort_get() for Windows and DOS (macro).
 * 09-Sep-92	kek	Prototype ftp_getnetversion().
 */

/* Try to see if we are being compiled for Windows--
   we could just use "WINVER" everywhere, but the 3.00
   WinSDK didn't have this #defined in windows.h.  So
   we check for something which is common to both, just
   as a help--the programmer can always just #define
   _WINDOWS. */
#if (defined(WF_PMODE) || defined(WINVER)) && !defined(_WINDOWS)
#define _WINDOWS
#endif	/* WF_PMODE or WINVER */

#ifdef _WINDOWS

#if !defined(WF_PMODE) && !defined(WINVER)
/* windows.h hasn't been included yet -- we must do it */
#include <windows.h>
#endif	/* not WF_PMODE and not WINVER */

#define _dllfar		_far
#define	_ftpdllapi	_far _pascal

/* windows.h in 3.00 doesn't #define this */
#ifndef CALLBACK
#define CALLBACK	_far _pascal
#endif	/* CALLBACK not defined */

#else	/* not _WINDOWS */

#define _dllfar
#define	_ftpdllapi

#endif	/* not _WINDOWS */

/* control structure for FTP connections
*/
typedef struct ftpcon {
	int		nd;	 /* the connection's network descriptor  */
	int		dnd;	 /* data connection's network descriptor */
	char		passive; /* True if server is passsive		 */
	char		mode;	/* 'S'tream */
	char		type;	/* 'A'scii, 'I'mage, 'L'ocal byte size */
	char            cr_last;        /* last byte of prev block = CR */
	int		byte_size;	/* for `local byte size n' */
	unsigned long	bytes_moved;	/* bytes moved in last transfer */
	unsigned long	num_seconds;	/* number of seconds to transfer */
	char	_dllfar	*msgbuf;	/* buffer for server messages */
	int		msgbuflen;	/* length of the buffer */
	char	_dllfar	*data;		/* data buffer */
	unsigned        data_idx;       /* index into data buffer    */
	unsigned        data_in_buf;    /* # of bytes of data in buf */
	unsigned	datalen;	/* length of data buffer     */
	int		debug;		/* TRUE if debugging is enabled */
#ifdef _WINDOWS
	BOOL		(CALLBACK _dllfar *blocking_hook)(void);
					/* points to fake blocking function */
	BOOL		call_status;	/* in a blocking call right now? */
	unsigned char	user_supplied:1;/* user allocated this block */
	unsigned char	get_failed:1;	/* user called ftp_get_abort() */
	unsigned int	reserved:14;	/* reserved for alignment */
#endif	/* _WINDOWS */
	}	ftpcon;

/* return codes from ftp_user(), ftp_pass(), ftp_acct()
*/
#define	FTP_ERROR		-1		/* there was an error */
#define	FTP_GOAHEAD		0		/* no error, all done */
#define	FTP_NEED_PASSWORD	1		/* needs a password */
#define	FTP_NEED_ACCOUNT	2		/* needs an account name */

/* type names for FTP
*/
#define	FTP_ASCII_TYPE	'A'		/* network ASCII */
#define	FTP_IMAGE_TYPE	'I'		/* no translation */
#define	FTP_LOCAL_TYPE	'L'		/* local byte size mode */

#ifdef _WINDOWS
/* These defines are used for the call_status field
   in the ftpcon, to keep track of what state the
   DLL is in. */
#define CLEAR		0
#define BLOCKING	1
#define ABORT		2
#endif	/* _WINDOWS */

/* these functions are called by FTP to do memory management - they normally
 * just call malloc() and free(), but are here so that these functions can be
 * replaced by ones supplied by the application.
 */
#ifdef _WINDOWS
#define Malloc malloc
#define Free free
#else	/* not _WINDOWS */
char *Malloc(unsigned);
void Free(char *);
#endif	/* not _WINDOWS */

/* some macros for FTP
*/
#define	ftp_cur_type(f)	(f)->type
#define	ftp_bytesize(f)	(f)->byte_size
#define	ftp_bytes(f)	(f)->bytes_moved
#define	ftp_time(f)	(f)->num_seconds
#define	ftp_msgbuf(f)	(f)->msgbuf

#ifdef _WINDOWS

/* This macro is used to check if a blocking routine
   is presently in progress. */
#define	ftp_is_blocking(f)		((f)->call_status != CLEAR)

/* This macro is used to cancel a blocking routine
   presently in progress, usually either to abort a
   file transfer or when shutting down. */
#define ftp_cancel_blocking_call(f)	(f)->call_status = ABORT

/* This definition is used to pass a NULL ftpcon pointer as the first 
 * parameter to ftp_open(), so that ftp_open_con() will allocate an
 * ftpcon structure for the caller.
 */
#define NULL_FTPCON	((ftpcon _dllfar *)0)

#endif	/* _WINDOWS */

/* Handy typedef used to declare function which
 * handle data delivered asynchronously in NLST, LIST, STOR, RETR
 */
#ifdef _WINDOWS
typedef int (CALLBACK *data_handler)
			  (ftpcon _dllfar *, char _dllfar *, unsigned);
#else	/* not _WINDOWS */
typedef int (* data_handler)(ftpcon *, char *, unsigned);
#endif	/* not _WINDOWS */

#ifndef _WINDOWS
/* Provide a pretty way to abort an ftp_get() from DOS */
#define ftp_abort_get() (get_failed = TRUE)
#else
#define ftp_abort_get(f) (f->get_failed = TRUE)
#endif

/* declarations of FTP client functions
*/
void	_ftpdllapi ftp_abort(ftpcon _dllfar *);
int	_ftpdllapi ftp_acct(ftpcon _dllfar *, char _dllfar *);
void	_ftpdllapi ftp_close(ftpcon _dllfar *);
int	_ftpdllapi ftp_cmd(ftpcon _dllfar *, char _dllfar *, char _dllfar *);
int	_ftpdllapi ftp_cwd(ftpcon _dllfar *, char _dllfar *);
int	_ftpdllapi ftp_debug(ftpcon _dllfar *, int);
int	_ftpdllapi ftp_delete(ftpcon _dllfar *, char _dllfar *);
int	_ftpdllapi ftp_dir(ftpcon _dllfar *, char _dllfar *, data_handler);
int	_ftpdllapi ftp_get(ftpcon _dllfar *, char _dllfar *, data_handler);
int	_ftpdllapi ftp_ls(ftpcon _dllfar *,  char _dllfar *, data_handler);
int	_ftpdllapi ftp_mkdir(ftpcon _dllfar *, char _dllfar *);
#ifdef _WINDOWS
ftpcon _dllfar * _ftpdllapi ftp_open_con(ftpcon _dllfar *, in_name, unsigned, unsigned, unsigned);
int	_ftpdllapi ftp_getnetversion(void);
#endif
ftpcon _dllfar * _ftpdllapi ftp_open(in_name, unsigned, unsigned, unsigned);
int	_ftpdllapi ftp_parent(ftpcon _dllfar *);
int	_ftpdllapi ftp_pass(ftpcon _dllfar *, char _dllfar *);
void	_ftpdllapi ftp_pasv(ftpcon _dllfar *);
int	_ftpdllapi ftp_put(ftpcon _dllfar *, char _dllfar *, int, data_handler);
int	_ftpdllapi ftp_pwd(ftpcon _dllfar *);
int	_ftpdllapi ftp_quit(ftpcon _dllfar *);
int	_ftpdllapi ftp_quote(ftpcon _dllfar *, char _dllfar *);
int	_ftpdllapi ftp_rename(ftpcon _dllfar *, char _dllfar *, char _dllfar *);
int	_ftpdllapi ftp_response(ftpcon _dllfar *);
int	_ftpdllapi ftp_rmdir(ftpcon _dllfar *, char _dllfar *);
#ifdef _WINDOWS
int	_ftpdllapi ftp_set_blocking_hook(ftpcon _dllfar *,
					 BOOL (CALLBACK _dllfar *)(void));
#endif	/* _WINDOWS */
int	_ftpdllapi ftp_stat(ftpcon _dllfar *, char _dllfar *);
char	_ftpdllapi ftp_type(ftpcon _dllfar *, char, int);
#ifdef _WINDOWS
int	_ftpdllapi ftp_unhook_blocking_hook(ftpcon _dllfar *);
#endif	/* _WINDOWS */
int	_ftpdllapi ftp_user(ftpcon _dllfar *, char _dllfar *);

/*
 * $Log:   K:\devkit.dos\vcs\include\pctcp\ftp.h_v  $
 * 
 *    Rev 1.15.1.1   08 Apr 1993 17:25:02   arnoff
 * Protected from multiple includes.
 * 
 *    Rev 1.15   07 Oct 1992 15:20:40   karen
 * kek Fix prototype of ftp_abort_get() for DOS.
 * 
 *    Rev 1.14   25 Sep 1992 12:34:32   natalia
 * kek Introduce Windows get_failed hook, ftp_abort_get(), ftp_getnetversion().
 * 
 *    Rev 1.13   20 Aug 1992 16:32:50   arnoff
 *  kek	Finish work on cancel logic to blocking scheme.
 * 	Use a global descriptor so WinApp can peek through it!
 * 	Commented out PNetError calls which I introduced, and
 * 	 MessageBoxes which report net_taskDestroy failure.
 * 
 *    Rev 1.12   05 Jun 1992 08:08:40   arnoff
 * towfiq	Added variable, prototypes for blocking hooks.
 * 
 *    Rev 1.11   01 May 1992 18:17:04   arnoff
 * 24-Apr-92	towfiq	Added #defines for Windows
 * 
 *    Rev 1.10   12 Apr 1992 21:20:20   arnoff
 * Added parameters to function pointer parameters in
 *   ftp_dir, ftp_ls, ftp_get, ftp_put prototypes.
 * Added parameters to Malloc and Free prototypes.
 * 
 *    Rev 1.9   03 Feb 1992 23:26:30   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:48:32   arnoff
 *  
 */


#endif /* __FTP_HEADER__ */

