/*
 * $Header:   J:/devkit.dos/vcs/include/fcntl.h_v   1.7.1.3   22 Apr 1993 14:12:06   rcq  $
 */

/*
 * INCLUDE\FCNTL.H - Flag values used by open() and fcntl()
 *
 * Copyright (C) 1986,1988 by FTP Software, Inc., all rights reserved.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 *	EDIT HISTORY:
 * 9/2/87	romkey	Added O_BINARY and O_TEXT for Microsoft C.  Made flag
 *			values consistent with MSC & MS-DOS rather than 4BSD.
 * 24-Sep-88	jbvb	O_EXCL was mis-spelled.
 * 13-SEP-89	stev	add FNBLOCK (POSIX name for FNDELAY
 * 14-Apr-93	rcq	added alternate manifest values for Borland (TURBOC)
 *			 and a few others that were in MSC but not Borland
 */


#ifndef _FCNTL_H
#define _FCNTL_H


#ifdef __TURBOC__
/* open modes for Borland C
*/
#define	O_RDONLY	0x0001
#define	O_WRONLY	0x0002
#define	O_RDWR		0x0004
#define O_APPEND	0x0800
#define	O_CREAT		FCREAT	/* create and open file			*/
#define	O_TRUNC		FTRUNC	/* open with truncation			*/
#define	O_EXCL		FEXCL	/* exclusive open			*/

/* MSDOS special bits 
*/
#define O_CHANGED	0x1000	/* user may read these bits, but	*/
#define	O_DEVICE	0x2000	/*  only RTL\io functions may touch.	*/
#define	O_TEXT		0x4000	/* file mode is text (CR-LF translated)	*/
#define	O_BINARY	0x8000	/* file mode is binary (untranslated) 	*/

/* The "open flags" defined above are not needed after open, hence they
   are re-used for other purposes when the file is running. 
*/
#define _O_RUNFLAGS	0x0700
#define _O_WRITABLE	0x0100	/* file is not read-only		*/
#define _O_EOF		0x0200	/* set when text file hits ^Z		*/

/* DOS 3.x option
*/
#define O_NOINHERIT	0x80
#define O_DENYALL	0x10
#define O_DENYWRITE	0x20
#define O_DENYREAD	0x30
#define O_DENYNONE	0x40

#else

/* open modes for Microsoft C 
*/
#define	_O_RDONLY	0x0000
#define	_O_WRONLY	0x0001
#define	_O_RDWR		0x0002
#define _O_APPEND	FAPPEND
#define	_O_NDELAY	FNDELAY
#define	_O_CREAT	FCREAT	/* create and open file			*/
#define	_O_TRUNC	FTRUNC	/* open with truncation			*/
#define	_O_EXCL		FEXCL	/* exclusive open			*/

/* MSDOS special bits (for both MSC & BCC) 
*/
#define	_O_TEXT		0x4000	/* file mode is text (CR-LF translated)	*/
#define	_O_BINARY	0x8000	/* file mode is binary (untranslated) 	*/

/* DOS 3.x option
*/
#define _O_NOINHERIT	0x0080	/* Open Handle inherit bit		*/

/* Non-ANSI names for compatibility
*/
#define	O_RDONLY	0x0000
#define	O_WRONLY	0x0001
#define	O_RDWR		0x0002
#define O_APPEND	FAPPEND
#define	O_NDELAY	FNDELAY
#define	O_CREAT		FCREAT	/* create and open file			*/
#define	O_TRUNC		FTRUNC	/* open with truncation			*/
#define	O_EXCL		FEXCL	/* exclusive open			*/
#define	O_TEXT		0x4000	/* file mode is text (CR-LF translated)	*/
#define	O_BINARY	0x8000	/* file mode is binary (untranslated) 	*/
#define O_NOINHERIT	0x0080	/* Open Handle inherit bit		*/

#endif


/* fcntl requests
*/
#define F_DUPFD		0	/* duplicate file descriptor 		*/
#define F_GETFD		1	/* get fd flags 			*/
#define F_SETFD		2	/* set fd flags 			*/
#define F_GETFL		3	/* get file flags 			*/
#define F_SETFL		4	/* set file flags 			*/
#define F_GETOWN	5	/* get owner 				*/
#define F_SETOWN	6	/* set owner 				*/
#define	F_GETLK		7	/* get file lock 			*/
#define	F_SETLK		8	/* set file lock 			*/
#define	F_SETLKW	9	/* set file lock and wait 		*/

/* file flags 
*/
#define	FOPEN		-1
#define	FREAD		0x0001	/* descriptor is readable 		*/
#define	FWRITE		0x0002	/* descriptor is writeable 		*/
#define	FNDELAY		0x0004	/* non-blocking 			*/
#define FNBLOCK		FNDELAY	/* POSIX gratutious changes		*/
#define	FAPPEND		0x0008	/* append on each write 		*/
#define	FASYNC		0x0080	/* signal when data ready 		*/

#define	FCREAT		0x0100	/* create if not present 		*/
#define	FTRUNC		0x0200	/* truncate to zero length 		*/
#define	FEXCL		0x0400	/* error if already present 		*/

#endif /* _FCNTL_H */

/*
 * $Log:   J:/devkit.dos/vcs/include/fcntl.h_v  $
 * 
 *    Rev 1.7.1.3   22 Apr 1993 14:12:06   rcq
 * changed TURBOC manifest to the correct __TURBOC__
 * 
 *    Rev 1.7.1.2   15 Apr 1993 14:21:18   rcq
 * added missing comment delimiter
 * 
 *    Rev 1.7.1.1   15 Apr 1993 11:55:56   rcq
 * got rid of #ifndef __STDC__ limitation for defining non-ANSI manifests
 * (a too-severe restriction imposed by the MSC 7 fcntl.h header file)
 * 
 *    Rev 1.7.1.0   15 Apr 1993 11:15:22   rcq
 * updated with both MSC & BCC specific manifests
 * 
 *    Rev 1.8   30 Jan 1992 08:24:26   arnoff
 *  
 */
