/*
 * $Header:   K:/21vcs/include/errno.h_v   1.9   26 Feb 1992 15:14:08   arnoff  $
 */

/*
 * INCLUDE\ERRNO.H - Berkeley compatible definitions for our perror(), etc.
 *
 * Copyright (C) 1986-1992 by FTP Software, Inc.  All rights reserved.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Error return values. The global variable 'errno' will be set to one
 * of these values when a Microsoft C library routine or a socket
 * emulation routine returns in error.
 * 
 * EDIT HISTORY:
 * 9/3/87	romkey	changed EACCESS to EACCES.
 * 10/28/87	jbvb	Added EHOSTDOWN & EHOSTUNREACH, moved ENOTEMPTY
 * 06-Jun-88	jbvb	Make definition of 'errno' compatible with MSC 5.1.
 * 18-Jun-91	gub	Protected against multiple inclusion
 * 23-Jun-91	Ben	Added errno from msc 6.0
 * 13-Nov-91	Gakio	Added bsd_errno to pass neterrno to the application
 *			since wsocket.dll is not sharing both msc's errno and
 *			neterrno with application.
 * 10-Feb-92	paul	include stdlib.h for correct declaration of errno
 */

#ifndef _ERRNO_H
#define _ERRNO_H INCLUDED

#define	EPERM		1	/* Not owner			*/
#define	ENOENT		2	/* No such file or directory	*/
#define	ESRCH		3	/* No such process		*/
#define	EINTR		4	/* Interrupted system call	*/
#define	EIO		5	/* I/O error			*/
#define	ENXIO		6	/* No such device or address	*/
#define	E2BIG		7	/* Arg list too long		*/
#define	ENOEXEC		8	/* Exec format error		*/
#define	EBADF		9	/* Bad file number		*/
#define	ECHILD		10	/* No children			*/
#define	EAGAIN		11	/* No more processes		*/
#define	ENOMEM		12	/* Not enough core		*/
#define	EACCES		13	/* Permission denied		*/
#define	EFAULT		14	/* Bad address			*/
#define	ENOTBLK		15	/* Block device required	*/
#define	EBUSY		16	/* Mount device busy		*/
#define	EEXIST		17	/* File exists			*/
#define	EXDEV		18	/* Cross-device link		*/
#define	ENODEV		19	/* No such device		*/
#define	ENOTDIR		20	/* Not a directory		*/
#define	EISDIR		21	/* EISDIR			*/
#define	EINVAL		22	/* Invalid argument		*/
#define	ENFILE		23	/* File table overflow		*/
#define	EMFILE		24	/* Too many open files		*/
#define	ENOTTY		25	/* Not a typewriter		*/
#define	ETXTBSY		26	/* Text file busy		*/
#define	EFBIG		27	/* File too large		*/
#define	ENOSPC		28	/* No space left on device	*/
#define	ESPIPE		29	/* Illegal seek			*/
#define	EROFS		30	/* Read-only file system	*/
#define	EMLINK		31	/* Too many links		*/
#define	EPIPE		32	/* Broken pipe			*/
#define	EDOM		33	/* Math argument		*/
#define	ERANGE		34	/* Result too large		*/
#define	EWOULDBLOCK	35	/* Operation would block	*/
#define	EINPROGRESS	36	/* Operation now in progress	*/
#define	EALREADY	37	/* Operation already in progress */
#define	ENOTSOCK	38	/* Socket operation on non-socket */
#define	EDESTADDRREQ	39	/* Destination address required	*/
#define	EMSGSIZE	40	/* Message too long		*/
#define	EPROTOTYPE	41	/* Protocol wrong type for socket */
#define	ENOPROTOOPT	42	/* Bad protocol option		*/
#define	EPROTONOSUPPORT	43	/* Protocol not supported	*/
#define	ESOCKTNOSUPPORT	44	/* Socket type not supported	*/
#define	EOPNOTSUPP	45	/* Operation not supported on socket */
#define	EPFNOSUPPORT	46	/* Protocol family not supported */
#define	EAFNOSUPPORT	47	/* Addr family not supported by prot family */
#define	EADDRINUSE	48	/* Address already in use	*/
#define	EADDRNOTAVAIL	49	/* Can't assign requested address */
#define	ENETDOWN	50	/* Network is down		*/
#define	ENETUNREACH	51	/* Network is unreachable	*/
#define	ENETRESET	52	/* Network dropped connection or reset */
#define	ECONNABORTED	53	/* Software caused connection abort */
#define	ECONNRESET	54	/* Connection reset by peer	*/
#define	ENOBUFS		55	/* No buffer space available	*/
#define	EISCONN		56	/* Socket is already connected	*/
#define	ENOTCONN	57	/* Socket is not connected	*/
#define	ESHUTDOWN	58	/* Can't send after socket shutdown */
				/* UNUSED			*/
#define	ETIMEDOUT	60	/* Connection timed out		*/
#define	ECONNREFUSED	61	/* Connection refused		*/
#define	ELOOP		62	/* Too many levels of symbolic links */
#define	ENAMETOOLONG	63	/* File name too long		*/
#define EHOSTDOWN	64	/* Host is down			*/
#define EHOSTUNREACH	65	/* Host is unreachable		*/
#define	ENOTEMPTY	66	/* Directory not empty		*/

/* Get the correct declartion of errno, no matter which compiler we're using:
 * MSC 5.1, MSC 6.0, Turbo C++, etc.
 */
#include <stdlib.h>

/* extra defines from msc 6.0 */
#define EZERO		0
#define EUCLEAN 	35
#define EDEADLOCK	36


/* create a new bsd_errno to handle network errors 
 *	distinctly from msc errors.
 */
#define bsd_errno *_bsd_errno()

#endif /* _ERRNO_H */


/*
 * $Log:   K:/21vcs/include/errno.h_v  $
 * 
 *    Rev 1.9   26 Feb 1992 15:14:08   arnoff
 * Include stdlib.h for correct declaration of errno.   Paul
 * 
 *    Rev 1.8   30 Jan 1992 08:23:54   arnoff
 *  
 */
