; /*
;
; include/defaults.h 
;
; Copyright (C) 1991-1993 by FTP Software, Inc.  All rights reserved.
; 
; This software is furnished under a license and may be used and copied
; only in accordance with the terms of such license and with the
; inclusion of the above copyright notice. This software or any other
; copies thereof may not be provided or otherwise made available to any
; other person. No title to and ownership of the software is hereby
; transferred.
; 
; The information in this software is subject to change without notice
; and should not be construed as a commitment by FTP Software, Inc.
;
;
; EDIT HISTORY:
;  27-Nov-91	Ben	Created this file.
;  02-Dec-91	paul	moved beta version string to FTP_RELEASE_STRING
;  01-Jan-92	Ben	Updated year to '92
;  03-Jul-92	paul	split release timestamp from relase name
;			 in FTP_RELEASE_STRING
;  12-Aug-92	paul	added numeric version number
;			 (in addition to version string)
;  25-Sep-92    MPR     added MAJOR and MINOR defines for win stuff. did it
;                        here to avoid changing a bunch of code elsewhere
;  09-Oct-92	paul	added MAJOR and MINOR in asm as well
;  25-Jan-93	paul	For FCS: release name and timestamp are empty strings.
;  14-Apr-93	paul	belatedly upped to 2.21
; */


; /* 
;   This file contains common defaults for various programs and libraries.
;
;   The file is set up so that is is usable by both C compilers and ASM 
; assemblers.  If you add any defaults to this file, please be sure to 
; continue the conventions for making it readable by both compiles.
; 
;   Also any changes made MUST be duplicated for both C and ASM.
;
;   Here is a quick explanation of what this does.  Everything preceeded
; by a ';' and everything between the first character after the word
; "COMMENT" and the next time it occurs (in this example the '&')
; are considered comments by the ASM compiler.  Since the '#' of a 
; pre-processor command must be the first character on a line it 
; must inside a "COMMENT" comment.  If want to add a new default and
; you need to use '&' in your string, you can choose a different
; comment character. For the C compiler to ignore the ASM constants
; they must be inside a C comment.  "EQU" is the ASM equivalent of
; #define (with a slightly different syntax).
;
; */


; /* Version number for all PC/TCP programs */

; /* 
COMMENT &
*/
#define PCTCP_MAJOR	2
#define PCTCP_MINOR	2
#define PCTCP_PATCH	1
#define VERSION(maj, min, pat) ((maj)*256 + (min)*10 + (pat))
#define PCTCP_VERSION	VERSION(PCTCP_MAJOR, PCTCP_MINOR, PCTCP_PATCH)
#define MAJOR		PCTCP_MAJOR
#define MINOR		PCTCP_MINOR
/* &
PCTCP_MAJOR	equ	2
PCTCP_MINOR	equ	2
PCTCP_PATCH	equ	1
PCTCP_VERSION	equ	PCTCP_MAJOR*256 + PCTCP_MINOR*10 + PCTCP_PATCH
MAJOR		equ	PCTCP_MAJOR
MINOR		equ	PCTCP_MINOR
; */


; /* pr_notice()  Constants */

; /* 
COMMENT &
*/
#define FTP_NOTICE_STRING	"FTP Software PC/TCP"
/* &
FTP_NOTICE_STRING	EQU	'FTP Software PC/TCP'
; */


; /* 
COMMENT &
;
; NOTE: This must be kept in sync with PCTCP_VERSION above.
;
*/
#define FTP_VERSION_STRING	"Version 2.21"
/* &
FTP_VERSION_STRING	EQU	'Version 2.21'
; */


; /* 
COMMENT &
*/
#define FTP_RELEASE_NAME	" "
#define FTP_RELEASE_TIME	"04/14/93 16:31"
#define FTP_RELEASE_STRING	FTP_RELEASE_NAME FTP_RELEASE_TIME
/* &
FTP_RELEASE_NAME	EQU	' '
FTP_RELEASE_TIME	EQU	'04/14/93 16:31'
FTP_RELEASE_STRING	EQU	FTP_RELEASE_NAME,FTP_RELEASE_TIME
; */


; /* 
COMMENT &
*/
#define FTP_COPYRIGHT_STRING	"Copyright (c) 1986-1993 by FTP Software, Inc.  All rights reserved."
/* &
FTP_COPYRIGHT_STRING	EQU	'Copyright (c) 1986-1993 by FTP Software, Inc.  All rights reserved.'
; */


; /* Initialization file name */

; /* 
COMMENT &
*/
#define FTP_INIT_FILE		"pctcp.ini"
/* &
FTP_INIT_FILE	EQU		'pctcp.ini'
; */


; /* Time Zone and Offset Constants */

; /* 
COMMENT &
*/
#define FTP_TIME_ZONE		"EST"
/* &
FTP_TIME_ZONE	EQU		'EST'
; */


; /* 
COMMENT &
*/
#define FTP_TIME_OFFSET		300
/* &
FTP_TIME_OFFSET	EQU		300
; */

