/*
 * $Header:   K:/21vcs/include/arpa/inet.h_v   1.11   28 Apr 1992 16:29:16   arnoff  $
 */

/* Definitions of functions in the internet library
 *
 *	/usr/include/arpa/inet.h
 *
 * (c) Copyright 1987 FTP Software, Inc.
 */

/*
 * edit history:
 * 27OCT89	stev	took the bold step, the world is wrong, there is 
 *			no such thing as struct inet_addr, it is really
 *			in_addr. fixed inet_ntoa().
 * 22MAR90	stev	missed a 4.3 change to inet_addr().
 *
 * 16JAN92	Ben	Prevent multiple inclusion.
 * 27FEB92	Gakio	added DLLFAR for Windows.	
 * 28-Apr-92	jbvb	Implement inet_network() as a macro.
 */

#ifndef _ARPA_INET_H
#define _ARPA_INET_H INCLUDED

#include <pctcp/types.h>		/* Type definitions for PCTCP.H */
#include <pctcp/pctcp.h>		/* Definition of nm_prs_addr() */

#ifndef MSW3
#define DLLFAR
#endif /* MSW3 */

unsigned long	DLLFAR inet_addr(char DLLFAR *);	/* net byte order */
struct in_addr	DLLFAR inet_makeaddr(int, int);
long		DLLFAR inet_lnaof(struct in_addr);
long		DLLFAR inet_netof(struct in_addr);
#ifdef inet_ntoa
#undef inet_ntoa
#endif
char DLLFAR * DLLFAR inet_ntoa(struct in_addr);

/* inet_network() doesn't mask; only returns local byte order
*/
#define inet_network(cp)	ntohl(nm_prs_addr(cp))

#endif /* _ARPA_INET_H */

/*
 * $Log:   K:/21vcs/include/arpa/inet.h_v  $
 * 
 *    Rev 1.11   28 Apr 1992 16:29:16   arnoff
 * jbvb	Implement inet_network() as a macro.
 * 
 *    Rev 1.10   27 Feb 1992 15:49:46   arnoff
 * add DLLFAR for Windows.    Gakio
 * 
 *    Rev 1.9   03 Feb 1992 23:27:46   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:49:50   arnoff
 *  
 */
