# BUILTINS.QQQ
#
# 08-Apr-92	Ben	Added -DWINVER=0x0300 for windows (tells Win 3.1
#			 SDK to compile for 3.0)
# 3 June 92	davec	change SMART_CARD to SMRTCRD to shorten compile
#			command lines
# 4 June 92	davec	change FAR_PKT_BUFS to FR_PKT_BFS to shorten compile
#			command lines
# 08-Jun-92	gub	Add .nop, .fop and .iop rules for protected objects
# 24-Jun-92	Ben	Added ':' before CL to shrink PolyMake.
# 24-Jun-92	davec	added .sio and .sip rules for smart card
#			protected objects
# 22-Jul-92	rcq	Added new .asm.wo and wo.dll inference rules, added
#			 missing .lib.ho (deleted unneeded .c.who & .c.wco)
#			 converted curly braces to parens
# 06-Jan-93	Ben	Changed -CO to /CO for L_DEBUG (link doesn't accept '-'
#			(and got rid of unneeded .pas and .bas rules).
#


CFLAGS = -c -DMSC -Oeclgsz

#GETOPTS = -q -w
# 01/21/92 Arnoff	*Asking* PVCS to delete writable files is insane...
#			.... I'm switching to -qn.
#
GETOPTS = -qn -w
LIBOPTS = mo t m2 o 0 r y d y
AFLAGS = -ml

OS = DOS
CC = cl
LD = link

%if "$(MODEL)" == "DEBUG"
# For debugging -- this includes symbol information
C_DEBUG = -Zi -Zd
L_DEBUG = /CO
%endif

%if %defined(USER_CFLAGS) 
	UFLAGS += $(USER_CFLAGS)
%endif

# NOTE: Because of the order of the following rules,
#		 PolyMake will first look for a .C file with
#		 the same root as the object file.  If no .C
#		 file exists, If it doesn't exist, PolyMake will
#		 look for a .ASM file.


# This rule tells how to make a .EXE file from a .OBJ file
# using the Microsoft Linker with .obj files.
#

.obj.exe :
	link $(LFLAGS) $(L_DEBUG) <@<
$[s,"+ \n",$**]
$*;
<

.so.exe :
	link $(LFLAGS) $(L_DEBUG) <@<
$[s,"+ \n",$**]
$*;
<

.mo.exe :
	link $(LFLAGS) $(L_DEBUG) <@<
$[s,"+ \n",$**]
$*;
<

.co.exe :
	link $(LFLAGS) $(L_DEBUG) <@<
$[s,"+ \n",$**]
$*;
<

.lo.exe :
	link $(LFLAGS) $(L_DEBUG) <@<
$[s,"+ \n",$**]
$*;
<

#
# This rule creates a DLL from .OBJ file(s)
#

.wo.dll :
	link $(LFLAGS) $(L_DEBUG) <@<
$[s,"+ \n",$**]
$*;
<

# This rule tells how to make a .LIB file from a .OBJ file
# using the POLYTRON PolyLibrarian with .obj files.
#

.obj.lib :
	lib <@<
$(LIBOPTS)
!a $? to $@ m n
<

.so.lib :
	lib <@<
$(LIBOPTS)
!a $? to $@ m n
<

.mo.lib :
	lib <@<
$(LIBOPTS)
!a $? to $@ m n
<

.co.lib :
	lib <@<
$(LIBOPTS)
!a $? to $@ m n
<

.lo.lib :
	lib <@<
$(LIBOPTS)
!a $? to $@ m n
<

.ho.lib :
	lib <@<
$(LIBOPTS)
!a $? to $@ m n
<


# This rule says a .OBJ file should be created by
# using Microsoft C 5.0 (or higher) compiler on a
# .C file.
#

.c.obj :
	cl $(UFLAGS) $(CFLAGS) $(C_DEBUG) -c -Fo$@ $<

.c.so :
	cl $(UFLAGS) -AS $(CFLAGS) $(C_DEBUG) -c -Fo$@ $<

.c.mo :
	cl $(UFLAGS) -AM $(CFLAGS) $(C_DEBUG) -c -Fo$@ $<

.c.co :
	cl $(UFLAGS) -AC $(CFLAGS) $(C_DEBUG) -c -Fo$@ $<

.c.lo :
	cl $(UFLAGS) -AL $(CFLAGS) $(C_DEBUG) -c -Fo$@ $<

.c.ho :
	cl $(UFLAGS) -AH $(CFLAGS) $(C_DEBUG) -c -Fo$@ $<

.c.wo :
	cl $(UFLAGS)     $(WCFLAGS) $(C_DEBUG) -DWINVER=0x0300 -c -Fo$@ $<

.c.wso :
	cl $(UFLAGS) -AS $(WCFLAGS) $(C_DEBUG) -DWINVER=0x0300 -c -Fo$@ $<

.c.wmo :
	cl $(UFLAGS) -AM $(WCFLAGS) $(C_DEBUG) -DWINVER=0x0300 -c -Fo$@ $<

.c.wlo :
	cl $(UFLAGS) -AL $(WCFLAGS) $(C_DEBUG) -DWINVER=0x0300 -c -Fo$@ $<


# Rules for the 2.1 kernel
# .no is the same as .so
# .nop is .no with -DARP_PROT
# .fo is for code running on a smart card

.c.no :
	cl $(UFLAGS) -AS $(CFLAGS) $(C_DEBUG) -c -Fo$@ $<

.c.nop:
	cl $(UFLAGS) -AS $(CFLAGS) -DARP_PROT $(C_DEBUG) -c -Fo$@ $<

.c.fo :
	cl $(UFLAGS) -AS -DFR_PKT_BFS -DSMRTCRD $(CFLAGS) $(C_DEBUG) -c -Fo$@ $<

.c.fop :
	cl $(UFLAGS) -AS -DFR_PKT_BFS -DSMRTCRD -DARP_PROT $(CFLAGS) $(C_DEBUG) -c -Fo$@ $<

.c.lno :
	cl $(UFLAGS) -AL $(CFLAGS) -c -Fo$@ $<

.c.lfo :
	cl $(UFLAGS) -AL -DFR_PKT_BFS -DSMRTCRD $(CFLAGS) $(C_DEBUG) -c -Fo$@ $<

# rules for init code modules for 2.1
.c.io :
	cl $(UFLAGS) -DINIT $(CFLAGS) $(C_DEBUG) -c -Fo$@ $<

.c.iop:
	cl $(UFLAGS) $(CFLAGS) $(CDEBUG) -DARP_PROT -DINIT -c -Fo$@ $<

.asm.io :
	masm -DINIT $(AFLAGS) $<,$@;


#
# Rules for smart cards.
#

.c.sio :
	cl ${UFLAGS} -DINIT -DSMRTCRD ${CFLAGS} ${C_DEBUG} -c -Fo$@ $<

.c.sip:
	cl ${UFLAGS} ${CFLAGS} ${CDEBUG} -DARP_PROT -DINIT -DSMRTCRD -c -Fo$@ $<

.asm.sio :
	masm -DINIT -DSMRTCRD ${AFLAGS} $<,$@;

.asm.sip :
	masm -DINIT -DSMRTCRD ${AFLAGS} $<,$@;


# A rule for creating model-specific object files
#.c.?o :
#	cl $(UFLAGS) -A$[c,$[e,$@],1,2] $(CFLAGS) -Fo$@ $<

# This rule says a .OBJ file should be created by
# using the Microsoft Macro Assembler on a .ASM file.
#

.asm.obj :
	masm $(AFLAGS) $<,$@;


## macro assembler rules - defines LDATA for Far Data models, LCODE for Far
## Code models.

.asm.wo:
	masm $(AFLAGS) $<,$@;

.asm.so:
	masm $(AFLAGS) $<,$@;

.asm.mo:
	masm $(AFLAGS) $<,$@ -DLCODE;

.asm.co:
	masm $(AFLAGS) $<,$@ -DLDATA;

.asm.lo:
	masm $(AFLAGS) $<,$@ -DLCODE -DLDATA;

.asm.ho:
	masm $(AFLAGS) $<,$@ -DLCODE -DLDATA;

#

.asm.no:
	masm $(AFLAGS) $<,$@;

.asm.fo:
	masm -DFR_PKT_BFS -DSMRTCRD $(AFLAGS) $<,$@;

.asm.lno:
	masm -DLCODE -DLDATA $(AFLAGS) $<,$@;

.asm.lfo:
	masm -DLCODE -DLDATA -DFR_PKT_BFS -DSMRTCRD $(AFLAGS) $<,$@;


# This rule tells how to make a .COM file from a .EXE file
#
.exe.com :
	exe2bin $< $@

# This rule tells how to make a .C file from a .C_V file
# using POLYTRON PVCS with .c_v files.
#
.c_v.c :
	=get $(GETOPTS) $(REV) $<($@)

# This rule tells how to make a .H file from a .H_V file
# using POLYTRON PVCS with .h_v files.
#
.h_v.h :
	=get $(GETOPTS) $(REV) $<($@)

# This rule tells how to make a .INC file from a .INV file
# using POLYTRON PVCS with .inv files.
#
.inv.inc :
	=get $(GETOPTS) $(REV) $<($@)

# Make generate code w/o stack probes for use in Windows
CGENDEFS=-Gsw -DMSW3

# The next line for debugging in CodeView (or CodeView/Windows)
#CDBGDEFS=-Od -Zi -Zl -Zp
#LDBGDEFS=-CO
# --or-- the next lines for general release
CDBGDEFS=-Os -Zp
LDBGDEFS=

.c.asm:
	cl $(UFLAGS) -c -Fa $(CFLAGS) $<

#####################################################################
#
# Added the following for cleanup. 
#
#####################################################################

maxclean: maxsweep
	del *.?o
	del *.?op
	del *.w?o
	del *.obj
	del *.exe

maxsweep:
	del *.bak
	del *.sym
	del *.map
	del *.log
	del *.i

# END

