; NetWorkType%  by Tony Elliott
;                  EllTech Development, Inc.
;                  4374 Shallowford Ind. Parkway
;                  Marietta, GA 30066
;                  (404) 928-8960
;
; For VBits '93


.model medium
.code

    _OldInt24Seg    dw 0
    _OldInt24Offset dw 0
    _CritErrCode    dw 0

Public NetworkType
NetworkType proc far 

    ;From Basic:

    ;DECLARE FUNCTION NetworkType% ()

    ;SELECT CASE NetworkType%
    ;    CASE 0
    ;        PRINT "No network detected."
    ;    CASE 1
    ;        PRINT "Netware detected."
    ;    CASE 2
    ;        PRINT "Share (MS-DOS 3.1 compatible network) detected."
    ;END SELECT

    push ds
    push si
    push di

    mov ah,0dch                         ;Set up for Novell "Get Connection #"
    xor al,al
    int 21h
    or al,al                            ;Are we on a Novell?
    jz CheckForShare                    ;Nope
    mov ax,1                            ;We found it. Return a 1
    jmp short NWTExit

CheckForShare:
    call _GrabInt24h
    mov ax,5c00h                        ;Under a DOS window in Windows
    mov bx,3                            ; 3.x, the standard test for SHARE
    xor cx,cx                           ; always comes back true .. even
    mov dx,cx                           ; if share isn't actually installed.
    mov si,cx                           ;Here, we attempt to lock a region
    mov di,1                            ;of a device. If AX=1 on return
    int 21h                             ;SHARE really isn't there.
    cmp ax,1
    mov ax,0                        
    jz Continue                         ;It's not there
    mov ax,2                            ;If it is, return a 2

Continue:
    call _ReleaseInt24h

NWTExit:
    pop di
    pop si
    pop ds
    ret

NetworkType endp

;--------------------------------------------------------------------

_GrabInt24h proc near

    push ax                         
    push bx                         
    push dx
    push ds
    push es

    mov ax,3524h                    ;Get int 24h vector address
    int 21h
    mov cs:_OldInt24Seg,es
    mov cs:_OldInt24Offset,bx       ;Remember it for later restoration

    mov ax,2524h                    ;Point Int 24h to our code
    push cs
    pop ds
    Assume DS:@Code

    mov dx,offset OurInt24Handler
    int 21h

    pop es
    pop ds
    pop dx
    pop bx
    pop ax

    retn

OurInt24Handler:

    mov ax,di                           ;Put error code in ax
    xor ah,ah                           ;MSB "undefined", do zero it
    mov cs:_CritErrCode,ax              ;Hold a copy in our own variable
    mov al,3                            ;Tell DOS to cancel the function
    iret                                ;Back to DOS

_GrabInt24h endp

; ------------------------------------------------------------------------ 

_ReleaseInt24h proc near

    pushf
    push ax
    push dx
    push ds

    cmp cs:_OldInt24Seg,0           ;Is it actually hooked?
    jz ReleaseExit                  ;If not, exit
    
    mov ds,cs:_OldInt24Seg          ;If it is the last one, unhook
    mov dx,cs:_OldInt24Offset       ;Point ds:dx to old handler
    mov ax,2524h
    int 21h                         ;Restore original int 24h handler
    mov cs:_OldInt24Seg,0           ;Reset our flag

ReleaseExit:
    pop ds
    pop dx
    pop ax
    popf
    retn

_ReleaseInt24h endp

; ------------------------------------------------------------------------ 

_CheckForError proc near

    ;This is an internal routine called after a DOS function when our
    ; critical error handler is in effect. It checks to see if an actual
    ; error did occur, and if so, distinguishes between a critical and
    ; non-critical error. If a non-critical error occurred, 100 is added to
    ; the error code. Error codes <100 are critical errors.

    pushf                           ;Save the state of the flags
    cmp cs:_CritErrCode,0           ;Did a critical error occur?
    jz NonCriticalError             ;Nope. How about a non critical error?

    mov ax,cs:_CritErrCode          ;Put the critical error code into ax
    mov cs:_CritErrCode,0           ;Zero the flag
    popf                            ;Restore the flags
    stc                             ;Set the carry flag
    retn                            ;Return to code that called it

NonCriticalError:
    popf                            ;Restore the flags
    jnc ErrChkExit                  ;If no non-critical error, exit
    add ax,100                      ;Add 100 to error code to reflect non-critical error
    stc                             ;Make sure carry flag remains set
    retn

ErrChkExit:
    retn                            ;We're finihed

_CheckForError endp
end

