/******************************************************************************
      (C) Copyright 1992 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and 
      intended  to  work  solely  with  Autodesk, Inc. products, and 
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright  
      1992 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.

*******************************************************************************/

/* Interface for 3D Studio .SXP procedures */

#include <exprtn.h>

typedef struct {
	short id;
	char *s;
	} DlgEntry;

/* Color types used */

typedef struct	{
    uchar r,g,b;
	} Color_24;

typedef struct	{
    uchar r,g,b,a;
	} Color_32;

/* Handy type-conversion overlay */

typedef union {
	int i;
	float f;
	long l;
    ulong ul;
	Color_32 c;
	char *s;
	} OVL;

/*----------------------------------------------------------*/
/* Client process must supply these procedures:             */
/*  see exprtn.h for definition of Sxpdata                  */
/*----------------------------------------------------------*/

/* ClientStartup: allocate data structures, compute lookup tables, etc */

extern void ClientStartup();


/* ClientTerminate: Free any allocated memory */

extern void ClientTerminate();


/* ClientGetState: return a pointer to client's "state" structure,
	and stuff size of the struct into "size" variable */

extern char *ClientGetState(int *size);


/* ClientResetState: reset client state to default values. */

extern void ClientResetState();


/* Client3DText: the function for texture mapping: 
 based on the values in the fields in the Sxpdata record,
 the client computes an rgb value and stuffs it into 
 d->col, and optionally stuffs a value into d->shininess. */

extern void	Client3DText(Sxpdata *d);

/* Client3DOpac: the function for opacity mapping: 
 based on the values in the fields in the Sxpdata record,
 the client computes an rgb value and stuffs it into 
 d->col representing an opacity. */

extern void	Client3DOpac(Sxpdata *d);

/* Client3DBump: the function for bump mapping.
 based on the values in the fields in the Sxpdata record, client
 computes a normal perterbation stuffs it into d->norm_pert */

extern void	Client3DBump(Sxpdata *d);


/* ClientDialog: returns a pointer to the n'th DlgEntry struct
   in the user-defined DlgEntry array.	This array describes 
	a dialog window for setting parameters in the "state" struct.
	(This dialog is brought up in 3DStudio when the user clicks on
	the [S] "settings" button in the Material Editor)	*/

extern DlgEntry *ClientDialog(int n);


/* ClientSetStateVar: Assign a value (val) to the state variable
   corresponding to the DialogEntry whose id is "id" */

extern void ClientSetStateVar(int id, void *ptr);


/* ClientSetStateVar: Retrieve the value of the state variable
   corresponding to the Dialog Item whose id is "id" */
extern ulong ClientGetStateVar(int id);


/* ClientVarSize: Return the length of the state variable in doublewords
	(multiples of four bytes).  All variables must be padded to a
	multiple of four bytes */
extern int ClientVarSize(int id);

/* General-Purpose buffer */

extern char gp_buffer[];

/* Utility routines for copying memory */

extern void far_to_far(void _far *to,void _far *from,int size);
extern void far_to_near(void *to,void _far *from,int size);
extern void near_to_far(void _far *to,void *from,int size);
