/******************************************************************************
      (C) Copyright 1992 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and 
      intended  to  work  solely  with  Autodesk, Inc. products, and 
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright  
      1992 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.

*******************************************************************************/

/* For the Metaware High C and High C/C++ compilers, turn off an
   unwanted warning message */
#ifdef __HIGHC__
pragma Offwarn(67); /* kills "switch statement has no cases" warning */
#endif

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include "sxp.h"

#define LIM255(c) (((c)>=255)?255:(c))
#define  PI  3.1415926535
#define TWOPI 6.283185307
#define HALFPI 1.570796326794895

/* Variable definitions */

#define SIZE 1
#define COL1 4
#define COL2 5

/* The above definitions are the LineID numbers for the dialog lines in which the variables will be set. 
The integers assigned to the dialog lines containing variables are selected by the IPAS programmer and 
used by 3D Studio to identify the variables. */

/************************/

/* Dialog description */
DlgEntry cdialog[]={
	0,"TITLE=\"3D Ball Function (Animated)\"",		/* Text to appear in dialog box */
	SIZE, "LFLOAT=\"Size :\",0.0,10000.0",			/*  Setup for 'limited float' type 
								variable and associated range 
								values */
	0,"TITLE=\"\"",						/* Blank line for spacing */
	COL1,"COLOR=\"Color 1\"",				/* Setup for standard color triple 	
								slider dialog*/
	COL2,"-COLOR=\"Color 2\"",				/* Setup for standard color triple 	
								slider dialog*/
	0,"TITLE=\"\"",						/* Blank line for spacing */
	0,NULL
	};

/* State Structure definition */
/* Any variables whose values are set via dialog interface must be declared within the 'State' struct. */	
typedef struct {
	long version;
	float size;
	Col24 col1;
	Col24 col2;
	} BallState;
/* the "state" struct MUST start with a unique 'ulong' version number,
	used to prevent using data from old versions of this program */

/* Version test value */
/* Every external process must have a unique version number  */
#define BALL_VERS 0x7CD83

#define INIT_BALL  { BALL_VERS,60.0,{200,200,0},{0,30,0}}
static BallState init_state = INIT_BALL;				/* Initial state settings */
static BallState state = INIT_BALL;				/* Default state settings */

/*----------------------------------------------------------------*/

static void lerp_color(Col24 *c, Col24 *a, Col24 *b, float f) {
	int alph = (int)4096*f;
	int ialph = 4096-alph;
	c->r = (ialph*a->r + alph*b->r)>>12;
	c->g = (ialph*a->g + alph*b->g)>>12;
	c->b = (ialph*a->b + alph*b->b)>>12;
	}

static Col24 grey = {80,80,80};

/* The following function is a 'Client' procedure that defines a 3-dimensional function to modify the 
diffuse color and/or the shininess. This function is passed the SXPDATA structure contained in the 
EXPbuf, but has no access to packet commands or to other EXPbuf data structures. */

void Client3DText(Sxpdata  *sd) {
/****    int ix,iy,iz, k; */
	float mx,my,mz,r;
	float s2 = 2*state.size;
	float tot,phase,u;
	tot = (sd->totfields==0)?100.0:(float)sd->totfields;
	phase = ((float)sd->curfield)/tot;
	u = .5*(1.0+sin(TWOPI*(phase+.5)));
	mx = fmod(sd->p[0]+10000.0,s2)/state.size-1.0;
		my = fmod(sd->p[1]+10000.0,s2)/state.size-1.0;
	mz = fmod(sd->p[2]+10000.0,s2)/state.size-1.0;
	r = sqrt(mx*mx + my*my + mz*mz);
	if (r>1.0) 
		sd->col = grey;
	else {
		r = r*u;
		lerp_color(&sd->col,&state.col2,&state.col1,r);
		}
	}

/* The following function is a 'Client' procedure that defines a 3-dimensional function to compute an 
opacity value. This function is passed the SXPDATA structure contained in the EXPbuf, but has no access 
to packet commands or to other EXPbuf data structures. */

void Client3DOpac(Sxpdata *sd) {	Client3DText(sd);	}

/* The following function is a 'Client' procedure that defines a 3-dimensional function to compute a 
normal perturbation value. This function is passed the SXPDATA structure contained in the EXPbuf, but 
has no access to packet commands or to other EXPbuf data structures. */

void Client3DBump(Sxpdata *sd) {	}


/* Following function sets the appropriate 'State' variables based
   on the input from the dialog */
void ClientSetStateVar(int id, void *ptr) {
	OVL o;				/* Union of possible values that the dialog can return */
	ulong *ul;

	ul=(ulong *)ptr;
	o.ul = *ul;
	switch(id) {
		case SIZE:  state.size = o.f; break;			/* State variables set here based on
								values stored in the fields of the 
								Union type .*/
		case COL1: 					/* Set each field within the COL 
								variable in RGB format */
			state.col1.r = o.c.r;
			state.col1.g = o.c.g;
			state.col1.b = o.c.b;
			break;
		case COL2: 					/* Set each field within the COL 
								variable in RGB format */
			state.col2.r = o.c.r;
			state.col2.g = o.c.g;
			state.col2.b = o.c.b;
			break;
		}
	}

/* Following function sets the appropriate value of the Union 'OVL' variable
   to return values stored in the 'State' variable */
ulong ClientGetStateVar(int id) {
	OVL o;
	switch(id) {
		case SIZE: o.f = state.size; break;		/* Union variables set to appropriate value
							from 'state' variables */
		case COL1:
			o.c.r = state.col1.r;
			o.c.g = state.col1.g;
			o.c.b = state.col1.b;
			break;
		case COL2:
			o.c.r = state.col2.r;
			o.c.g = state.col2.g;
			o.c.b = state.col2.b;
			break;
		}
	return(o.ul);					/* the variable requested by 3D Studio is 
							returned to 3D Studio via the 'ulong' field
							of the 'Union' structure 'OVL'. */
	}

/* ---For most applications, the following functions will not change */

/* The following function performs any calculations necessary to the operation of 3DTEXT, 3DBUMP, or 
3DOPAC that cannot be performed within any of these functions. The 'ClientStartUp' procedure does not 
have access to packet-commands. */

void ClientStartup(void) {
	/* allocate data structures, compute lookup tables, etc */
	}

void ClientTerminate(void) { 	
	/* free any data structures, etc. */	
	}


/* Following function allows 3D Studio to determine the size of
   the 'State' structure and returns a pointer to the 'State' struct */

char *ClientGetState(int *size) {
	*size = sizeof(BallState);
	return((char *)&state);
	}

/* Following function allows 3D Studio to reset the state of the
   external process */

void ClientResetState() { state = init_state; }
	
/* The following function allows 3D Studio to get the address of a string containing a variable. The IPAS
programmer will not have to call this function or modify the following code, but will have to include it */

DlgEntry *ClientDialog(int n) {	return(&cdialog[n]); }

/* Following function allows 3D Studio to determine the size of
   any variable in the dialog */

int ClientVarSize(int id) {
	switch(id) {
		default:
			return(1);
		}
	}


