echo off
rem *
rem * Configuration is done by editing these lines of environment variables.
rem * Note that we use a fair amount of environment space, so some users
rem * may get the "out of environment space" error.  If they don't know
rem * how to fix it, they shouldn't be using this file, because if they
rem * were really hardcore, they would know.
rem *
set gf_source=A:
set gf_lib=GCP
set gf_ver=200
set gf_dir=GFCPP
set gf_dest=\%gf_dir%%gf_ver%
set gf_help1=exhelp
set gf_help2=winhelp
rem *
rem * This batch file is available for Greenleaf customers who
rem * don't like installation program.  It does most of the same
rem * things our installation program does, but doesn't do any
rem * hand-holding.  This batch file will install the library and
rem * all the pieces onto the \GFXXXX directory of the current
rem * drive.  It expects to find the library source on drive A.
rem *
rem * This batch file can be invoked from A.  It continues to
rem * re-invoke itself until the parameter is greater than GF_MAX_DISK,
rem * which means it is done.
rem *
IF NOT %1a==a GOTO DO_COPY
rem *
rem * Dest is where the files go, source is where they are found.
rem *
IF NOT exist %gf_dest%\NUL mkdir %gf_dest%
IF NOT exist %gf_dest%\bcpp31\NUL mkdir %gf_dest%\bcpp31
IF NOT exist %gf_dest%\msc70\NUL mkdir %gf_dest%\msc70
IF NOT exist %gf_dest%\msvc10\NUL mkdir %gf_dest%\msvc10
IF NOT exist %gf_dest%\asm_all\NUL mkdir %gf_dest%\asm_all
IF NOT exist %gf_dest%\asm_dos\NUL mkdir %gf_dest%\asm_dos
IF NOT exist %gf_dest%\asm_os2\NUL mkdir %gf_dest%\asm_os2
IF NOT exist %gf_dest%\asm_win\NUL mkdir %gf_dest%\asm_win
IF NOT exist %gf_dest%\c_all\NUL mkdir %gf_dest%\c_all
IF NOT exist %gf_dest%\c_dos\NUL mkdir %gf_dest%\c_dos
IF NOT exist %gf_dest%\c_os2\NUL mkdir %gf_dest%\c_os2
IF NOT exist %gf_dest%\c_win\NUL mkdir %gf_dest%\c_win
IF NOT exist %gf_dest%\cpp_all\NUL mkdir %gf_dest%\cpp_all
IF NOT exist %gf_dest%\cpp_dos\NUL mkdir %gf_dest%\cpp_dos
IF NOT exist %gf_dest%\cpp_os2\NUL mkdir %gf_dest%\cpp_os2
IF NOT exist %gf_dest%\cpp_win\NUL mkdir %gf_dest%\cpp_win
IF NOT exist %gf_dest%\h\NUL mkdir %gf_dest%\h
IF NOT exist %gf_dest%\demo_dos\NUL mkdir %gf_dest%\demo_dos
IF NOT exist %gf_dest%\demo_os2\NUL mkdir %gf_dest%\demo_os2
IF NOT exist %gf_dest%\demo_win\NUL mkdir %gf_dest%\demo_win
IF NOT exist %gf_dest%\docs\NUL mkdir %gf_dest%\docs
IF NOT exist %gf_dest%\help\NUL mkdir %gf_dest%\help
IF NOT exist %gf_dest%\examples\NUL mkdir %gf_dest%\examples
IF NOT exist %gf_dest%\misc\NUL mkdir %gf_dest%\misc
if exist %gf_source%\unarj.exe copy %gf_source%\unarj.exe %gf_dest%\misc\unarj.exe
cd %gf_dest%
if exist %gf_source%\hardcore.bat copy %gf_source%\hardcore.bat gf_temp.bat
if exist hardcore.bat copy hardcore.bat gf_temp.bat

gf_temp 1

:DO_COPY
set gf_next=error
if %1==1 set gf_next=2
if %1==2 set gf_next=3
if %1==3 set gf_next=4
if %1==4 set gf_next=5
if %1==5 set gf_next=6
if %1==6 set gf_next=7
if %1==7 set gf_next=8
if %1==8 set gf_next=9
if %1==9 set gf_next=10
if %gf_next%==error goto gf_error

echo Insert disk number %1 in %gf_source%
if not exist %gf_source%\src-next.dsk goto SKIP_MESSAGE
echo *
echo * If you don't want to open your source disk envelope, you can
echo * hit Control-Break now and exit safely.  Your libraries will
echo * be ready to use.
echo *
:SKIP_MESSAGE

pause
if exist %gf_source%\asm_all.arj       %gf_dest%\misc\unarj x %gf_source%\asm_all
if exist %gf_source%\asm_dos.arj       %gf_dest%\misc\unarj x %gf_source%\asm_dos
if exist %gf_source%\asm_os2.arj       %gf_dest%\misc\unarj x %gf_source%\asm_os2
if exist %gf_source%\asm_win.arj       %gf_dest%\misc\unarj x %gf_source%\asm_win
if exist %gf_source%\c_all.arj         %gf_dest%\misc\unarj x %gf_source%\c_all
if exist %gf_source%\c_dos.arj         %gf_dest%\misc\unarj x %gf_source%\c_dos
if exist %gf_source%\c_os2.arj         %gf_dest%\misc\unarj x %gf_source%\c_os2
if exist %gf_source%\c_win.arj         %gf_dest%\misc\unarj x %gf_source%\c_win
if exist %gf_source%\cpp_all.arj       %gf_dest%\misc\unarj x %gf_source%\cpp_all
if exist %gf_source%\cpp_dos.arj       %gf_dest%\misc\unarj x %gf_source%\cpp_dos
if exist %gf_source%\cpp_os2.arj       %gf_dest%\misc\unarj x %gf_source%\cpp_os2
if exist %gf_source%\cpp_win.arj       %gf_dest%\misc\unarj x %gf_source%\cpp_win
if exist %gf_source%\buildb.arj        %gf_dest%\misc\unarj x %gf_source%\buildb
if exist %gf_source%\buildm.arj        %gf_dest%\misc\unarj x %gf_source%\buildm
if exist %gf_source%\buildv.arj        %gf_dest%\misc\unarj x %gf_source%\buildv
if exist %gf_source%\include.arj       %gf_dest%\misc\unarj x %gf_source%\include
if exist %gf_source%\demo_dos.arj      %gf_dest%\misc\unarj x %gf_source%\demo_dos
if exist %gf_source%\demo_os2.arj      %gf_dest%\misc\unarj x %gf_source%\demo_os2
if exist %gf_source%\demo_win.arj      %gf_dest%\misc\unarj x %gf_source%\demo_win
if exist %gf_source%\demo-src.arj      %gf_dest%\misc\unarj x %gf_source%\demo-src
if exist %gf_source%\demo-exe.arj      %gf_dest%\misc\unarj x %gf_source%\demo-exe
if exist %gf_source%\docs.arj          %gf_dest%\misc\unarj x %gf_source%\docs
if exist %gf_source%\%gf_help1%.arj    %gf_dest%\misc\unarj x %gf_source%\%gf_help1%
if exist %gf_source%\%gf_help2%.arj    %gf_dest%\misc\unarj x %gf_source%\%gf_help2%
if exist %gf_source%\examples.arj      %gf_dest%\misc\unarj x %gf_source%\examples
if exist %gf_source%\misc.arj          %gf_dest%\misc\unarj x %gf_source%\misc

for %%a in ( s m c l h v sw mw cw lw dw ) if exist %gf_source%\%gf_lib%b%%a.arj %gf_dest%\misc\unarj x %gf_source%\%gf_lib%b%%a
for %%a in ( s m c l h v )             if exist %gf_source%\%gf_lib%t%%a.arj %gf_dest%\misc\unarj x %gf_source%\%gf_lib%t%%a
for %%a in ( s m c l h sw mw cw lw dw )   if exist %gf_source%\%gf_lib%m%%a.arj %gf_dest%\misc\unarj x %gf_source%\%gf_lib%m%%a
for %%a in ( s m c l )                 if exist %gf_source%\%gf_lib%c%%a.arj %gf_dest%\misc\unarj x %gf_source%\%gf_lib%c%%a
for %%a in ( s m c l h u sw mw cw lw ) if exist %gf_source%\%gf_lib%z%%a.arj %gf_dest%\misc\unarj x %gf_source%\%gf_lib%z%%a
for %%a in ( s m c l h sw mw cw lw dw )   if exist %gf_source%\%gf_lib%v%%a.arj %gf_dest%\misc\unarj x %gf_source%\%gf_lib%v%%a


if exist %gf_source%\last.dsk GOTO ALL_DONE
gf_temp %gf_next%

:GF_ERROR
echo *
echo * Something went wrong, terminating, installation not complete.
echo *

:ALL_DONE
set gf_source=
set gf_dest=
set gf_next=
set gf_lib=
set gf_ver=
set gf_help=
echo *
echo * Installation is complete. Feel free to delete GF_TEMP.BAT.
echo *
