/****************************************************************************
                   Microsoft RPC Version 1.0
                Copyright Microsoft Corp. 1992
                       nhello Example

    FILE:       nhellop.c
    
    PURPOSE:    Remote procedures that are linked with the server
                side of RPC distributed application
    
    FUNCTIONS:  TimeProc() - obtains the time from the server
    
    COMMENTS:

****************************************************************************/

#include <stdlib.h>
#include <stdio.h>   
#include <time.h>
#include "nhello.h"    // header file generated by MIDL compiler

void HelloProc(handle_t hHello, unsigned char *pszString)
{
    printf("%s\n", pszString);
    return;
}

void Shutdown(handle_t hHello)
{
    RPC_STATUS status;

    printf("Calling RpcMgmtStopServerListening\n");
    status = RpcMgmtStopServerListening(NULL);
    printf("RpcMgmtStopServerListening returned: 0x%x\n", status);
    if (status) {
        exit(status);
    }

    printf("Calling RpcServerUnregisterIf\n");
    status = RpcServerUnregisterIf(NULL, NULL, FALSE);
    printf("RpcServerUnregisterIf returned 0x%x\n", status);
    if (status) {
        exit(status);
    }
}

/* end file nhellop.c */
