/*-------------------------------------------------------------------------
* 
*   Directory Search Definitions
*
*         Intended to be used in conjunction with the DIR command to
*         search for and test for different file types
*/
;
;   In a two dimensional array the DIR command fills the array as follows
;
;   array(x,1) = file name
;   array(x,2) = file attribute
;   array(x,3) = file size
;   array(x,4) = Date and time as expressed in # of seconds since 1/1/70 12:00a
;
GLOBAL DIR_NAME = 1
GLOBAL DIR_ATTR = 2
GLOBAL DIR_SIZE = 3
GLOBAL DIR_DATETIME = 4

;
;   Intended to be used  with the optional USING clause with the DIR
;   command.  Example:
;
;        DIR "*.*"  USING FIND_DIRECTORY
;
;   would include directories in addition to normal files in its search.
;   Search attributes may be combined by adding.  Example
;
;        DIR "*.*" USING FIND_HIDDEN + FIND_SYSTEM
;
;   would find both hidden and system files.
;
GLOBAL FIND_NORMAL    = ^h00               ; Normal Files
GLOBAL FIND_HIDDEN    = ^h02               ; Includes Hidden Files
GLOBAL FIND_SYSTEM    = ^h04               ; Includes System Files
GLOBAL FIND_VOLUME    = ^h08               ; Finds the Volume Label
GLOBAL FIND_DIRECTORY = ^h10               ; Includes Directory Files

;
;   Intended to be used with the IS/ISNOT test in conjunction with the
;   DIR command.  Example:
;
;       IF fileattr IS TEST_DIRECTORY ...
;
;   Test attributes may be combined by adding.  The result would be true 
;   only if all attributes were true.
;
GLOBAL TEST_READONLY  = ^h0101             
GLOBAL TEST_HIDDEN    = ^h0202
GLOBAL TEST_SYSTEM    = ^h0404
GLOBAL TEST_VOLUME    = ^h0808
GLOBAL TEST_DIRECTORY = ^h1010
GLOBAL TEST_ARCHIVE   = ^h2020
                                                                                                                                                                                                                                                                   
