#include <stdio.h>
#include <dos.h>

/* size of file buffer */
#define BUFSIZE 4096

/* display to user every UPDATE bytes */
#define UPDATE  8192

/* 4 megabits default */
#define NUMSEGS 8

/* port data */

/*  use CP=37A for lpt2: */
#define CP      0x3be

/*  use DP=378 for lpt2: */
#define DP      0x3bc

/*  use IP=379 for lpt2: */
#define IP      0x3bd

#define LA      0xe1
#define MA      0xe2
#define HA      0xe3
#define NOPA    0xe0
#define HI_NYB  0xe0
#define LO_NYB  0xe8

void main(argc, argv)
int argc;
char *argv[];
{

unsigned char buffer[BUFSIZE], tmp, lo_nyb, hi_nyb;
long int numsegs=NUMSEGS, segment, page, byte, total=0, index = 0;
FILE *fp;

if (argc > 3) {
	printf("usage: readcart [filename] [megabits]\n");
	exit(1);
}

if (argc==3) {
   tmp=atoi(argv[2]);
   if ((tmp <1) || (tmp > 16)) {
	printf("usage: readcart [filename] [megabits]\n");
	printf ("%s %d\n", argv[2], tmp);
	exit(1);
	}
   numsegs=tmp * 2;
   }

if ((argc == 3) || (argc == 2)) {
	if ((fp = fopen(argv[1], "wb")) == NULL) {
		printf("Error opening file.\n");
		exit(1);
	}
}
else {
	if ((fp = fopen("game.dat", "wb")) == NULL) {
		printf("Error opening file.\n");
		exit(1);
	}
}



printf("\n\t\tGAME MEDIC\n");
printf("\t\t\tby The Silicon Valley Swappe Shoppe \n\n");

/* start code */
for (segment=0; segment < numsegs; segment++) {
  outportb (DP, segment);
  outportb (CP, HA);
  outportb (CP, NOPA);

  for (page=0; page <= 255 ; page++) {
    outportb (DP, page);
    outportb (CP, MA);
    outportb (CP, NOPA);

/* change the following line to 
    for (byte=0; byte<=255; byte+=2) {
 if using this with the Super Nintendo
*/
    for (byte=0; byte <= 255 ; byte++) {
      outportb(DP, byte);
      outportb(CP, LA);

      outportb(CP, HI_NYB);
      tmp = inportb(IP);
      hi_nyb = (tmp ^ 0x80) & 0xf0;

      outportb(CP, LO_NYB);

      tmp= inport(IP);
      lo_nyb = (tmp ^ 0x80) & 0xf0;
      lo_nyb = lo_nyb >> 4;

      buffer[index++]=lo_nyb | hi_nyb;
      total++;
      }
    if ((total % BUFSIZE) == 0)
	{
	fwrite(buffer, sizeof(unsigned char), BUFSIZE, fp);
	index=0;
	}
    if ((total % UPDATE) ==0)
	printf("Read %8ld bytes from cartridge\r", total);
    }
  }

fclose(fp);
printf ("\007\007");
}
