#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <dir.h>

#define U_ACTIVE 0x5b4
#define U_START  0x5b6
#define U_STOP   0x5ba

#define U_NAME1 0x1f8
#define U_NAME2 0x4d2

#define U_STATE1 2
#define U_STATE2 0x2dc

#define U_SampRate1 0x50
#define U_SampRate2 0x32a

#define SWAPFILE "stk.swp"


#define  min(a,b)    (((a) < (b)) ? (a) : (b))

#define  TMPNAME   "ECHO.TMP"

#define  TRANSSIZE 40960u
unsigned char trans_buf[TRANSSIZE];

/*
  Transmit (size) bytes from one file to another
  starting from current file pointer positions
  Use trans_buf array
*/
long trans(int h_in,int h_out,long size)
{
 long count=0l;
 while(size>0l)
 {
  unsigned part=(unsigned)(min(size,TRANSSIZE));
  if((part=_read(h_in,trans_buf,part))==0xFFFF)return(-1);
  if((part=_write(h_out,trans_buf,part))==0xFFFF)return(-1);
  if(eof(h_in))break;
  size-=part;
  count+=part;
 }
 return(count);
}


/* Strarting from position "start"+"sh" up to "stop" in file "name"
   calc samples,usind :
    Z[t]=( Z[t]+Z[t-sh]/2 )/2             [1]
   providing a simple echo effect

  function use file echo.tmp as a temporary buffer
*/

reverb(char *name,long start,long stop,unsigned sh)
{int h,ht;
 long l,step=start;

 if((h=_open(name,O_RDWR|O_BINARY))==-1)
  {printf("Can't open file");return 0;}

 if(sh >= TRANSSIZE)
  {printf("Parameter SH is too large");return 0;}

 if((ht=_creat(TMPNAME,0))==-1)
  {printf("Can't create file");return 0;}

 stop=min(stop,filelength(h));

 while(step+sh < stop)
 {  unsigned part=(unsigned)(min(stop-step+sh,TRANSSIZE));
    int i;

    if(lseek(h,step,SEEK_SET)==-1){printf("File operation error");return 0;}
    if(read(h,trans_buf,part)==-1){printf("File operation error");return 0;}

    for(i=part-1;i>=sh;i--)/* transform data by [1] */
     trans_buf[i]=(((int)trans_buf[i]-128+(((int)trans_buf[i-sh]-128)>>1))>>1)+128;

    if(write(ht,&trans_buf[sh],part-sh)==-1){printf("File operation error");return 0;}
    step+=part-sh;
 }

 if(lseek(h,start+sh,SEEK_SET)==-1){printf("File operation error");return 0;}
 if(lseek(ht,0,SEEK_SET)==-1){printf("File operation error");return 0;}
 if(trans(ht,h,stop-start-sh)==-1){printf("File operation error");return 0;}

 close(ht);
 close(h);
 unlink(TMPNAME);
 return 1;
}


main(int argv ,char *argc[])
{
int h,out;
unsigned SampleRate,shift;
long start,stop;
int  active;
char fname[MAXPATH];

printf("\nCall user function.Parameter : %s",argc[1]);

if((h=open(SWAPFILE,O_RDONLY|O_BINARY))==-1) //open file with control data
  {printf("Can't open file ");return 0;}

if(lseek(h,U_ACTIVE,SEEK_SET)==-1)         //read start value
  {printf("I/O Error");return 0;}
if(read(h,&active,sizeof(int))==-1)
  {printf("Error read file");return 0;}

if(lseek(h,U_START,SEEK_SET)==-1)        //read start value
  {printf("I/O Error");return 0;}
if(read(h,&start,sizeof(long))==-1)
  {printf("Error read file");return 0;}

if(lseek(h,U_STOP,SEEK_SET)==-1)         //read stop value
  {printf("I/O Error");return 0;}
if(read(h,&stop,sizeof(long))==-1)
  {printf("Error read file");return 0;}


if(active==0)
{ //active first frame
if(lseek(h,U_SampRate1,SEEK_SET)==-1)     //read Sampling rate value
  {printf("I/O Error");return 0;}
if(read(h,&SampleRate,sizeof(int))==-1)
  {printf("Error read file");return 0;}

if(lseek(h,U_NAME1,SEEK_SET)==-1)         //read the name of work file
  {printf("I/O Error");return 0;}
if(read(h,fname,MAXPATH)==-1)
  {printf("Error read file");return 0;}
}
else
{//second frame is active
if(lseek(h,U_SampRate2,SEEK_SET)==-1)     //read Sampling rate value
  {printf("I/O Error");return 0;}
if(read(h,&SampleRate,sizeof(int))==-1)
  {printf("I/O Error");return 0;}

if(lseek(h,U_NAME2,SEEK_SET)==-1)         //read the name of work file
  {printf("I/O Error");return 0;}
if(read(h,fname,MAXPATH)==-1)
  {printf("I/O Error");return 0;}
}

close(h);
printf("\nCall user function for temporary file %s\n",fname);
printf("SampleRate  %d\n",SampleRate);
printf("Start from %ld to %ld\n",start,stop);
shift=atol(argc[1])*SampleRate/1000;
if(shift==0)shift=1000;
printf("Delay %f ms\n",(long)shift*1000./SampleRate);
out=reverb(fname,start,stop,shift);
printf("Press any key");
getch();
return(out);
}
