@ECHO OFF
rem  OPTUNE.EXE NEEDS TO BE IN THE PATH YOUR SYSTEM USES TO SEARCH
rem  FOR EXE (AND BAT AND COM) FILES WHEN THIS BATCH FILE IS RUN.
if not ''=='%1' goto do
echo You must specify a drive (or partition) to optimize.
goto batch_end
:DO
CLS
ECHO This batch file will attempt to optimize drive %1.  If any
ECHO errors are encountered, it will attempt to fix the errors
ECHO before continuing.
ECHO 
ECHO 
rem  The following command performs packed optimization :
:RUN_OPT
OPTUNE %1 /OP

rem  Now, we need to test the errorlevel returned.  These codes
rem  must be tested from highest to lowest, or this batch file
rem  may not work properly.

IF ERRORLEVEL 27 GOTO USER_ABORT
IF ERRORLEVEL 26 GOTO BAD_COMMAND
IF ERRORLEVEL 10 GOTO DISK_CACHE
IF ERRORLEVEL 8 GOTO CHECK_DISK
IF ERRORLEVEL 7 GOTO NO_MEMORY
IF ERRORLEVEL 6 GOTO FATAL_ERR
IF ERRORLEVEL 4 GOTO NO_MEMORY
IF ERRORLEVEL 3 GOTO VERIFY_DISK
IF ERRORLEVEL 2 GOTO NO_DRIVE
IF ERRORLEVEL 1 GOTO BAD_FAT

ECHO 
ECHO No problems running OPTune!
GOTO BATCH_END

:BAD_COMMAND
ECHO 
ECHO OPTune did not understand the command it was given.
ECHO Please edit this batch file to correct the command
ECHO before using it again.
GOTO BATCH PAUSE

:BAD_FAT
ECHO 
ECHO Either the FAT or the directories are bad.  Press any key
ECHO to run OPTune's Check-Disk command to try to fix them.
ECHO 
PAUSE
GOTO RUN_CHECK

:NO_DRIVE
ECHO 
ECHO The drive you specified was not available.  Please
ECHO either modify this batch file to use the correct drive,
ECHO or make sure that the drive is available before using
ECHO OPTune.
GOTO BATCH_PAUSE

:VERIFY_DISK
ECHO 
ECHO OPTune will attempt to fix your disk problems. Press
ECHO any key to run OPTune's Verify/Fix-Disk command.
ECHO 
PAUSE
OPTUNE %1 /V
IF ERRORLEVEL 27 GOTO USER_ABORT
IF ERRORLEVEL 1 GOTO CANNOT_FIX
GOTO RUN_CHECK

:NO_MEMORY
ECHO 
ECHO OPTune needs either more RAM or more disk space available
ECHO before it can operate on your system.
GOTO BATCH_PAUSE

:FATAL_ERR
ECHO 
ECHO OPTune encountered a fatal error.  You must manually use
ECHO the Check-Disk command and/or the Verify/Fix-Disk command
ECHO before OPTune will operate from the batch file.
ECHO 
GOTO BATCH_PAUSE

:CHECK_DISK
ECHO 
ECHO Press any key to run Check-Disk to fix errors on drive C.
ECHO 
PAUSE

:RUN_CHECK
ECHO 
OPTUNE %1 /CF
IF ERRORLEVEL 27 GOTO USER_ABORT
IF ERRORLEVEL 1 GOTO CANNOT_FIX
GOTO RUN_OPT

:DISK_CACHE
ECHO 
ECHO OPTune sensed a dangerous type of disk caching with which
ECHO it cannot successfully operate.  Please turn disk caching
ECHO off before running OPTune, or run OPTune before your disk
ECHO caching is activated
ECHO 
GOTO BATCH_PAUSE

:USER_ABORT
ECHO 
ECHO The user pressed the ESC key to terminate early!
ECHO 
GOTO :BATCH_PAUSE

:CANNOT_FIX
ECHO 
ECHO Sorry!  OPTune could not completely fix the errors.
ECHO 
 
:BATCH_PAUSE
PAUSE
:BATCH_END
