/*****************************************************************************
 *
 *  nullsurf.sl
 *  Copyright (C) 1991-1992 by Autodesk, Inc.
 *
 *  Permission to use, copy, modify, and distribute this software
 *  for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  all supporting documentation.
 *
 *  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
 *  WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
 *  PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.
 *
 ****************************************************************************/
/*****************************************************************************
 *  R12 Render
 *
 *  Updated (LTK - 2/92) to include the new_color parameter for R12 Render.
 *
 *  AutoShade v2.0 default Surface shader for SURFACE option of C:RMPROP.
 ****************************************************************************/

surface
nullsurf    (
        float   Ka  = 0.3,
                Kd  = 0.7,
                Ks  = 0.0,
                roughness = 0.1;
        color   new_color = -1
            )
{
    varying vector Nf, NI;

    Nf = faceforward( normalize(N), I);

    /* If new_color >= 0, use the new_color value for the surface color, Cs */
    if (comp(new_color, 0) >= 0)
        Cs = new_color;

    Ci = Cs * (Ka*ambient() + Kd*diffuse(Nf));
    if (Ks != 0.0)
    {
        NI =  normalize(-I);
        Ci += Ks * specular(Nf,NI,roughness);
    }
    Oi = Os;
    Ci = Os * Ci;
}