/* Next available MSG number is 279 */

/*    Copyright (C) 1991-1992 by Autodesk, Inc.

*****************************************************************************
*                                                                           *
*     Permission to use, copy, modify, and distribute this software         *
*     for any purpose and without fee is hereby granted, provided           *
*     that the above copyright notice appears in all copies and that        *
*     both that copyright notice and this permission notice appear in       *
*     all supporting documentation.                                         *
*                                                                           *
*     THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED          *
*     WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR       *
*     PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.                 *
*                                                                           *
*****************************************************************************
*/

//****************************************************************************
//
// AVE Render Dialogue Control Language (DCL) -- Version 1.0
//
//****************************************************************************

// Change level to 3 for new DCL auditing.  Clean 6/15/92.
dcl_settings : default_dcl_settings { audit_level = 0; }

//****************************************************************************
//

pref : dialog {
    label = /*MSG1*/"Rendering Preferences";
    spacer_1;
    : row {
        : column {
            : boxed_radio_column {
                label = /*MSG2*/"Rendering Type";
                key = /*MSG0*/"pf_st";
                : radio_button {
                    key = /*MSG0*/"pf_st_30";
                    label = /*MSG3*/"Full Render";
                    mnemonic = /*MSG4*/"F";
                }
                : radio_button {
                    key = /*MSG0*/"pf_st_40";
                    label = /*MSG5*/"Quick Render";
                    mnemonic = /*MSG6*/"Q";
                }
                : radio_button {
                    key = /*MSG0*/"pf_st_60";
                    label = /*MSG7*/"ACAD RenderMan";
                    mnemonic = /*MSG8*/"R";
                }
            }
            : boxed_column {
                width = 12;
                label = /*MSG9*/"Select Query";
                : popup_list {
                    mnemonic = /*MSG250*/"Q";
                    key = /*MSG0*/"pf_rs";
                    list = /*MSG10*/"Select All\nMake Selection";
                }
            }
        }
        : boxed_column {
            label = /*MSG11*/"Rendering Options";
            : toggle {
                key = /*MSG0*/"pf_ss";
                label = /*MSG12*/"Smooth Shading";
                mnemonic = /*MSG13*/"S";
            }
            : toggle {
                key = /*MSG0*/"pf_mo";
                label = /*MSG14*/"Merge";
                mnemonic = /*MSG15*/"M";
            }
            : toggle {
                key = /*MSG0*/"pf_af";
                label = /*MSG16*/"Apply Finishes";
                mnemonic = /*MSG17*/"A";
            }
            : button {
                key = /*MSG0*/"Options";
                label = /*MSG18*/"More Options...";
                mnemonic = /*MSG19*/"O";
            }
        }
    }
    spacer_1;
    : row {
        : boxed_radio_column {
            label = /*MSG20*/"Destination";
            key = /*MSG0*/"pf_ds";
            : radio_button {
                key = /*MSG0*/"pf_ds_20";
                label = /*MSG21*/"Framebuffer";
                mnemonic = /*MSG22*/"b";
            }
            : radio_button {
                key = /*MSG0*/"pf_ds_30";
                label = /*MSG23*/"Hardcopy";
                mnemonic = /*MSG24*/"H";
            }
        }
        : boxed_radio_column {
            alignment = top;
            label = /*MSG25*/"Color Map Usage";
            key = /*MSG0*/"pf_ac";
            : radio_button {
                key = /*MSG0*/"pf_ac_30";
                label = /*MSG26*/"Best Map/No Fold";
                mnemonic = /*MSG27*/"N";
            }
            : radio_button {
                key = /*MSG0*/"pf_ac_20";
                label = /*MSG28*/"Best Map/Fold";
                mnemonic = /*MSG29*/"e";
            }
            : radio_button {
                key = /*MSG0*/"pf_ac_10";
                label = /*MSG30*/"Fixed ACAD Map";
                mnemonic = /*MSG31*/"M";
            }
        }
        : boxed_column {
            label = /*MSG32*/"Settings";
            : toggle {
                key = /*MSG0*/"pf_rm";
                label = /*MSG33*/"RMan Prompting";
                mnemonic = /*MSG34*/"P";
            }
            : edit_box_8 {
                label = /*MSG35*/"Icon Scale:";
                key = /*MSG0*/"pf_ic_tx";
                mnemonic = /*MSG36*/"I";
            }
        }
    }
    : row {
        : button {
            label = /*MSG37*/"Information...";
            key = /*MSG0*/"Info";
            mnemonic = /*MSG38*/"t";
        }
        : button {
            label = /*MSG39*/"Reconfigure <";
            key = /*MSG0*/"Reconfigure";
            mnemonic = /*MSG40*/"c";
        }
    }
    spacer_1_ok_cancel_help_errtile;
}

//***************************************************************************
// Support dialog box code

var_text : text_part { label = ""; }

//***************************************************************************
// Information dialog box

pref_info : dialog {
    label = /*MSG43*/"Render Information";
    spacer_1;
    : text_part {
        alignment = centered;
        label = /*MSG251*/"AutoCAD Visualization Extension";
    }
    : var_text {
        alignment = centered;
        key = /*MSG0*/"prodname";
    }
    : var_text {
        alignment = centered;
        key = /*MSG0*/"cyears";
    }
    : text_part {
        alignment = centered;
        label = /*MSG44*/"by Autodesk, Inc.  All Rights Reserved.";
    }
    : var_text {
        alignment = centered;
        key = /*MSG0*/"release";
    }
    spacer_1;
    : text_part {
        alignment = left;
        label = /*MSG45*/"Current Configuration:";
    }
    : concatenation {
        : text_part { label = /*MSG46*/"Rendering: "; }
        : var_text {
            key = /*MSG0*/"rendering";
            width = 60;
        }
    }
    : concatenation {
        : text_part { label = "           "; }
        : var_text {
            key = /*MSG0*/"rendname";
            width = 60;
        }
    }
    : concatenation {
        : text_part { label = /*MSG47*/"Hard copy: "; }
        : var_text {
            key = /*MSG0*/"hardcopy";
            width = 60;
        }
    }
    : concatenation {
        : text_part { label = "           "; }
        : var_text {
            key = /*MSG0*/"hardname";
            width = 60;
        }
    }
    spacer_1;
    : paragraph {
        children_alignment = centered;
        : text_part { label = /*MSG48*/"Use,  duplication or disclosure by the U.S. Government is"; }
        : text_part { label = /*MSG49*/"subject to  restrictions as set forth  in  FAR  52.227-19"; }
        : text_part { label = /*MSG50*/"(Commercial Computer Software-Restricted Rights) and DFAR"; }
        : text_part { label = /*MSG51*/"252.227-7013 (c) (1) (ii)  (Rights in Technical Data  and"; }
        : text_part { label = /*MSG52*/"Computer Software), as applicable."; }
    }
    spacer_1_ok_only;
}

//***************************************************************************
// Options dialog

value_5 : text_part {
    width = 5;
    label = "";
}

output_mode : boxed_radio_column {
    label = "Output Mode";
    key = /*MSG0*/"output";
    : radio_button {
        key = /*MSG0*/"color";
        label = /*MSG277*/"Color";
        mnemonic = "C";
    }
    : radio_button {
        key = /*MSG0*/"black_and_white";
        label = /*MSG278*/"Black and White";
        mnemonic = "W";
    }
}

separations : boxed_column {
    label = /*MSG54*/"Separation";
    : toggle {
        key = /*MSG0*/"red_component";
        label = /*MSG55*/"Red Component";
        mnemonic = /*MSG56*/"R";
        fixed_width = true;
    }
    : toggle {
        key = /*MSG0*/"green_component";
        label = /*MSG57*/"Green Component";
        mnemonic = /*MSG58*/"G";
        fixed_width = true;
    }
    : toggle {
        key = /*MSG0*/"blue_component";
        label = /*MSG59*/"Blue Component";
        mnemonic = /*MSG60*/"B";
        fixed_width = true;
    }
    : toggle {
        key = /*MSG0*/"BW_separation";
        label = /*MSG61*/"B&W Separations";
        mnemonic = /*MSG62*/"S";
        fixed_width = true;
    }
}

other_options : column {
    : toggle {
        key = /*MSG0*/"discard_bf";
        label = /*MSG63*/"Discard Back Faces";
        mnemonic = /*MSG64*/"D";
    }
    : toggle {
        key = /*MSG0*/"neg_normal";
        label = /*MSG65*/"Back Face Normal is Negative";
        mnemonic = /*MSG66*/"N";
    }
}

full_options : dialog {
    label = /*MSG67*/"Full Render Options";
    spacer_1;
    : row {
        : column { output_mode; spacer; separations; }
        spacer_1;
        : column {
            fixed_height = true;
            alignment = top;
            : toggle {
                key = /*MSG0*/"intersect";
                label = /*MSG68*/"Intersection";
                mnemonic = /*MSG69*/"I";
            }
            : toggle {
                key = /*MSG0*/"obscuration";
                label = /*MSG70*/"Sort by Obscuration";
                mnemonic = /*MSG71*/"O";
            }
            other_options;
            : edit_box_8  {
                key = /*MSG0*/"sort";
                label = /*MSG72*/"Sort Round Off: ";
            }
            : edit_box_8 {
                label = /*MSG73*/"Chop Round Off: ";
                key = /*MSG0*/"chop";
            }
        }
    }
    spacer_1_ok_cancel_help_errtile;
}

quick_options : dialog {
    label = /*MSG74*/"Quick Render Options";
    spacer_1;
    : row {
        : column { output_mode; spacer; separations; }
        spacer_1;
        : column {
            fixed_height = true;
            alignment = top;
            other_options;
        }
    }
    spacer_1_ok_cancel_help_errtile;
}

rman_options : dialog {
    label = /*MSG75*/"RenderMan Options";
    spacer_1;
    : text_part { label = /*MSG76*/"RenderMan is not yet implemented. "; }
    ok_button;
}

//***************************************************************************
// Statistics dialog box

ave_stats : dialog {
    label = /*MSG77*/"Statistics";
    width = 50;
    spacer_1;
    : var_text { key = /*MSG0*/"name"; }
    : var_text { key = /*MSG0*/"stype"; }
    : var_text { key = /*MSG0*/"stime"; }
    : var_text { key = /*MSG0*/"record"; }
    : var_text { key = /*MSG0*/"faces"; }
    : var_text { key = /*MSG0*/"triangles"; }
    : var_text { key = /*MSG0*/"overlaps"; }
    : var_text { key = /*MSG0*/"chops"; }
    spacer_1;
    : var_text { key = /*MSG0*/"ox"; }
    : var_text { key = /*MSG0*/"oy"; }
    : var_text { key = /*MSG0*/"oz"; }
    spacer_1;
    : var_text { key = /*MSG0*/"px"; }
    : var_text { key = /*MSG0*/"py"; }
    : var_text { key = /*MSG0*/"pz"; }
    spacer_1;
    : row {
        alignment = centered;
        fixed_width = true;
        width = 39;
        : toggle {
            label = "";
            key = /*MSG0*/"save_stats";
            height = 1;
        }
        : edit_box {
            label = /*MSG78*/"Save statistics to file:";
            key = /*MSG0*/"stats_name";
            edit_width = 14;
            edit_limit = 132;
        }
    }
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
// Color selection dialog box

color_name : text_part {
    width = 11;
    label = "";
}

color_image : image {
    height = 1;
    aspect_ratio = 1;
    fixed_height = true;
    fixed_width = true;
    color = -15;         /* -15 = dialog backround color */
}

system : row {
    : popup_list {
        label = /*MSG79*/"Color System";
        mnemonic = /*MSG252*/"C";
        key = /*MSG0*/"color_system";
        list = "";
    }
}

aci : button {
    key = /*MSG0*/"select_aci";
    label = /*MSG81*/"Select from ACI...";
    mnemonic = /*MSG82*/"S";
}


components : column {
    : row {
        : concatenation {
            : color_name    { key = /*MSG0*/"top_name"; }
            : edit_box_4    { key = /*MSG0*/"top_edit"; }
        }
        : color_image       { key = /*MSG0*/"top_image"; }
    }
    : slider_0_1            { key = /*MSG0*/"top_slider"; }
    : row {
        : concatenation {
            : color_name    { key = /*MSG0*/"middle_name"; }
            : edit_box_4    { key = /*MSG0*/"middle_edit"; }
        }
        : color_image       { key = /*MSG0*/"middle_image"; }
    }
    : slider_0_1            { key = /*MSG0*/"middle_slider"; }
    : row {
        : concatenation {
            : color_name    { key = /*MSG0*/"bottom_name"; }
            : edit_box_4    { key = /*MSG0*/"bottom_edit"; }
        }
        : color_image       { key = /*MSG0*/"bottom_image"; }
    }
    : slider_0_1            { key = /*MSG0*/"bottom_slider"; }
}

description : column {
    system;
    components;
    spacer_1;
    aci;
    spacer_1;
    : column {
        children_alignment = centered;
        : text_part { label = /*MSG80*/"Color selected"; }
        : boxed_row {
            fixed_width = true;
            : image {
                key = /*MSG0*/"patch";
                height = 2;
                aspect_ratio = 2;
                fixed_width = true;
                color = -15;             /* backround color */
            }
        }
    }
    spacer_1;
}

ave_color : dialog {
    label = /*MSG83*/"Color";
    spacer_1;
    : row {
    spacer_1;
        description;
    spacer_1;
        : image_button {
            key = /*MSG0*/"color_wheel";
            height = 16;
            aspect_ratio = 1;
            color = -15;       /* dialog box backround color = -15*/
        }
        : slider_0_1 {
            key = /*MSG0*/"lightness_slider";
            layout = vertical;
        }
    spacer_1;
    }
    spacer_1_ok_cancel_help_errtile;
}

ave_color_1 : dialog {
    label = /*MSG83*/"Color";
    spacer_1;

    system;
    components;
    aci;

    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
//

replay : dialog {
    label = /*MSG84*/"Image Specifications";
    width = 22;
    alignment = centered;
    spacer;
    : row {
        fixed_width = true;
        alignment = centered;
        : text_part { label = /*MSG85*/"Image Name:"; }
        : edit_box_256 { key = /*MSG0*/"name"; }
    }
    spacer;
    : cluster {
        alignment = centered;
        : row {
            : text_part {
                key = /*MSG0*/"imgsz";
                width = 16;
            }
        }
        : row {
            : text_part {
                key = /*MSG0*/"winsz";
                width = 16;
            }
        }
    }
    spacer;
    : cluster {
        : image_button {              // Virtual image window
            key = /*MSG0*/"vimg";
            color = 0;
            alignment = centered;
            aspect_ratio = 1;
            height = 6;
            width = 16;
            fixed_width = true;
            fixed_height = true;
        }
        : image_button {              // Virtual window window
            key = /*MSG0*/"vwin";
            color = 0;
            alignment = centered;
            aspect_ratio = 1;
            height = 6;
            width = 16;
            fixed_width = true;
            fixed_height = true;
        }
    }
    spacer;
    : cluster {
        alignment = centered;
        : row {
            : text_part { label = /*MSG88*/" Image Offset"; }
                width = 16;
        }
        : row {
            : text_part { label = /*MSG89*/" Screen Offset"; }
                width = 16;
        }
    }
    spacer;
    : row {
        fixed_width = true;
        alignment = centered;
        : edit_box_4 { 
            label = /*MSG90*/"X:";
            key = /*MSG0*/"imgoffx"; 
        }
        : edit_box_4 { 
            label = /*MSG91*/"Y:";
            key = /*MSG0*/"imgoffy"; 
        }
        : edit_box_4 { 
            label = /*MSG92*/" X:";
            key = /*MSG0*/"winoffx"; 
        }
        : edit_box_4 { 
            label = /*MSG93*/"Y:";
            key = /*MSG0*/"winoffy"; 
        }
    }
    spacer;
    : cluster {
        alignment = centered;
        : row {
            : text_part { label = /*MSG94*/" Image Size"; }
                width = 16;
        }
        : row {
            : text_part { label = /*MSG95*/" Screen Size"; }
                width = 16;
        }
    }
    spacer;
    : row {
        fixed_width = true;
        alignment = centered;
        : edit_box_4 { 
            label = /*MSG96*/"X:";
            key = /*MSG0*/"imgsizex"; 
        }
        : edit_box_4 { 
            label = /*MSG97*/"Y:";
            key = /*MSG0*/"imgsizey"; 
        }
        : concatenation {
            : text_part { 
                label = /*MSG98*/" X:  ";
            }
            : text_part { 
                key = /*MSG0*/"winsizex"; 
                width = 4; 
            }
        }
        : concatenation {
            : text_part { 
                label = /*MSG99*/"Y:  ";
            }
            : text_part { 
                key = /*MSG0*/"winsizey"; 
                width = 4; 
            }
        }
    }
    spacer;
    : button {
        key = /*MSG0*/"rst";
        mnemonic = /*MSG253*/"R";
        label = /*MSG100*/"Reset";
        fixed_width = true;
        alignment = centered;
    }
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
//  saveimg rendering combined

saveimgrc : dialog {
    label = /*MSG101*/"Save Image";
    spacer;
    : row {
        : text_part { label = /*MSG102*/"Image Name:"; }
        : edit_box_100 { key = /*MSG0*/"name"; }
        fixed_width = true;
        alignment = centered;
    }
    spacer;
    : row {
        : text_part { label = /*MSG103*/"Directory :"; }
        : edit_box_256 { key = /*MSG0*/"dir"; }
        fixed_width = true;
        alignment = centered;
    }
    spacer;
    : cluster {
        : boxed_radio_column {
            label = /*MSG104*/"Format   ";
            key = /*MSG0*/"frmt";
            : radio_button {
                label = /*MSG105*/"TGA";
                key = /*MSG0*/"tga";
            }
            : radio_button {
                label = /*MSG106*/"TIFF";
                key = /*MSG0*/"tif";
            }
            : radio_button {
                label = /*MSG107*/"GIF";
                key = /*MSG0*/"gif";
            }
            : radio_button {
                label = /*MSG108*/"RND";
                key = /*MSG0*/"rnd";
            }
        }
        : boxed_radio_column {
            label = /*MSG109*/"Portion   ";
            key = /*MSG0*/"prtn";
            : radio_button {
                label = /*MSG110*/"Active viewport";
                key = "A";
            }
            : radio_button {
                label = /*MSG111*/"Drawing area";
                key = "D";
            }
            : radio_button {
                label = /*MSG112*/"Full screen";
                key = "F";
            }
        }
    }
    spacer;
    : cluster {
        : button {
            key = /*MSG0*/"opt";
            label = /*MSG113*/"Options...";
            mnemonic = /*MSG114*/"O";
        }
        : button {
            key = /*MSG0*/"rst";
            label = /*MSG115*/"Reset";
            mnemonic = /*MSG254*/"R";
        }
    }
    spacer;
    : row {
        fixed_width = true;
        alignment = centered;
        : text_part { label = /*MSG116*/"   Offset "; }
        : edit_box_4 { 
            label = /*MSG117*/"X:";
            key = /*MSG0*/"winoffx"; 
        }
        : edit_box_4 { 
            label = /*MSG118*/" Y:";
            key = /*MSG0*/"winoffy"; 
        }
    }
    : row {
        fixed_width = true;
        alignment = centered;
        : text_part { label = /*MSG119*/"     Size "; }
        : edit_box_4 { 
            label = /*MSG120*/"X:";
            key = /*MSG0*/"winsizex"; 
        }
        : edit_box_4 { 
            label = /*MSG121*/" Y:";
            key = /*MSG0*/"winsizey"; 
        }
    }
    : row {
        : concatenation {
            : text_part { label = /*MSG122*/"Default "; }
            : text_part { key = /*MSG0*/"winsz"; width = 9; }
        }
        fixed_width = true;
        alignment = centered;
    }
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
//  saveimg rendering seperate

saveimgrs : dialog {
    label = /*MSG123*/"Save Image";
    spacer;
    : row {
        : text_part { label = /*MSG124*/"Image Name:"; }
        : edit_box_100 { key = /*MSG0*/"name"; }
        fixed_width = true;
        alignment = centered;
    }
    spacer;
    : row {
        : text_part { label = /*MSG125*/"Directory :"; }
        : edit_box_256 { key = /*MSG0*/"dir"; }
        fixed_width = true;
        alignment = centered;
    }
    spacer;
    : cluster {
        : boxed_radio_column {
            label = /*MSG126*/"Format   ";
            key = /*MSG0*/"frmt";
            : radio_button {
                label = /*MSG127*/"TGA";
                key = /*MSG0*/"tga";
            }
            : radio_button {
                label = /*MSG128*/"TIFF";
                key = /*MSG0*/"tif";
            }
            : radio_button {
                label = /*MSG129*/"GIF";
                key = /*MSG0*/"gif";
            }
            : radio_button {
                label = /*MSG130*/"RND";
                key = /*MSG0*/"rnd";
            }
        }
        : boxed_column {
            label = /*MSG131*/"Portion   ";
            : image_button {              // Virtual window window
                key = /*MSG0*/"vwin";
                color = 0;
                alignment = centered;
                aspect_ratio = 1;
                height = 6;
                width = 16;
                fixed_width = true;
                fixed_height = true;
            }
        }
    }
    spacer;
    : cluster {
        : button {
            key = /*MSG0*/"opt";
            label = /*MSG132*/"Options";
            mnemonic = /*MSG133*/"O";
        }
        : button {
            key = /*MSG0*/"rst";
            label = /*MSG134*/"Reset";
            mnemonic = /*MSG255*/"R";
        }
    }
    spacer;
    : row {
        fixed_width = true;
        alignment = centered;
        : text_part { label = /*MSG135*/"   Offset "; }
        : edit_box_4 { 
            label = /*MSG136*/"X:";
            key = /*MSG0*/"winoffx"; 
        }
        : edit_box_4 { 
            label = /*MSG137*/" Y:";
            key = /*MSG0*/"winoffy"; 
        }
    }
    : row {
        fixed_width = true;
        alignment = centered;
        : text_part { label = /*MSG138*/"     Size "; }
        : edit_box_4 { 
            label = /*MSG139*/"X:";
            key = /*MSG0*/"winsizex"; 
        }
        : edit_box_4 { 
            label = /*MSG140*/" Y:";
            key = /*MSG0*/"winsizey"; 
        }
    }
    : row {
        : concatenation {
            : text_part { label = /*MSG141*/"Default "; }
            : text_part { key = /*MSG0*/"winsz"; width = 9; }
        }
        fixed_width = true;
        alignment = centered;
    }
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
//

tga_options : dialog {
    label = /*MSG142*/"TGA Options";
    spacer;
    : boxed_radio_row {
        label = /*MSG143*/"Compression:";
        key = /*MSG0*/"comp";
        : radio_button {
            label = /*MSG144*/"None";
            mnemonic = /*MSG256*/"N";
            key = /*MSG0*/"none";       // returned as "value" of radio_cluster
        }
        : radio_button {
            label = /*MSG145*/"RLE";
            mnemonic = /*MSG257*/"R";
            key = /*MSG0*/"rle";
        }
    }
    spacer_1_ok_cancel_help;
}

//****************************************************************************
//

tif_options : dialog {
    label = /*MSG146*/"TIFF Options";
    spacer;
    : boxed_radio_row {
        label = /*MSG147*/"Compression:";
        key = /*MSG0*/"comp";
        : radio_button {
            label = /*MSG148*/"None";
            mnemonic = /*MSG258*/"N";
            key = /*MSG0*/"none";       // returned as "value" of radio_cluster
        }
        : radio_button {
            label = /*MSG149*/"PACK";
            mnemonic = /*MSG259*/"P";
            key = /*MSG0*/"pack";
        }
        : radio_button {
            label = /*MSG150*/"LZW";
            mnemonic = /*MSG260*/"L";
            key = /*MSG0*/"lzw";
        }
    }
    spacer_1_ok_cancel_help;
}

//****************************************************************************
// Main light dialog.

ave_light : dialog {
    label = "Lights";
    : row {
        : list_box_8x8 {
            key = /*MSG0*/"list";
            label = /*MSG151*/"Lights";
            mnemonic = /*MSG261*/"L";
        }
        : column {
            spacer_0;
            button_new;
            button_mod;
            button_del;
            button_pkt;
            spacer_0;
        }
    }
    spacer;
    : column {
        children_alignment = centered;
        : edit_box_4 {
            label = /*MSG152*/"Ambient Light:";
            key = /*MSG0*/"ambient_t";
            mnemonic = /*MSG153*/"A";
        }
        : slider_0_1 { key = /*MSG0*/"ambient_s"; }
        : boxed_radio_column {
            label = /*MSG154*/"Point Light Fall-off";
            key = /*MSG0*/"falloff";
            : radio_button {
                label = /*MSG155*/"None";
                mnemonic = /*MSG156*/"o";
                key = "0";      // returned as "value" of radio_cluster
            }
            : radio_button {
                label = /*MSG157*/"Inverse Linear";
                mnemonic = /*MSG158*/"I";
                key = "1";
            }
            : radio_button {
                label = /*MSG159*/"Inverse Square";
                mnemonic = /*MSG160*/"S";
                key = "2";
            }
        }
    }
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
// Dialog to select new light type.

ave_light_new : dialog {
    label = /*MSG161*/"New Light Type";
    children_alignment = centered;
    : boxed_radio_column {
        label = /*MSG162*/"Select Light Type:";
        key = /*MSG0*/"lgt_type";
        : radio_button {
            label = /*MSG163*/"Point Light";
            mnemonic = /*MSG164*/"P";
            key = /*MSG0*/"overhead";       // returned as "value" of radio...
        }                                   // block name to insert!
        : radio_button {
            label = /*MSG165*/"Distant Light";
            mnemonic = /*MSG166*/"D";
            key = /*MSG0*/"direct";
        }
        : radio_button {
            label = /*MSG167*/"Spotlight";
            mnemonic = /*MSG168*/"S";
            key = /*MSG0*/"sh_spot";
        }
    }
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
// Dialog to edit the currently selected Point or Distant light definition.

ave_light_mod : dialog {
    key = /*MSG0*/"dialog";
    basic_lights;
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
// Dialog to edit the currently selected Spot light definition.

ave_spotlight_mod : dialog {
    key = /*MSG0*/"dialog";
    basic_lights;
    spot_lights;
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
// Tile used by all three light types.

basic_lights : column {
    : edit_box_8 {
        label = /*MSG171*/"Light Name:";
        key = /*MSG0*/"name";
        mnemonic = /*MSG172*/"N";
    }
    : edit_box_8 {
        label = /*MSG173*/"Intensity:";
        key = /*MSG0*/"inten_t";
        mnemonic = /*MSG174*/"I";
    }
    : slider  {
        key = /*MSG0*/"inten_s";
        min_value = 0;
        max_value = 10000;
        small_increment = 100;
        big_increment = 1000;
    }
    : boxed_row {
        label = /*MSG175*/"Position";
        : button {
            label = /*MSG176*/"Modify <";
            key = /*MSG0*/"mod_points";
            mnemonic = /*MSG177*/"M";
        }
        : button {
            label = /*MSG178*/"Show...";
            key = /*MSG0*/"show_points";
            mnemonic = /*MSG179*/"S";
            other = "1";
        }
    }
    : button {
        label = /*MSG180*/"Modify Light Color...";
        mnemonic = /*MSG181*/"L";
        key = /*MSG0*/"mod_color";
    }
    : edit_box_8 {
        label = /*MSG182*/"Depth Map Size:";
        key = /*MSG0*/"depth_t";
        mnemonic = /*MSG183*/"D";
    }
    : slider {
        key = /*MSG0*/"depth_s";
        min_value = 0;
        max_value = 6;
        small_increment = 1;
        big_increment = 1;
    }
}

//****************************************************************************
// Tile used only by Spot lights.

spot_lights : column {
    : edit_box_8 {
        label = /*MSG184*/"Cone Angle:";
        key = /*MSG0*/"conea_t";
        mnemonic = /*MSG185*/"C";
    }
    : slider {
        key = /*MSG0*/"conea_s";
        min_value = 0;
        max_value = 90;
        small_increment = 1;
        big_increment = 10;
    }
    : edit_box_8 {
        label = /*MSG186*/"Cone Delta Angle:";
        key = /*MSG0*/"coned_t";
        mnemonic = /*MSG187*/"A";
    }
    : slider {
        key = /*MSG0*/"coned_s";
        min_value = 0;
        max_value = 90;
        small_increment = 1;
        big_increment = 10;
    }
    : edit_box_8 {
        label = /*MSG188*/"Beam Distribution:";
        key = /*MSG0*/"beamd_t";
        mnemonic = /*MSG189*/"B";
    }
    : slider {
        key = /*MSG0*/"beamd_s";
        min_value = 0;
        max_value = 90;
        small_increment = 1;
        big_increment = 10;
    }
}

//****************************************************************************
//  Display the Location and Target points of lights.  Target should be
//  disabled when displaying a Point Light.

show_points : dialog {
    label = /*MSG190*/"Show Light Position";
    : row {
        : boxed_row {
            key = /*MSG0*/"location";
            label = /*MSG191*/"Location";
            : paragraph {
                : text_part { label = /*MSG192*/"X ="; }
                : text_part { label = /*MSG193*/"Y ="; }
                : text_part { label = /*MSG194*/"Z ="; }
            }
            : paragraph {
                : text_part_12 { key = /*MSG0*/"lfx"; }
                : text_part_12 { key = /*MSG0*/"lfy"; }
                : text_part_12 { key = /*MSG0*/"lfz"; }
            }
        }
        : boxed_row    {
            key = /*MSG0*/"target";     //  Disabled for Point Lights
            label = /*MSG195*/"Target";
            : paragraph {
                : text_part { label = /*MSG196*/"X ="; }
                : text_part { label = /*MSG197*/"Y ="; }
                : text_part { label = /*MSG198*/"Z ="; }
            }
            : paragraph {
                : text_part_12 { key = /*MSG0*/"lax"; }
                : text_part_12 { key = /*MSG0*/"lay"; }
                : text_part_12 { key = /*MSG0*/"laz"; }
            }
        }
    }
    spacer_1_ok_help;
}

//****************************************************************************
// Main scene dialog

ave_scene : dialog {
    label = "Scenes";
    : row {
        : list_box_8x8 {
            key = /*MSG0*/"scen";
            label = /*MSG203*/"Scenes";
            mnemonic = /*MSG262*/"S";
        }
        : column {
            spacer_0;
            button_new;
            button_mod;
            button_del;
            spacer_0;
        }
    }
    spacer_1_ok_cancel_help;
}

//****************************************************************************
// Dialog to modify a scene.

ave_scene_mod : dialog {
    key = /*MSG0*/"dialog";
    : edit_box_8 {
        label = /*MSG205*/"Scene Name:";
        key = /*MSG0*/"name";
        mnemonic = /*MSG206*/"N";
    }
    spacer;
    : row {
        : list_box_8x8 {
            key = /*MSG0*/"view";
            label = /*MSG207*/"Views";
            mnemonic = /*MSG263*/"V";
        }
        : list_box_8x8 {
            key = /*MSG0*/"lght";
            label = /*MSG208*/"Lights";
            mnemonic = /*MSG264*/"L";
            multiple_select = true;
        }
    }
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
// Main finishes dialog

ave_finish : dialog {
    label = "Finishes";
    : row {
        : list_box_8x8 {
            key = /*MSG0*/"list";
            label = /*MSG209*/"Finishes";
            mnemonic = /*MSG265*/"F";
            width = 13;      // 8 char name - 2 spaces - ACI
            tabs = "10";     // Place ACI two spaces after the name
        }
        : column {
            spacer_0;
            button_new;
            button_mod;
            button_del;
            button_imp;
            button_exp;
            button_pkt;
            spacer_0;
        }
    }
    : boxed_row {
        label = /*MSG210*/"Attach";
        key = /*MSG0*/"attach";
        : button {
            label = /*MSG211*/"Entities <";
            key = /*MSG0*/"entities";
            mnemonic = /*MSG266*/"E";
        }
        : button {
            label = /*MSG212*/"ACI...    ";
            key = /*MSG0*/"ACI";
            mnemonic = /*MSG267*/"A";
        }
    }
    spacer_1_ok_cancel_help;
}

//****************************************************************************
// Dialog to choose preset finishes.

finish_preset : dialog {
    label = /*MSG213*/"Import Preset Finish";
    : row {
        : list_box_8x8 {
            key = /*MSG0*/"name";
            label = /*MSG268*/"Presets";
            mnemonic = /*MSG269*/"P";
            allow_accept = true;
            width = 11;             //  OW chops off the last char.
        }
        finish_preview;
    }
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
// Dialog to modify a finish.

ave_finish_mod : dialog {
    key = /*MSG0*/"dialog";
    : edit_box_8 {
        label = /*MSG215*/"Finish Name:";
        key = /*MSG0*/"name";
        mnemonic = /*MSG216*/"N";
    }
    : boxed_column {
        label = /*MSG217*/"Color";
        : row {
            : button {
                key = /*MSG0*/"def_color";
                label = /*MSG218*/"Use Entity Color";
                mnemonic = /*MSG270*/"E";
            }
            : button {
                key = /*MSG0*/"set_color";
                label = /*MSG219*/"  Set Color...  ";
                mnemonic = /*MSG271*/"C";
            }
        }
        : concatenation {
            alignment = centered;
            : text_part { label = /*MSG220*/"Current Color = "; }
            : text_part {
                key = /*MSG0*/"cur_color";
                width = 14;
            }
        }
    }
    : row {
        : boxed_column {
            label = /*MSG221*/"Settings";
            : edit_box_4 {
                label = /*MSG222*/"Ambient:";
                key = /*MSG0*/"Ka_T";
                mnemonic = /*MSG223*/"A";
            }
            : slider_0_1 { key = /*MSG0*/"Ka_S"; }
            : edit_box_4 {
                label = /*MSG224*/"Diffuse:";
                key = /*MSG0*/"Kd_T";
                mnemonic = /*MSG225*/"D";
            }
            : slider_0_1 { key = /*MSG0*/"Kd_S"; }
            : edit_box_4 {
                label = /*MSG226*/"Specular:";
                key = /*MSG0*/"Ks_T";
                mnemonic = /*MSG227*/"S";
            }
            : slider_0_1 { key = /*MSG0*/"Ks_S"; }
            : edit_box_4 {
                label = /*MSG228*/"Roughness:";
                key = /*MSG0*/"rough_T";
                mnemonic = /*MSG229*/"R";
            }
            : slider_0_1 { key = /*MSG0*/"rough_S"; }
        }
        finish_preview;
    }
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
// Finish ACI tile.

ave_finish_aci : dialog {
    label = /*MSG230*/"Attach by AutoCAD Color Index";
    : edit_box_4 {
        label = /*MSG231*/"Selected ACI:";
        key = /*MSG0*/"text";
        mnemonic = /*MSG232*/"S";
    }
    : list_box_8x8 {
        key = /*MSG0*/"index";
        label = /*MSG272*/"ACI";
        mnemonic = /*MSG273*/"A";
        allow_accept = true;
    }
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
// Finish Preview tile.

finish_preview : boxed_column {
    label = /*MSG233*/"Preview";
    spacer_0;
    children_alignment = centered;
    : image_button {
        key = /*MSG0*/"image";
        color = graphics_background;
        height = 8;
        aspect_ratio = 1;
        fixed_height = true;
        fixed_width = true;
        mnemonic = /*MSG274*/"P";     //  FIXME - Can we ALT to an image???
    }
    : button {
        key = /*MSG0*/"object";
        label = /*MSG234*/"Preview Finish";
        mnemonic = /*MSG271*/"P";
    }
    spacer_0;
}

//****************************************************************************
// Define common widgets

button_new : button {
    key = /*MSG0*/"new";
    label = /*MSG236*/"New...   ";
    mnemonic = /*MSG237*/"N";
}

button_mod : button {
    key = /*MSG0*/"modify";
    label = /*MSG238*/"Modify...";
    mnemonic = /*MSG239*/"M";
    is_enabled = false;     // Enable when Items are selected.
}

button_del : button {
    key = /*MSG0*/"delete";
    label = /*MSG240*/"Delete   ";
    mnemonic = /*MSG241*/"D";
    is_enabled = false;     // Enable when Items are selected.
}

button_imp : button {
    key = /*MSG0*/"import";
    label = /*MSG242*/"Import...";
    mnemonic = /*MSG243*/"I";
}

button_exp : button {
    key = /*MSG0*/"export";
    label = /*MSG244*/"Export   ";
    mnemonic = /*MSG245*/"x";
}

button_pkt : button {
    key = /*MSG0*/"pickit";
    label = /*MSG246*/"Pick <   ";
    mnemonic = /*MSG247*/"P";
}

//****************************************************************************
// For showing real numbers.

text_part_12 : text_part { width = 12; }

//****************************************************************************
// Standard size list_box

list_box_8x8 : list_box {
    height = 8;          // (10x10) width includes scrollbar.
}

//****************************************************************************
// For File name, where max filename = 100.

edit_box_100 : edit_box {
    edit_width = 14;
    edit_limit = 100;
}

//****************************************************************************
// For Directory paths , where max pathname = 256.

edit_box_256 : edit_box {
    edit_width = 14;
    edit_limit = 256;
}

//****************************************************************************
// For File names and the like.

edit_box_14 : edit_box {
    edit_width = 14;
    edit_limit = 14;
}

//****************************************************************************
// For names that are <= 8 characters long.

edit_box_8 : edit_box {
    edit_width = 8;
    edit_limit = 8;
}

//****************************************************************************
// For real numbers 0.00->1.00.

edit_box_4 : edit_box {
    edit_width = 4;
    edit_limit = 4;
}

//****************************************************************************
// For real numbers 0.00->1.00.

slider_0_1 : slider {
    min_value = 0;
    max_value = 100;
    small_increment = 1;
    big_increment = 10;
    is_tab_stop = false;        //  We have edit_boxes for all
}

//****************************************************************************
//  Dialogs with Cancel as the default.

cancel_ok_48 : dialog {
    width = 48;
    key = /*MSG0*/"dialog";
    initial_focus = /*MSG276*/"cancel"; // Doesn't work allways
    children_alignment = centered;
    spacer_1;
    : var_text { key = /*MSG0*/"line1"; }
    : var_text { key = /*MSG0*/"line2"; }
    cancel_ok;                          // Makes "Cancel" the default.
}
cancel_ok_32 : dialog {
    width = 32 ;
    key = /*MSG0*/"dialog";
    initial_focus = /*MSG276*/"cancel"; // Doesn't work allways
    children_alignment = centered;
    spacer_1;
    : var_text { key = /*MSG0*/"line1"; }
    : var_text { key = /*MSG0*/"line2"; }
    cancel_ok;                          // Makes "Cancel" the default.
}

//****************************************************************************
//  Generic botton-line button combinations

spacer_1_ok_cancel_help_errtile : column {
    spacer_1;
    ok_cancel_help_errtile;
}

spacer_1_ok_cancel_help : column {
    spacer_1;
    ok_cancel_help;
}

spacer_1_ok_help : column {
    spacer_1;
    : row {
        fixed_width = true;
        alignment = centered;
        : ok_button { is_cancel = true; }
        : spacer { width = 2; }
        help_button;
    }
}

spacer_1_ok_only : column {
    spacer_1;
    ok_only;
}

//****************************************************************************
//

cancel_ok : column {        // Makes "Cancel" the default.
    spacer_1;
    : row {
        fixed_width = true;
        alignment = centered;
        : ok_button { is_default = false; }
        : spacer { width = 2; }
        : cancel_button { is_default = true; }
    }
}
//****************************************************************************
