
/***************
**
**  gecos.c
**  last revised: april 10, 1992
**
**  Gecos version 1.00 alpha, Copyright (C)1992 Zabkar
**  DESPERATE password-cracker 1.0 alpha using HADES engine by Remote.
**
**  Gecos creates a dictionary from all gecos-fields from the passwordlist
**  on stdin or the file, specified with the -f switch. Output is written on
**  stdout or the file defined with the -o switch.
**
**  Usage: gecos [-c] [-l] [-1] [-r] [-n] [-a] [-f passwordfile] [-o outfile]
**
**  root@waves.hacktic.nl (Zabkar)
**  root@room101.hacktic.nl (Remote)
**
*/

#include <stdio.h>
#include <string.h>
#include "dictword.h"
#include "pwd.h"


FILE *outfile;
FILE *infile;

extern FILE *_pw_file;


/***************
 haltusage()
 prints correct usage and exits
****************/

void haltusage()
{
  fprintf(stderr,
  "Gecoslist version 1.00 alpha, Copyright (C)1992 Zabkar\n"\
  "DESPERATE password-cracker 1.0 alpha using HADES engine by Remote.\n\n"\
  "Usage: gecos [-c] [-l] [-1] [-r] [-n] [-f passwordfile] "\
  "[-o outfile]\n\n"\
  "\t-c: capitalize whole word\n"\
  "\t-l: lowercase whole word\n"\
  "\t-1: all lowercase, first uppercase\n"\
  "\t-r: all selected options reversed, too\n"\
  "\t-a: allways write all gecos-words, do not check syntax\n"\
  "\t-f: read from 'passwordfile' instead of stdin\n"\
  "\t-o: write to 'outfile' instead of stdout\n\n"\
  "Use of one of the options c, l or 1 causes the normal word to disapear,\n"\
  "to have the normal form back again, add the -n switch.\n\n"\
  "no -f specified: passwordfile read from stdin\n"\
  "no -o specified: output written to stdout\n");
  exit(0);
}



/***************
 creategecoslist()
 creates a userlist from input given on file inf and writes output to
 file of. All conversions of mode are taken care of.
****************/

void creategecoslist(FILE *inf, FILE *of, int mode)
{
    struct passwd *buf;
    char buffer[256];
    char dest[256];
    char words[15][80];
    int i,j,k;

    _pw_file = inf;

    while ((buf=getpwent()) != NULL)
    {
       /* make words */
       j=0;
       k=0;
       for (i=0; i<strlen(buf->pw_gecos); i++)
       {
          if ((isspace(buf->pw_gecos[i])) || (ispunct(buf->pw_gecos[i])))
          {
            if (k>2)
              {
              words[j][k] = '\0';
              j++;       /* next word */
              k=0;
              }
            else
              k=0;

          }
          else if ((mode & CHECK) && !isalpha(buf->pw_gecos[i]))
            { k=0; }
          else
            words[j][k++] = buf->pw_gecos[i];
       }
       if (k>0)
            words[j++][k] = '\0';

       for (i=0; i<j; i++)
       {
         strcpy(buffer, "");
         if (mode & NORMAL || mode & EXTNORMAL)
         {
            strcat(buffer, words[i]);
            strcat(buffer, "\n");
         }

         if (mode & LOWER)
         {
            strcat(buffer, all_lower(dest, words[i]));
            strcat(buffer, "\n");
         }

         if (mode & UPPER)
         {
            strcat(buffer, all_upper(dest, words[i]));
            strcat(buffer, "\n");
         }

         if (mode & FIRSTUP)
         {
            strcat(buffer, first_upper(dest, words[i]));
            strcat(buffer, "\n");
         }

         if (mode & REVERSE)
         {
            reverse(dest, buffer);    /* reverse of all the above */
            strcat(buffer, &dest[1]); /* strip leading newline */
            strcat(buffer, "\n");     /* add line-feed to end */
         }

         fprintf(of, "%s", buffer);   /* Print all words on of */
       }
    }
}



/***************
 main()
 main function of gecos
****************/

main(char argc, char **argv)
{
  char fname[80], oname[80];
  int i;
  int convmode = NORMAL | CHECK;

  strcpy(fname, "");
  strcpy(oname, "");

  if (argc > 1)
  {
    for (i=1; i<argc; i++)
    {
      switch(argv[i][0])
      {
      case '-': switch(toupper(argv[i][1]))
		  {
            case 'F' : if (strlen(argv[i]) > 2)
                 strcpy(fname, &argv[i][2]);
			       else if (argc < (i+2))
                 haltusage();
			       else
				 strcpy(fname, argv[++i]);
			       break;
            case 'O' : if (strlen(argv[i]) > 2)
                 strcpy(oname, &argv[i][2]);
			       else if (argc < (i+2))
                 haltusage();
			       else
				 strcpy(oname, argv[++i]);
			       break;
            case 'C': convmode |= UPPER; convmode &= ~NORMAL; break;
            case 'L': convmode |= LOWER; convmode &= ~NORMAL; break;
            case '1': convmode |= FIRSTUP; convmode &= ~NORMAL; break;
            case 'R': convmode |= REVERSE; break;
            case 'N': convmode |= EXTNORMAL; break;
            case 'A': convmode &= ~CHECK; break;
            default  : haltusage();
		  }
          break;
      default : haltusage();
      }
    }
  }

  if (strcmp(fname,""))
    infile = fopen(fname, "rt");
  else
    infile = stdin;

  if (!infile)
    {
    fprintf(stderr, "gecos: %s: couldn't open file\n", fname);
    exit(0);
    }

  if (strcmp(oname, ""))
    outfile = fopen(oname, "wt");
  else
    outfile = stdout;

  if (!outfile)
    {
    fprintf(stderr, "gecos: %s: could't create file\n", oname);
    exit(0);
    }

  creategecoslist(infile, outfile, convmode);

  fclose(infile);
  fclose(outfile);

  }

/* EOF GECOS.C */
